/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class RegistrationParameters
implements Serializable {
    private final ServerProperty serverProperty;
    private final boolean userVerificationRequired;
    private final boolean userPresenceRequired;
    private final List<String> expectedExtensionIds;

    public RegistrationParameters(ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired, List<String> expectedExtensionIds) {
        this.serverProperty = serverProperty;
        this.userVerificationRequired = userVerificationRequired;
        this.userPresenceRequired = userPresenceRequired;
        this.expectedExtensionIds = CollectionUtil.unmodifiableList(expectedExtensionIds);
    }

    public RegistrationParameters(ServerProperty serverProperty, boolean userVerificationRequired, boolean userPresenceRequired) {
        this(serverProperty, userVerificationRequired, userPresenceRequired, null);
    }

    public RegistrationParameters(ServerProperty serverProperty, boolean userVerificationRequired) {
        this(serverProperty, userVerificationRequired, true);
    }

    public ServerProperty getServerProperty() {
        return this.serverProperty;
    }

    public boolean isUserVerificationRequired() {
        return this.userVerificationRequired;
    }

    public boolean isUserPresenceRequired() {
        return this.userPresenceRequired;
    }

    public List<String> getExpectedExtensionIds() {
        return this.expectedExtensionIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationParameters that = (RegistrationParameters)o;
        return this.userVerificationRequired == that.userVerificationRequired && this.userPresenceRequired == that.userPresenceRequired && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.expectedExtensionIds, that.expectedExtensionIds);
    }

    public int hashCode() {
        return Objects.hash(this.serverProperty, this.userVerificationRequired, this.userPresenceRequired, this.expectedExtensionIds);
    }
}

