/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import com.oracle.svm.core.annotate.AlwaysInline;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.wildfly.common.lock.SpinLock;

final class LoggerNode {
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private final ConcurrentMap<String, LoggerNode> children;
    private final AtomicReference<Handler[]> handlersRef = new AtomicReference();
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private volatile boolean useParentFilter = false;
    private volatile Level level;
    private volatile int effectiveLevel;
    private final int effectiveMinLevel;
    private volatile boolean hasLogger;
    private final SpinLock attachmentLock = new SpinLock();
    private Logger.AttachmentKey<?> att1Key;
    private Object att1;
    private Logger.AttachmentKey<?> att2Key;
    private Object att2;
    private Logger.AttachmentKey<?> att3Key;
    private Object att3;

    LoggerNode(LogContext context) {
        EmbeddedConfigurator configurator = LogContext.CONFIGURATOR;
        this.parent = null;
        this.fullName = "";
        Level minLevel = configurator.getMinimumLevelOf(this.fullName);
        this.effectiveMinLevel = minLevel == null ? Logger.INFO_INT : minLevel.intValue();
        Level confLevel = configurator.getLevelOf(this.fullName);
        this.level = confLevel == null ? Level.INFO : confLevel;
        this.effectiveLevel = Math.max(this.effectiveMinLevel, this.level.intValue());
        this.handlersRef.set(configurator.getHandlersOf(this.fullName));
        this.context = context;
        this.children = new CopyOnWriteMap<String, LoggerNode>();
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        EmbeddedConfigurator configurator = LogContext.CONFIGURATOR;
        nodeName = nodeName.trim();
        if (nodeName.length() == 0 && parent == null) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace and has no parent");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? (nodeName.isEmpty() ? "." : nodeName) : parent.fullName + "." + nodeName;
        Level minLevel = configurator.getMinimumLevelOf(this.fullName);
        this.effectiveMinLevel = minLevel == null ? parent.effectiveMinLevel : minLevel.intValue();
        this.level = configurator.getLevelOf(this.fullName);
        this.effectiveLevel = Math.max(this.effectiveMinLevel, this.level == null ? parent.effectiveLevel : this.level.intValue());
        this.handlersRef.set(configurator.getHandlersOf(this.fullName));
        this.context = context;
        this.children = new CopyOnWriteMap<String, LoggerNode>();
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    Logger createLogger() {
        this.hasLogger = true;
        return new Logger(this, this.fullName);
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    LogContext getContext() {
        return this.context;
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            for (LoggerNode node : this.children.values()) {
                if (node == null) continue;
                node.setEffectiveLevel(newLevel);
            }
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    boolean getUseParentFilters() {
        return this.useParentFilter;
    }

    void setUseParentFilters(boolean useParentFilter) {
        this.useParentFilter = useParentFilter;
    }

    @AlwaysInline(value="Fast level checks")
    int getEffectiveLevel() {
        return this.effectiveLevel;
    }

    @AlwaysInline(value="Fast level checks")
    boolean isLoggableLevel(int level) {
        return level != Logger.OFF_INT && level >= this.effectiveMinLevel && level >= this.effectiveLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler[] getHandlers() {
        Handler[] handlers = this.handlersRef.get();
        if (handlers == null) {
            LoggerNode loggerNode = this;
            synchronized (loggerNode) {
                handlers = LogContext.CONFIGURATOR.getHandlersOf(this.fullName);
                this.handlersRef.set(handlers);
            }
        }
        return handlers;
    }

    Handler[] clearHandlers() {
        return this.setHandlers(EmbeddedConfigurator.NO_HANDLERS);
    }

    void removeHandler(Handler handler) {
        block0: while (true) {
            Handler[] handlers = this.getHandlers();
            int length = handlers.length;
            for (int i = 0; i < length; ++i) {
                if (handlers[i] != handler) continue;
                Handler[] newHandlers = Arrays.copyOf(handlers, length - 1);
                System.arraycopy(handlers, i + 1, newHandlers, i, length - i - 1);
                if (!this.compareAndSetHandlers(handlers, newHandlers)) continue block0;
                return;
            }
            break;
        }
    }

    void addHandler(Handler handler) {
        Handler[] newVal;
        Handler[] oldVal;
        do {
            oldVal = this.getHandlers();
            int len = oldVal.length;
            newVal = Arrays.copyOf(oldVal, len + 1);
            newVal[len] = handler;
        } while (!this.handlersRef.compareAndSet(oldVal, newVal));
    }

    Handler[] setHandlers(Handler[] handlers) {
        return this.handlersRef.getAndSet(handlers);
    }

    boolean compareAndSetHandlers(Handler[] oldHandlers, Handler[] newHandlers) {
        return this.handlersRef.compareAndSet(oldHandlers, newHandlers);
    }

    boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    void publish(ExtLogRecord record) {
        LoggerNode parent;
        for (Handler handler : this.getHandlers()) {
            try {
                handler.publish(record);
            }
            catch (Exception e) {
                ExtHandler.reportError(handler, "Handler publication threw an exception", e, 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.useParentHandlers && (parent = this.parent) != null) {
            parent.publish(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLevel(Level newLevel) {
        Object lock;
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            int newEffectiveLevel;
            int oldEffectiveLevel = this.effectiveLevel;
            if (newLevel != null) {
                this.level = newLevel;
                newEffectiveLevel = newLevel.intValue();
            } else {
                LoggerNode parent = this.parent;
                if (parent == null) {
                    this.level = Level.INFO;
                    newEffectiveLevel = Logger.INFO_INT;
                } else {
                    this.level = null;
                    newEffectiveLevel = parent.effectiveLevel;
                }
            }
            this.effectiveLevel = newEffectiveLevel;
            if (oldEffectiveLevel != newEffectiveLevel) {
                for (LoggerNode node : this.children.values()) {
                    if (node == null) continue;
                    node.setEffectiveLevel(newEffectiveLevel);
                }
            }
        }
    }

    Level getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V getAttachment(Logger.AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            Object object = key == this.att1Key ? this.att1 : (key == this.att2Key ? this.att2 : (key == this.att3Key ? this.att3 : null));
            return (V)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    <V> V attach(Logger.AttachmentKey<V> key, V value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            Logger.AttachmentKey<?> attachmentKey = this.att1Key;
            if (attachmentKey == null) {
                this.att1Key = key;
                this.att1 = value;
                V v = null;
                return v;
            }
            if (key == attachmentKey) {
                Object object = this.att1;
                return (V)object;
            }
            attachmentKey = this.att2Key;
            if (attachmentKey == null) {
                this.att2Key = key;
                this.att2 = value;
                V v = null;
                return v;
            }
            if (key == attachmentKey) {
                Object object = this.att2;
                return (V)object;
            }
            attachmentKey = this.att3Key;
            if (attachmentKey == null) {
                this.att3Key = key;
                this.att3 = value;
                V v = null;
                return v;
            }
            if (key == attachmentKey) {
                Object object = this.att3;
                return (V)object;
            }
        }
        finally {
            lock.unlock();
        }
        throw new IllegalStateException("Maximum number of attachments exceeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V detach(Logger.AttachmentKey<V> key) {
        SpinLock lock;
        block18: {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            lock = this.attachmentLock;
            lock.lock();
            if (key == this.att1Key) {
                Object object = this.att1;
                return (V)object;
                finally {
                    this.att1Key = null;
                    this.att1 = null;
                }
            }
            if (key != this.att2Key) break block18;
            Object object = this.att2;
            return (V)object;
            finally {
                this.att2Key = null;
                this.att2 = null;
            }
        }
        if (key == this.att3Key) {
            Object object = this.att3;
            return (V)object;
            finally {
                this.att3Key = null;
                this.att3 = null;
            }
        }
        V v = null;
        return v;
        finally {
            lock.unlock();
        }
    }

    LoggerNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggable(ExtLogRecord record) {
        Object lock;
        if (!this.useParentFilter) {
            Filter filter = this.filter;
            return filter == null || filter.isLoggable(record);
        }
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            return LoggerNode.isLoggable(this, record);
        }
    }

    private static boolean isLoggable(LoggerNode loggerNode, ExtLogRecord record) {
        if (loggerNode == null) {
            return true;
        }
        Filter filter = loggerNode.filter;
        return !(filter != null && !filter.isLoggable(record) || loggerNode.useParentFilter && !LoggerNode.isLoggable(loggerNode.getParent(), record));
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String getFullName() {
        return this.fullName;
    }
}

