/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.channel.epoll.Epoll;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.logging.Log;

final class EPollAvailable {
    private static final Log log = (Log)LogFactory.getLog(EPollAvailable.class, Log.class);
    private static final String USE_EPOLL_PROPERTY = "infinispan.server.channel.epoll";
    private static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
    private static final boolean EPOLL_DISABLED = System.getProperty("infinispan.server.channel.epoll", "true").equalsIgnoreCase("false");
    static final boolean USE_NATIVE_EPOLL = EPollAvailable.useNativeEpoll();

    EPollAvailable() {
    }

    private static boolean useNativeEpoll() {
        if (Epoll.isAvailable()) {
            return !EPOLL_DISABLED && IS_LINUX;
        }
        if (IS_LINUX) {
            log.epollNotAvailable(Epoll.unavailabilityCause().toString());
        }
        return false;
    }
}

