/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration;

import io.agroal.api.security.AgroalSecurityProvider;
import java.security.Principal;
import java.util.Collection;
import java.util.Properties;

public interface AgroalConnectionFactoryConfiguration {
    public boolean autoCommit();

    public boolean trackJdbcResources();

    public String jdbcUrl();

    public String initialSql();

    public Class<?> connectionProviderClass();

    public IsolationLevel jdbcTransactionIsolation();

    public Collection<AgroalSecurityProvider> securityProviders();

    public Principal principal();

    public Collection<Object> credentials();

    public Principal recoveryPrincipal();

    public Collection<Object> recoveryCredentials();

    public Properties jdbcProperties();

    public static interface IsolationLevel {
        public boolean isDefined();

        public int level();
    }

    public static enum TransactionIsolation implements IsolationLevel
    {
        UNDEFINED,
        NONE,
        READ_UNCOMMITTED,
        READ_COMMITTED,
        REPEATABLE_READ,
        SERIALIZABLE;


        public static TransactionIsolation fromLevel(int level) {
            switch (level) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return READ_UNCOMMITTED;
                }
                case 2: {
                    return READ_COMMITTED;
                }
                case 4: {
                    return REPEATABLE_READ;
                }
                case 8: {
                    return SERIALIZABLE;
                }
            }
            return UNDEFINED;
        }

        @Override
        public int level() {
            switch (this) {
                case READ_UNCOMMITTED: {
                    return 1;
                }
                case READ_COMMITTED: {
                    return 2;
                }
                case REPEATABLE_READ: {
                    return 4;
                }
                case SERIALIZABLE: {
                    return 8;
                }
                case NONE: {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public boolean isDefined() {
            return this != UNDEFINED;
        }
    }
}

