/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.configuration.global.PrincipalRoleMapperConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.audit.NullAuditLogger;
import org.infinispan.security.impl.CacheRoleImpl;

public class GlobalAuthorizationConfiguration {
    private static final Map<String, Role> DEFAULT_ROLES;
    public static final AttributeDefinition<Boolean> ENABLED;
    public static final AttributeDefinition<AuditLogger> AUDIT_LOGGER;
    public static final AttributeDefinition<Map<String, Role>> ROLES;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final org.infinispan.commons.configuration.attributes.Attribute<AuditLogger> auditLogger;
    private final org.infinispan.commons.configuration.attributes.Attribute<Map<String, Role>> roles;
    private final PrincipalRoleMapperConfiguration roleMapperConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalAuthorizationConfiguration.class, new AttributeDefinition[]{ENABLED, AUDIT_LOGGER, ROLES});
    }

    public GlobalAuthorizationConfiguration(AttributeSet attributes, PrincipalRoleMapperConfiguration roleMapperConfiguration) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.auditLogger = attributes.attribute(AUDIT_LOGGER);
        this.roles = attributes.attribute(ROLES);
        this.roleMapperConfiguration = roleMapperConfiguration;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public AuditLogger auditLogger() {
        return (AuditLogger)this.auditLogger.get();
    }

    public PrincipalRoleMapper principalRoleMapper() {
        return this.roleMapperConfiguration.roleMapper();
    }

    public PrincipalRoleMapperConfiguration roleMapperConfiguration() {
        return this.roleMapperConfiguration;
    }

    public Map<String, Role> roles() {
        return (Map)this.roles.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalAuthorizationConfiguration{roleMapperConfiguration=" + this.roleMapperConfiguration + ", attributes=" + this.attributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalAuthorizationConfiguration that = (GlobalAuthorizationConfiguration)o;
        if (this.roleMapperConfiguration != null ? !this.roleMapperConfiguration.equals(that.roleMapperConfiguration) : that.roleMapperConfiguration != null) {
            return false;
        }
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        int result = this.roleMapperConfiguration != null ? this.roleMapperConfiguration.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    static {
        ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false).immutable().build();
        AUDIT_LOGGER = AttributeDefinition.builder((Enum)Attribute.AUDIT_LOGGER, (Object)new NullAuditLogger()).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
        ROLES = AttributeDefinition.builder((Enum)Attribute.ROLES, new HashMap()).initializer((AttributeInitializer)new AttributeInitializer<Map<String, Role>>(){

            public Map<String, Role> initialize() {
                return DEFAULT_ROLES;
            }
        }).build();
        HashMap<String, CacheRoleImpl> roles = new HashMap<String, CacheRoleImpl>();
        roles.put("admin", new CacheRoleImpl("admin", true, AuthorizationPermission.ALL));
        roles.put("application", new CacheRoleImpl("application", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.MONITOR));
        roles.put("deployer", new CacheRoleImpl("deployer", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.CREATE, AuthorizationPermission.MONITOR));
        roles.put("observer", new CacheRoleImpl("observer", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.MONITOR));
        roles.put("monitor", new CacheRoleImpl("monitor", true, AuthorizationPermission.MONITOR));
        roles.put("___schema_manager", new CacheRoleImpl("___schema_manager", false, AuthorizationPermission.CREATE));
        roles.put("___script_manager", new CacheRoleImpl("___script_manager", false, AuthorizationPermission.CREATE));
        DEFAULT_ROLES = Collections.unmodifiableMap(roles);
    }
}

