/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.irac.IracCleanupKeyCommand;
import org.infinispan.commands.irac.IracRequestStateCommand;
import org.infinispan.commands.irac.IracStateResponseCommand;
import org.infinispan.commands.irac.IracTouchKeyCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.ExponentialBackOff;
import org.infinispan.util.ExponentialBackOffImpl;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.irac.IracExecutor;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracResponseCollector;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;

@MBean(objectName="AsyncXSiteStatistics", description="Statistics for Asynchronous cross-site replication")
@Scope(value=Scopes.NAMED_CACHE)
public class DefaultIracManager
implements IracManager,
JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(DefaultIracManager.class);
    private static final String STATE_TRANSFER_OWNER = "state-transfer";
    @Inject
    RpcManager rpcManager;
    @Inject
    TakeOfflineManager takeOfflineManager;
    @Inject
    ClusteringDependentLogic clusteringDependentLogic;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    IracVersionGenerator iracVersionGenerator;
    private final Map<Object, State> updatedKeys;
    private final Collection<XSiteBackup> asyncBackups;
    private final IracExecutor iracExecutor;
    private volatile boolean hasClear;
    private boolean statisticsEnabled = false;
    private final LongAdder discardCounts = new LongAdder();
    private final LongAdder conflictLocalWinsCount = new LongAdder();
    private final LongAdder conflictRemoteWinsCount = new LongAdder();
    private final LongAdder conflictMergedCount = new LongAdder();

    public DefaultIracManager(Configuration config) {
        this.updatedKeys = new ConcurrentHashMap<Object, State>();
        this.iracExecutor = new IracExecutor(this::run);
        this.asyncBackups = DefaultIracManager.asyncBackups(config);
        this.setStatisticsEnabled(config.statistics().enabled());
    }

    private static Collection<XSiteBackup> asyncBackups(Configuration config) {
        return config.sites().asyncBackupsStream().map(bc -> new XSiteBackup(bc.site(), true, bc.replicationTimeout())).collect(Collectors.toList());
    }

    private static IntSet newIntSet(Address ignored) {
        return IntSets.mutableEmptySet();
    }

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService executorService, @ComponentName(value="org.infinispan.executors.blocking") Executor blockingExecutor) {
        this.iracExecutor.setBackOff(new ExponentialBackOffImpl(executorService));
        this.iracExecutor.setExecutor(blockingExecutor);
    }

    @Start
    public void start() {
        Transport transport = this.rpcManager.getTransport();
        transport.checkCrossSiteAvailable();
        String localSiteName = transport.localSiteName();
        this.asyncBackups.removeIf(xSiteBackup -> localSiteName.equals(xSiteBackup.getSiteName()));
        if (log.isTraceEnabled()) {
            String b = this.asyncBackups.stream().map(XSiteBackup::getSiteName).collect(Collectors.joining(", "));
            log.tracef("Async remote sites found: %s", b);
        }
        this.hasClear = false;
    }

    @Override
    public void trackUpdatedKey(int segment, Object key, Object lockOwner) {
        State old;
        if (log.isTraceEnabled()) {
            log.tracef("Tracking key for %s: %s", lockOwner, key);
        }
        if ((old = this.updatedKeys.put(key, new State(segment, key, lockOwner))) != null) {
            old.discard();
        }
        this.iracExecutor.run();
    }

    @Override
    public void trackExpiredKey(int segment, Object key, Object lockOwner) {
        State old;
        if (log.isTraceEnabled()) {
            log.tracef("Tracking expired key for %s: %s", lockOwner, key);
        }
        if ((old = this.updatedKeys.put(key, new ExpirationState(segment, key, lockOwner))) != null) {
            old.discard();
        }
        this.iracExecutor.run();
    }

    @Override
    public CompletionStage<Void> trackForStateTransfer(Collection<XSiteState> stateList) {
        AggregateCompletionStage<Void> cf = CompletionStages.aggregateCompletionStage();
        LocalizedCacheTopology topology = this.clusteringDependentLogic.getCacheTopology();
        for (XSiteState state : stateList) {
            int segment = topology.getSegment(state.key());
            CompletableState completableState = new CompletableState(segment, state.key());
            if (this.updatedKeys.putIfAbsent(state.key(), completableState) != null) continue;
            cf.dependsOn(completableState.completableFuture);
        }
        this.iracExecutor.run();
        return cf.freeze();
    }

    @Override
    public void trackClear() {
        if (log.isTraceEnabled()) {
            log.trace("Tracking clear request");
        }
        this.hasClear = true;
        this.updatedKeys.values().forEach(State::discard);
        this.iracExecutor.run();
    }

    @Override
    public void cleanupKey(int segment, Object key, Object lockOwner, IracMetadata tombstone) {
        State state = new State(segment, key, lockOwner);
        state.tombstone = tombstone;
        this.removeStateFromLocal(state);
    }

    @Override
    public void onTopologyUpdate(CacheTopology oldCacheTopology, CacheTopology newCacheTopology) {
        if (log.isTraceEnabled()) {
            log.trace("[IRAC] Topology Updated. Checking pending keys.");
        }
        Address local = this.rpcManager.getAddress();
        if (!newCacheTopology.getMembers().contains(local)) {
            return;
        }
        IntSet addedSegments = IntSets.mutableCopyFrom(newCacheTopology.getWriteConsistentHash().getSegmentsForOwner(local));
        if (oldCacheTopology.getMembers().contains(local)) {
            addedSegments.removeAll(oldCacheTopology.getWriteConsistentHash().getSegmentsForOwner(local));
        }
        if (addedSegments.isEmpty()) {
            this.iracExecutor.run();
            return;
        }
        HashMap<Address, IntSet> primarySegments = new HashMap<Address, IntSet>();
        PrimitiveIterator.OfInt ofInt = addedSegments.iterator();
        while (ofInt.hasNext()) {
            int segment = (Integer)ofInt.next();
            Address primary = newCacheTopology.getWriteConsistentHash().locatePrimaryOwnerForSegment(segment);
            primarySegments.computeIfAbsent(primary, DefaultIracManager::newIntSet).add(segment);
        }
        primarySegments.forEach(this::sendStateRequest);
        this.iracExecutor.run();
    }

    @Override
    public void requestState(Address origin, IntSet segments) {
        this.updatedKeys.values().forEach(state -> this.sendStateIfNeeded(origin, segments, ((State)state).segment, ((State)state).key, ((State)state).owner));
    }

    @Override
    public void receiveState(int segment, Object key, Object lockOwner, IracMetadata tombstone) {
        this.iracVersionGenerator.storeTombstoneIfAbsent(key, tombstone);
        this.updatedKeys.putIfAbsent(key, new State(segment, key, lockOwner));
        this.iracExecutor.run();
    }

    @Override
    public CompletionStage<Boolean> checkAndTrackExpiration(Object key) {
        if (log.isTraceEnabled()) {
            log.tracef("Checking remote backup sites to see if key %s has been touched recently", key);
        }
        IracTouchKeyCommand command = this.commandsFactory.buildIracTouchCommand(key);
        AtomicBoolean expired = new AtomicBoolean(true);
        AggregateCompletionStage<AtomicBoolean> collector = CompletionStages.aggregateCompletionStage(expired);
        for (XSiteBackup backup : this.asyncBackups) {
            if (this.takeOfflineManager.getSiteState(backup.getSiteName()) == SiteState.OFFLINE) {
                if (!log.isTraceEnabled()) continue;
                log.tracef("Skipping %s as it is offline", backup.getSiteName());
                continue;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Sending irac touch key command to %s", backup);
            }
            XSiteResponse<Boolean> response = this.sendToRemoteSite(backup, command);
            collector.dependsOn(response.thenAccept(touched -> {
                if (touched.booleanValue()) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Key %s was recently touched on a remote site %s", key, backup);
                    }
                    expired.set(false);
                } else if (log.isTraceEnabled()) {
                    log.tracef("Entry %s was expired on remote site %s", key, backup);
                }
            }));
        }
        return collector.freeze().thenApply(AtomicBoolean::get);
    }

    public void sendStateIfNeeded(Address origin, IntSet segments, int segment, Object key, Object lockOwner) {
        if (!segments.contains(segment)) {
            return;
        }
        IracMetadata tombstone = this.iracVersionGenerator.getTombstone(key);
        IracStateResponseCommand cmd = this.commandsFactory.buildIracStateResponseCommand(segment, key, lockOwner, tombstone);
        this.rpcManager.sendTo(origin, cmd, DeliverOrder.NONE);
    }

    private CompletionStage<Void> run() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Sending keys to remote site(s). Has clear? %s, keys: %s", this.hasClear, this.updatedKeys.keySet());
        }
        if (this.hasClear) {
            return this.sendClearUpdate();
        }
        for (State state : this.updatedKeys.values()) {
            if (!state.canSend()) continue;
            DistributionInfo dInfo = this.getDistributionInfo(state.segment);
            if (!dInfo.isPrimary()) {
                state.sendFail();
                continue;
            }
            if (!dInfo.isWriteOwner()) {
                state.discard();
                continue;
            }
            if (!dInfo.isReadOwner()) {
                state.sendFail();
                continue;
            }
            this.fetchEntry(state.key, dInfo.segmentId()).thenApply(lEntry -> lEntry == null ? this.buildRemoveCommand(state) : this.commandsFactory.buildIracPutKeyCommand(lEntry)).thenAccept(cmd -> {
                if (cmd == null) {
                    log.sendFailMissingTombstone(Util.toStr((Object)state.key));
                    state.accept(IracResponseCollector.Result.OK, null);
                    this.onSendingCompleted(IracResponseCollector.Result.OK, null);
                    return;
                }
                IracResponseCollector rsp = this.sendCommandToAllBackups((XSiteReplicateCommand<Void>)cmd);
                rsp.whenComplete((BiConsumer)state);
                rsp.whenComplete(this::onSendingCompleted);
            }).exceptionally(throwable -> {
                state.sendFail();
                this.onSendingCompleted(null, CompletableFutures.extractException(throwable));
                return null;
            });
        }
        return CompletableFutures.completedNull();
    }

    public void setBackOff(ExponentialBackOff backOff) {
        this.iracExecutor.setBackOff(backOff);
    }

    public boolean isEmpty() {
        return this.updatedKeys.isEmpty();
    }

    private CompletionStage<Void> sendClearUpdate() {
        return ((CompletableFuture)((CompletableFuture)this.sendCommandToAllBackups(this.commandsFactory.buildIracClearKeysCommand()).whenComplete(this::onClearCompleted)).exceptionally(CompletableFutures.toNullFunction())).thenRun(() -> {});
    }

    private void onClearCompleted(IracResponseCollector.Result result, Throwable throwable) {
        this.onRoundCompleted(result, throwable, true);
    }

    private void onSendingCompleted(IracResponseCollector.Result result, Throwable throwable) {
        this.onRoundCompleted(result, throwable, false);
    }

    private void onRoundCompleted(IracResponseCollector.Result result, Throwable throwable, boolean isClear) {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] Round completed (is clear? %s). Result: %s (throwable=%s)", isClear, (Object)result, throwable);
        }
        if (throwable != null) {
            log.unexpectedErrorFromIrac(throwable);
            this.iracExecutor.run();
            return;
        }
        switch (result) {
            case OK: {
                this.iracExecutor.disableBackOff();
                if (isClear) {
                    this.hasClear = false;
                    this.iracExecutor.run();
                }
                return;
            }
            case NETWORK_EXCEPTION: {
                this.iracExecutor.enableBackOff();
                this.iracExecutor.run();
                return;
            }
            case REMOTE_EXCEPTION: {
                this.iracExecutor.disableBackOff();
                this.iracExecutor.run();
                return;
            }
        }
        log.unexpectedErrorFromIrac(new IllegalStateException("Unknown result: " + (Object)((Object)result)));
        this.iracExecutor.run();
    }

    private void sendStateRequest(Address primary, IntSet segments) {
        IracRequestStateCommand cmd = this.commandsFactory.buildIracRequestStateCommand(segments);
        this.rpcManager.sendTo(primary, cmd, DeliverOrder.NONE);
    }

    private <O> XSiteResponse<O> sendToRemoteSite(XSiteBackup backup, XSiteReplicateCommand<O> cmd) {
        XSiteResponse<O> rsp = this.rpcManager.invokeXSite(backup, cmd);
        this.takeOfflineManager.registerRequest(rsp);
        return rsp;
    }

    private void removeStateFromCluster(State state) {
        if (log.isTraceEnabled()) {
            log.tracef("Replication completed for key '%s'. Lock Owner='%s'", state.key, state.owner);
        }
        DistributionInfo dInfo = this.getDistributionInfo(state.segment);
        IracCleanupKeyCommand cmd = this.commandsFactory.buildIracCleanupKeyCommand(state.segment, state.key, state.owner, state.tombstone);
        this.rpcManager.sendToMany(dInfo.writeOwners(), cmd, DeliverOrder.NONE);
        this.removeStateFromLocal(state);
    }

    private void removeStateFromLocal(State state) {
        boolean removed = this.updatedKeys.remove(state.key, state);
        this.iracVersionGenerator.removeTombstone(state.key, state.tombstone);
        if (log.isTraceEnabled()) {
            log.tracef("Removing key '%s'. LockOwner='%s', removed=%s", state.key, state.owner, removed);
        }
    }

    private DistributionInfo getDistributionInfo(int segmentId) {
        return this.clusteringDependentLogic.getCacheTopology().getSegmentDistribution(segmentId);
    }

    private IracResponseCollector sendCommandToAllBackups(XSiteReplicateCommand<Void> command) {
        assert (Objects.nonNull(command));
        IracResponseCollector collector = new IracResponseCollector();
        for (XSiteBackup backup : this.asyncBackups) {
            if (this.takeOfflineManager.getSiteState(backup.getSiteName()) == SiteState.OFFLINE) continue;
            collector.dependsOn(this.sendToRemoteSite(backup, command));
        }
        return collector.freeze();
    }

    private XSiteReplicateCommand<Void> buildRemoveCommand(State state) {
        Object key = state.key;
        IracMetadata metadata = this.iracVersionGenerator.getTombstone(key);
        if (metadata == null) {
            return null;
        }
        state.tombstone = metadata;
        return this.commandsFactory.buildIracRemoveKeyCommand(key, metadata, state.isExpiration());
    }

    private CompletionStage<InternalCacheEntry<Object, Object>> fetchEntry(Object key, int segmentId) {
        return this.clusteringDependentLogic.getEntryLoader().loadAndStoreInDataContainer(key, segmentId);
    }

    @ManagedAttribute(description="Number of keys that need to be sent to remote site(s)", displayName="Queue size", measurementType=MeasurementType.DYNAMIC)
    public int getQueueSize() {
        return this.getStatisticsEnabled() ? this.updatedKeys.size() : -1;
    }

    @ManagedAttribute(description="The total number of conflicts between local and remote sites.", displayName="Number of conflicts", measurementType=MeasurementType.TRENDSUP)
    public long getNumberOfConflicts() {
        return this.getStatisticsEnabled() ? this.sumConflicts() : -1L;
    }

    @ManagedAttribute(description="The number of updates from remote sites discarded (duplicate or old update).", displayName="Number of discards", measurementType=MeasurementType.TRENDSUP)
    public long getNumberOfDiscards() {
        return this.getStatisticsEnabled() ? this.discardCounts.longValue() : -1L;
    }

    @ManagedAttribute(description="The number of conflicts where the merge policy discards the remote update.", displayName="Number of conflicts where local value is used", measurementType=MeasurementType.TRENDSUP)
    public long getNumberOfConflictsLocalWins() {
        return this.getStatisticsEnabled() ? this.conflictLocalWinsCount.longValue() : -1L;
    }

    @ManagedAttribute(description="The number of conflicts where the merge policy applies the remote update.", displayName="Number of conflicts where remote value is used", measurementType=MeasurementType.TRENDSUP)
    public long getNumberOfConflictsRemoteWins() {
        return this.getStatisticsEnabled() ? this.conflictRemoteWinsCount.longValue() : -1L;
    }

    @ManagedAttribute(description="Number of conflicts where the merge policy created a new entry.", displayName="Number of conflicts merged", measurementType=MeasurementType.TRENDSUP)
    public long getNumberOfConflictsMerged() {
        return this.getStatisticsEnabled() ? this.conflictMergedCount.longValue() : -1L;
    }

    @Override
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Override
    @ManagedOperation(displayName="Reset Statistics", description="Resets statistics gathered by this component")
    public void resetStatistics() {
        this.discardCounts.reset();
        this.conflictLocalWinsCount.reset();
        this.conflictRemoteWinsCount.reset();
        this.conflictMergedCount.reset();
    }

    private long sumConflicts() {
        return this.conflictLocalWinsCount.longValue() + this.conflictRemoteWinsCount.longValue() + this.conflictMergedCount.longValue();
    }

    @Override
    public void incrementNumberOfDiscards() {
        this.discardCounts.increment();
    }

    @Override
    public void incrementNumberOfConflictLocalWins() {
        this.conflictLocalWinsCount.increment();
    }

    @Override
    public void incrementNumberOfConflictRemoteWins() {
        this.conflictRemoteWinsCount.increment();
    }

    @Override
    public void incrementNumberOfConflictMerged() {
        this.conflictMergedCount.increment();
    }

    private class ExpirationState
    extends State {
        private ExpirationState(int segment, Object key, Object owner) {
            super(segment, key, owner);
        }

        @Override
        boolean isExpiration() {
            return true;
        }
    }

    private class CompletableState
    extends State {
        private final CompletableFuture<Void> completableFuture;

        private CompletableState(int segment, Object key) {
            super(segment, key, DefaultIracManager.STATE_TRANSFER_OWNER);
            this.completableFuture = new CompletableFuture();
        }

        @Override
        synchronized void discard() {
            super.discard();
            this.completableFuture.complete(null);
        }

        @Override
        public void accept(IracResponseCollector.Result result, Throwable throwable) {
            super.accept(result, throwable);
            if (this.isCompleted()) {
                this.completableFuture.complete(null);
            }
        }

        synchronized boolean isCompleted() {
            return this.stateStatus == StateStatus.COMPLETED;
        }
    }

    private class State
    implements BiConsumer<IracResponseCollector.Result, Throwable> {
        private final Object key;
        private final Object owner;
        private final int segment;
        @GuardedBy(value="this")
        StateStatus stateStatus;
        private volatile IracMetadata tombstone;

        private State(int segment, Object key, Object owner) {
            this.segment = segment;
            this.key = key;
            this.owner = owner;
            this.stateStatus = StateStatus.NEW;
        }

        synchronized boolean canSend() {
            if (log.isTraceEnabled()) {
                log.tracef("[IRAC] State.canSend for key %s (status=%s)", this.key, (Object)this.stateStatus);
            }
            if (this.stateStatus == StateStatus.NEW) {
                this.stateStatus = StateStatus.SENDING;
                return true;
            }
            return false;
        }

        synchronized void discard() {
            if (log.isTraceEnabled()) {
                log.tracef("[IRAC] State.onDiscard for key %s (status=%s)", this.key, (Object)this.stateStatus);
            }
            this.stateStatus = StateStatus.COMPLETED;
            DefaultIracManager.this.removeStateFromLocal(this);
        }

        synchronized void sendFail() {
            if (log.isTraceEnabled()) {
                log.tracef("[IRAC] State.sendFail for key %s (status=%s)", this.key, (Object)this.stateStatus);
            }
            if (this.stateStatus == StateStatus.SENDING) {
                this.stateStatus = StateStatus.NEW;
            }
        }

        boolean isExpiration() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.key.equals(state.key) && this.owner.equals(state.owner);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(IracResponseCollector.Result result, Throwable throwable) {
            if (throwable != null || result != IracResponseCollector.Result.OK) {
                this.sendFail();
            } else {
                State state = this;
                synchronized (state) {
                    if (log.isTraceEnabled()) {
                        log.tracef("[IRAC] State.onSuccess for key %s (status=%s)", this.key, (Object)this.stateStatus);
                    }
                    if (this.stateStatus != StateStatus.SENDING) {
                        return;
                    }
                    this.stateStatus = StateStatus.COMPLETED;
                }
                DefaultIracManager.this.removeStateFromCluster(this);
            }
        }
    }

    private static enum StateStatus {
        NEW,
        SENDING,
        COMPLETED;

    }
}

