/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.util.internal.CollectionUtils;

public class DefaultClassPath
implements ClassPath,
Serializable {
    private final ImmutableUniqueList<File> files;

    public static ClassPath of(Iterable<File> files) {
        if (files == null) {
            return EMPTY;
        }
        if (files instanceof Collection) {
            return DefaultClassPath.of((Collection)files);
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files) {
            list.add(file);
        }
        return DefaultClassPath.of(list);
    }

    public static ClassPath of(File ... files) {
        if (files == null || files.length == 0) {
            return EMPTY;
        }
        return DefaultClassPath.of(Arrays.asList(files));
    }

    public static ClassPath of(Collection<File> files) {
        if (files == null || files.isEmpty()) {
            return EMPTY;
        }
        return new DefaultClassPath(new ImmutableUniqueList<File>(files));
    }

    DefaultClassPath() {
        this(ImmutableUniqueList.empty());
    }

    protected DefaultClassPath(ImmutableUniqueList<File> files) {
        this.files = files;
    }

    public String toString() {
        return this.files.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    @Override
    public List<URI> getAsURIs() {
        ArrayList<URI> urls = new ArrayList<URI>();
        for (File file : this.files) {
            urls.add(file.toURI());
        }
        return urls;
    }

    @Override
    public List<File> getAsFiles() {
        return this.files;
    }

    @Override
    public URL[] getAsURLArray() {
        List<URL> result = this.getAsURLs();
        return result.toArray(new URL[0]);
    }

    @Override
    public List<URL> getAsURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : this.files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        return urls;
    }

    @Override
    public ClassPath plus(ClassPath other) {
        if (this.files.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, other.getAsFiles()));
    }

    @Override
    public ClassPath plus(Collection<File> other) {
        if (other.isEmpty()) {
            return this;
        }
        return new DefaultClassPath(this.concat(this.files, other));
    }

    @Override
    public ClassPath removeIf(Spec<? super File> filter) {
        List<File> remainingFiles = CollectionUtils.filter(this.files, new NotSpec<File>(filter));
        if (remainingFiles.size() == this.files.size()) {
            return this;
        }
        return DefaultClassPath.of(remainingFiles);
    }

    private ImmutableUniqueList<File> concat(Collection<File> files1, Collection<File> files2) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        result.addAll(files1);
        result.addAll(files2);
        return new ImmutableUniqueList<File>((Set<File>)result);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultClassPath other = (DefaultClassPath)obj;
        return this.files.equals(other.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    protected static final class ImmutableUniqueList<T>
    extends AbstractList<T>
    implements Serializable {
        private static final ImmutableUniqueList<Object> EMPTY = new ImmutableUniqueList(Collections.emptySet());
        private final Object[] asArray;
        private final Set<T> asSet;
        private final int size;

        public static <T> ImmutableUniqueList<T> empty() {
            return EMPTY;
        }

        public ImmutableUniqueList(Collection<T> from) {
            this.asSet = new HashSet<T>(from.size());
            Object[] elements = new Object[from.size()];
            int i = 0;
            for (T t : from) {
                if (!this.asSet.add(t)) continue;
                elements[i] = t;
                ++i;
            }
            this.asArray = new Object[i];
            System.arraycopy(elements, 0, this.asArray, 0, i);
            this.size = i;
        }

        ImmutableUniqueList(Set<T> from) {
            this.asSet = from;
            this.size = from.size();
            this.asArray = new Object[this.size];
            int i = 0;
            for (T t : from) {
                this.asArray[i] = t;
                ++i;
            }
        }

        @Override
        public T get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
            return Cast.uncheckedNonnullCast(this.asArray[index]);
        }

        @Override
        public boolean contains(Object o) {
            return this.asSet.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.asSet.containsAll(c);
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

