/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.LogRequest;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.LogFactory;

public class LogAppender
implements Consumer<WriteOperation> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final NonBlockingManager nonBlockingManager;
    private final Index index;
    private final TemporaryTable temporaryTable;
    private final Compactor compactor;
    private final FileProvider fileProvider;
    private final boolean syncWrites;
    private final int maxFileSize;
    private final AtomicInteger submittedCount = new AtomicInteger();
    private final List<LogRequest> toSyncLogRequests;
    private final java.nio.ByteBuffer REUSED_BUFFER = java.nio.ByteBuffer.allocate(27);
    private int currentOffset = 0;
    private long seqId = 0L;
    private int receivedCount = 0;
    private List<LogRequest> delayedLogRequests;
    private FileProvider.Log logFile;
    private long nextExpirationTime = -1L;
    private volatile FlowableProcessor<LogRequest> requestProcessor;
    private FlowableProcessor<WriteOperation> writeProcessor;

    public LogAppender(NonBlockingManager nonBlockingManager, Index index, TemporaryTable temporaryTable, Compactor compactor, FileProvider fileProvider, boolean syncWrites, int maxFileSize) {
        this.nonBlockingManager = nonBlockingManager;
        this.index = index;
        this.temporaryTable = temporaryTable;
        this.compactor = compactor;
        this.fileProvider = fileProvider;
        this.syncWrites = syncWrites;
        this.maxFileSize = maxFileSize;
        this.toSyncLogRequests = syncWrites ? new ArrayList() : null;
    }

    public synchronized void start(Executor executor) {
        assert (this.requestProcessor == null);
        this.writeProcessor = UnicastProcessor.create();
        this.writeProcessor.observeOn(Schedulers.from((Executor)executor)).subscribe((Consumer)this, e -> log.warn("Exception encountered while performing write log request ", (Throwable)e));
        this.requestProcessor = UnicastProcessor.create().toSerialized();
        this.requestProcessor.subscribe(this::callerAccept, e -> log.warn("Exception encountered while handling log request for log appender", (Throwable)e), () -> {
            this.writeProcessor.onComplete();
            this.writeProcessor = null;
        });
    }

    public synchronized void stop() {
        assert (this.requestProcessor != null);
        this.requestProcessor.onComplete();
        this.requestProcessor = null;
    }

    public CompletionStage<Void> clearAndPause() {
        LogRequest clearRequest = LogRequest.clearRequest();
        this.requestProcessor.onNext((Object)clearRequest);
        return clearRequest;
    }

    public CompletionStage<Void> pause() {
        LogRequest pauseRequest = LogRequest.pauseRequest();
        this.requestProcessor.onNext((Object)pauseRequest);
        return pauseRequest;
    }

    public CompletionStage<Void> resume() {
        LogRequest resumeRequest = LogRequest.resumeRequest();
        this.requestProcessor.onNext((Object)resumeRequest);
        return resumeRequest;
    }

    public <K, V> CompletionStage<Void> storeRequest(int segment, MarshallableEntry<K, V> entry) {
        LogRequest storeRequest = LogRequest.storeRequest(segment, entry);
        this.requestProcessor.onNext((Object)storeRequest);
        return storeRequest.thenRun(() -> this.handleRequestCompletion(storeRequest));
    }

    private void handleRequestCompletion(LogRequest request) {
        int offset = request.getSerializedValue() == null ? ~request.getFileOffset() : request.getFileOffset();
        this.temporaryTable.set(request.getSement(), request.getKey(), request.getFile(), offset);
        IndexRequest indexRequest = IndexRequest.update(request.getSement(), request.getKey(), this.raw(request.getSerializedKey()), request.getFile(), offset, request.length());
        request.setIndexRequest(indexRequest);
        this.index.handleRequest(indexRequest);
    }

    public CompletionStage<Boolean> deleteRequest(int segment, Object key, ByteBuffer serializedKey) {
        LogRequest deleteRequest = LogRequest.deleteRequest(segment, key, serializedKey);
        this.requestProcessor.onNext((Object)deleteRequest);
        return deleteRequest.thenCompose(v -> {
            this.handleRequestCompletion(deleteRequest);
            return LogAppender.cast(deleteRequest.getIndexRequest());
        });
    }

    private static <I> CompletionStage<I> cast(CompletionStage stage) {
        return stage;
    }

    private void callerAccept(LogRequest request) {
        if (request.isPause()) {
            this.delayedLogRequests = new ArrayList<LogRequest>();
            request.complete(null);
            return;
        }
        if (request.isResume()) {
            this.delayedLogRequests.forEach(this::sendToWriteProcessor);
            this.delayedLogRequests = null;
            request.complete(null);
            return;
        }
        if (request.isClear()) {
            assert (this.delayedLogRequests == null);
            this.delayedLogRequests = new ArrayList<LogRequest>();
        } else if (this.delayedLogRequests != null) {
            this.delayedLogRequests.add(request);
            return;
        }
        this.sendToWriteProcessor(request);
    }

    private void sendToWriteProcessor(LogRequest request) {
        if (this.syncWrites && request.getKey() != null) {
            this.submittedCount.incrementAndGet();
        }
        this.writeProcessor.onNext((Object)WriteOperation.fromLogRequest(request));
    }

    public void accept(WriteOperation writeOperation) {
        LogRequest actualRequest = writeOperation.logRequest;
        try {
            if (this.logFile == null) {
                this.logFile = this.fileProvider.getFileForLog();
                log.tracef("Appending records to %s", this.logFile.fileId);
            }
            if (actualRequest.isClear()) {
                this.logFile.close();
                this.completePendingLogRequests();
                this.nextExpirationTime = -1L;
                this.currentOffset = 0;
                this.logFile = null;
                this.completeRequest(actualRequest);
                return;
            }
            int actualLength = actualRequest.length();
            if (this.currentOffset != 0 && this.currentOffset + actualLength > this.maxFileSize) {
                this.logFile.close();
                this.compactor.completeFile(this.logFile.fileId, this.currentOffset, this.nextExpirationTime);
                this.completePendingLogRequests();
                this.logFile = this.fileProvider.getFileForLog();
                this.nextExpirationTime = -1L;
                this.currentOffset = 0;
                log.tracef("Appending records to %s", this.logFile.fileId);
            }
            long seqId = this.nextSeqId();
            log.tracef("Appending record to %s:%s", this.logFile.fileId, this.currentOffset);
            this.nextExpirationTime = ExpiryHelper.mostRecentExpirationTime(this.nextExpirationTime, actualRequest.getExpiration());
            EntryRecord.writeEntry(this.logFile.fileChannel, this.REUSED_BUFFER, writeOperation.serializedKey, writeOperation.serializedMetadata, writeOperation.serializedInternalMetadata, writeOperation.serializedValue, seqId, actualRequest.getExpiration(), actualRequest.getCreated(), actualRequest.getLastUsed());
            actualRequest.setFile(this.logFile.fileId);
            actualRequest.setFileOffset(this.currentOffset);
            if (!this.syncWrites) {
                this.completeRequest(actualRequest);
            } else {
                this.toSyncLogRequests.add(actualRequest);
                if (this.submittedCount.get() == ++this.receivedCount || this.toSyncLogRequests.size() == 1000) {
                    this.logFile.fileChannel.force(false);
                    this.completePendingLogRequests();
                }
            }
            this.currentOffset += actualLength;
        }
        catch (Exception e) {
            log.debugf("Exception encountered while processing log request %s", actualRequest);
            actualRequest.completeExceptionally(e);
        }
    }

    private void completePendingLogRequests() {
        if (this.toSyncLogRequests != null) {
            Iterator<LogRequest> iter = this.toSyncLogRequests.iterator();
            while (iter.hasNext()) {
                LogRequest logRequest = iter.next();
                iter.remove();
                this.completeRequest(logRequest);
            }
        }
    }

    private byte[] raw(ByteBuffer buffer) {
        if (buffer.getBuf().length == buffer.getLength()) {
            return buffer.getBuf();
        }
        byte[] bytes = new byte[buffer.getLength()];
        System.arraycopy(buffer.getBuf(), buffer.getOffset(), bytes, 0, buffer.getLength());
        return bytes;
    }

    public void setSeqId(long seqId) {
        this.seqId = seqId;
    }

    private long nextSeqId() {
        return this.seqId++;
    }

    private void completeRequest(CompletableFuture<Void> future) {
        this.nonBlockingManager.complete(future, null);
    }

    static class WriteOperation {
        private final LogRequest logRequest;
        private final java.nio.ByteBuffer serializedKey;
        private final java.nio.ByteBuffer serializedMetadata;
        private final java.nio.ByteBuffer serializedValue;
        private final java.nio.ByteBuffer serializedInternalMetadata;

        private WriteOperation(LogRequest logRequest, java.nio.ByteBuffer serializedKey, java.nio.ByteBuffer serializedMetadata, java.nio.ByteBuffer serializedValue, java.nio.ByteBuffer serializedInternalMetadata) {
            this.logRequest = logRequest;
            this.serializedKey = serializedKey;
            this.serializedMetadata = serializedMetadata;
            this.serializedValue = serializedValue;
            this.serializedInternalMetadata = serializedInternalMetadata;
        }

        static WriteOperation fromLogRequest(LogRequest logRequest) {
            return new WriteOperation(logRequest, WriteOperation.fromISPNByteBuffer(logRequest.getSerializedKey()), WriteOperation.fromISPNByteBuffer(logRequest.getSerializedMetadata()), WriteOperation.fromISPNByteBuffer(logRequest.getSerializedValue()), WriteOperation.fromISPNByteBuffer(logRequest.getSerializedInternalMetadata()));
        }

        static java.nio.ByteBuffer fromISPNByteBuffer(ByteBuffer byteBuffer) {
            if (byteBuffer == null) {
                return null;
            }
            return java.nio.ByteBuffer.wrap(byteBuffer.getBuf(), byteBuffer.getOffset(), byteBuffer.getLength());
        }
    }
}

