/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.Collection;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.CheckTopologyAction;
import org.infinispan.remoting.inboundhandler.action.DefaultReadyAction;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.locks.LockListener;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.LockState;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

public class NonTxPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler
implements LockListener {
    private final CheckTopologyAction checkTopologyAction = new CheckTopologyAction(this);
    @Inject
    LockManager lockManager;
    @Inject
    DistributionManager distributionManager;
    private long lockTimeout;
    private boolean isLocking;

    @Override
    public void start() {
        super.start();
        this.lockTimeout = this.configuration.locking().lockAcquisitionTimeout();
        this.isLocking = !this.configuration.clustering().cacheMode().isScattered();
    }

    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        try {
            BlockingRunnable runnable;
            int commandTopologyId = NonTxPerCacheInboundInvocationHandler.extractCommandTopologyId(command);
            boolean onExecutorService = this.executeOnExecutorService(order, command);
            boolean sync = order.preserveOrder();
            boolean waitForTransactionalData = true;
            switch (command.getCommandId()) {
                case 1: {
                    runnable = onExecutorService ? this.createReadyActionRunnable(command, reply, commandTopologyId, sync, this.createReadyAction(commandTopologyId, (SingleRpcCommand)command)) : this.createDefaultRunnable(command, reply, commandTopologyId, TopologyMode.WAIT_TX_DATA, sync);
                    break;
                }
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    waitForTransactionalData = false;
                }
                default: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, waitForTransactionalData, onExecutorService, sync);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(this.exceptionHandlingCommand(command, throwable));
        }
    }

    @Override
    public void onEvent(LockState state) {
        this.checkForReadyTasks();
    }

    private ReadyAction createReadyAction(int topologyId, RemoteLockCommand command) {
        if (command.hasSkipLocking() || !this.isLocking) {
            return null;
        }
        Collection<?> keys = command.getKeysToLock();
        if (keys.isEmpty()) {
            return null;
        }
        long timeoutMillis = command.hasZeroLockAcquisition() ? 0L : this.lockTimeout;
        DefaultReadyAction action = new DefaultReadyAction(new ActionState(command, topologyId, timeoutMillis), this.checkTopologyAction);
        action.registerListener();
        return action;
    }

    private ReadyAction createReadyAction(int topologyId, SingleRpcCommand singleRpcCommand) {
        ReplicableCommand command = singleRpcCommand.getCommand();
        return command instanceof RemoteLockCommand ? this.createReadyAction(topologyId, (RemoteLockCommand)command) : null;
    }
}

