/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.dto.transit;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.quarkus.vault.runtime.client.dto.VaultModel;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class VaultTransitKeyVersionData
implements VaultModel {
    public String name;
    @JsonProperty(value="creation_time")
    public OffsetDateTime creationTime;
    @JsonProperty(value="public_key")
    public String publicKey;

    static class Deserializer
    extends JsonDeserializer<VaultTransitKeyVersionData> {
        Deserializer() {
        }

        public VaultTransitKeyVersionData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                long timestamp = (Long)p.readValueAs(Long.class);
                VaultTransitKeyVersionData data = new VaultTransitKeyVersionData();
                data.creationTime = Instant.ofEpochSecond(timestamp).atOffset(ZoneOffset.UTC);
                return data;
            }
            return (VaultTransitKeyVersionData)p.readValueAs(VaultTransitKeyVersionData.class);
        }
    }
}

