/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images.builder.dockerfile;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.builder.dockerfile.statement.Statement;
import org.testcontainers.images.builder.dockerfile.traits.AddStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.CmdStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.CopyStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.DockerfileBuilderTrait;
import org.testcontainers.images.builder.dockerfile.traits.EntryPointStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.EnvStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.ExposeStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.FromStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.LabelStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.RunStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.UserStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.VolumeStatementTrait;
import org.testcontainers.images.builder.dockerfile.traits.WorkdirStatementTrait;

public class DockerfileBuilder
implements DockerfileBuilderTrait<DockerfileBuilder>,
FromStatementTrait<DockerfileBuilder>,
AddStatementTrait<DockerfileBuilder>,
CopyStatementTrait<DockerfileBuilder>,
RunStatementTrait<DockerfileBuilder>,
CmdStatementTrait<DockerfileBuilder>,
WorkdirStatementTrait<DockerfileBuilder>,
EnvStatementTrait<DockerfileBuilder>,
LabelStatementTrait<DockerfileBuilder>,
ExposeStatementTrait<DockerfileBuilder>,
EntryPointStatementTrait<DockerfileBuilder>,
VolumeStatementTrait<DockerfileBuilder>,
UserStatementTrait<DockerfileBuilder> {
    private static final Logger log = LoggerFactory.getLogger(DockerfileBuilder.class);
    private final List<Statement> statements = new ArrayList<Statement>();

    public String build() {
        StringBuilder builder = new StringBuilder();
        for (Statement statement : this.statements) {
            builder.append(statement.getType());
            builder.append(" ");
            statement.appendArguments(builder);
            builder.append("\n");
        }
        String result = builder.toString();
        log.debug("Returning Dockerfile:\n{}", (Object)result);
        return result;
    }

    @Override
    public List<Statement> getStatements() {
        return this.statements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerfileBuilder)) {
            return false;
        }
        DockerfileBuilder other = (DockerfileBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Statement> this$statements = this.getStatements();
        List<Statement> other$statements = other.getStatements();
        return !(this$statements == null ? other$statements != null : !((Object)this$statements).equals(other$statements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DockerfileBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Statement> $statements = this.getStatements();
        result = result * 59 + ($statements == null ? 43 : ((Object)$statements).hashCode());
        return result;
    }

    public String toString() {
        return "DockerfileBuilder(statements=" + this.getStatements() + ")";
    }
}

