/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment.jandex;

import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsDotNames;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexAnnotationInfoAdapter;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.RawBeanInfo;
import io.smallrye.metrics.elementdesc.adapter.BeanInfoAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class JandexBeanInfoAdapter
implements BeanInfoAdapter<ClassInfo> {
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    private final IndexView indexView;
    private final TransformedAnnotationsBuildItem transformedAnnotations;

    public JandexBeanInfoAdapter(IndexView indexView, TransformedAnnotationsBuildItem transformedAnnotations) {
        this.indexView = indexView;
        this.transformedAnnotations = transformedAnnotations;
    }

    public BeanInfo convert(ClassInfo input) {
        BeanInfo superClassInfo = null;
        DotName superName = input.superName();
        if (superName != null && this.indexView.getClassByName(superName) != null && !superName.equals((Object)OBJECT)) {
            superClassInfo = this.convert(this.indexView.getClassByName(superName));
        }
        JandexAnnotationInfoAdapter annotationInfoAdapter = new JandexAnnotationInfoAdapter(this.indexView);
        ArrayList annotations = new ArrayList();
        ClassInfo clazz = input;
        while (clazz != null && clazz.superName() != null) {
            List annotationsSuper = this.transformedAnnotations.getAnnotations((AnnotationTarget)clazz).stream().filter(SmallRyeMetricsDotNames::isMetricAnnotation).map(annotationInfoAdapter::convert).collect(Collectors.toList());
            annotations.addAll(annotationsSuper);
            List annotationsThroughStereotypes = this.transformedAnnotations.getAnnotations((AnnotationTarget)clazz).stream().flatMap(a -> this.getMetricAnnotationsThroughStereotype((AnnotationInstance)a, this.indexView)).collect(Collectors.toList());
            annotations.addAll(annotationsThroughStereotypes);
            clazz = this.indexView.getClassByName(clazz.superName());
        }
        return new RawBeanInfo(input.simpleName(), input.name().prefix() == null ? "" : input.name().prefix().toString(), annotations, superClassInfo);
    }

    private Stream<AnnotationInfo> getMetricAnnotationsThroughStereotype(AnnotationInstance stereotypeInstance, IndexView indexView) {
        ClassInfo annotationType = indexView.getClassByName(stereotypeInstance.name());
        if (annotationType.classAnnotation(DotNames.STEREOTYPE) != null) {
            JandexAnnotationInfoAdapter adapter = new JandexAnnotationInfoAdapter(indexView);
            return this.transformedAnnotations.getAnnotations((AnnotationTarget)annotationType).stream().filter(SmallRyeMetricsDotNames::isMetricAnnotation).map(adapter::convert);
        }
        return Stream.empty();
    }
}

