/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.JsonpParserWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.parser.JsonLocationImpl;
import oracle.jdbc.driver.json.parser.JsonTokenizer;
import oracle.jdbc.driver.json.parser.UnicodeDetectingInputStream;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonValue;

public class JsonParserImpl
implements OracleJsonParser {
    private Context currentContext = new NoneContext();
    private OracleJsonParser.Event currentEvent;
    private final Stack stack = new Stack();
    private final JsonTokenizer tokenizer;

    public JsonParserImpl(Reader reader, BufferPoolImpl bufferPoolImpl) {
        this.tokenizer = new JsonTokenizer(reader, bufferPoolImpl);
    }

    public JsonParserImpl(InputStream inputStream, BufferPoolImpl bufferPoolImpl) {
        UnicodeDetectingInputStream unicodeDetectingInputStream = new UnicodeDetectingInputStream(inputStream);
        this.tokenizer = new JsonTokenizer(new InputStreamReader((InputStream)unicodeDetectingInputStream, unicodeDetectingInputStream.getCharset()), bufferPoolImpl);
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public String getString() {
        if (this.currentEvent == OracleJsonParser.Event.KEY_NAME || this.currentEvent == OracleJsonParser.Event.VALUE_STRING || this.currentEvent == OracleJsonParser.Event.VALUE_DECIMAL) {
            return this.tokenizer.getValue();
        }
        throw OracleJsonExceptions.PARSER_GETSTRING_ERR.create(this.factory(), new Object[]{this.currentEvent});
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_ISINTEGRAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.isIntegral();
    }

    @Override
    public int getInt() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getInt();
    }

    @Override
    public double getDouble() {
        return this.getBigDecimal().doubleValue();
    }

    @Override
    public float getFloat() {
        return this.getBigDecimal().floatValue();
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    boolean isDefinitelyInt() {
        return this.tokenizer.isDefinitelyInt();
    }

    boolean isDefinitelyLong() {
        return this.tokenizer.isDefinitelyLong();
    }

    @Override
    public long getLong() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETLONG_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getBigDecimal();
    }

    @Override
    public OracleJsonArray getArray() {
        if (this.currentEvent != OracleJsonParser.Event.START_ARRAY) {
            throw OracleJsonExceptions.PARSER_GETARRAY_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.getValue().asJsonArray();
    }

    @Override
    public OracleJsonObject getObject() {
        if (this.currentEvent != OracleJsonParser.Event.START_OBJECT) {
            throw OracleJsonExceptions.PARSER_GETOBJECT_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.getValue().asJsonObject();
    }

    @Override
    public OracleJsonValue getValue() {
        ArrayDeque<OracleJsonStructure> arrayDeque = new ArrayDeque<OracleJsonStructure>(4);
        OracleJsonValue oracleJsonValue = null;
        String string = null;
        if (this.currentEvent == null || this.currentEvent == OracleJsonParser.Event.END_ARRAY || this.currentEvent == OracleJsonParser.Event.END_OBJECT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE_VALUE.create(this.factory(), new Object[0]);
        }
        block11: while (true) {
            switch (this.currentEvent) {
                case END_ARRAY: 
                case END_OBJECT: {
                    oracleJsonValue = (OracleJsonValue)arrayDeque.pop();
                    break;
                }
                case KEY_NAME: {
                    string = this.getString();
                    this.next();
                    continue block11;
                }
                case START_ARRAY: {
                    oracleJsonValue = new OracleJsonArrayImpl();
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    arrayDeque.push(oracleJsonValue.asJsonArray());
                    break;
                }
                case START_OBJECT: {
                    oracleJsonValue = new OracleJsonObjectImpl();
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    arrayDeque.push(oracleJsonValue.asJsonObject());
                    break;
                }
                case VALUE_DECIMAL: {
                    oracleJsonValue = this.isDefinitelyInt() ? new OracleJsonDecimalImpl(this.getInt(), null) : (this.isDefinitelyLong() ? new OracleJsonDecimalImpl(this.getLong(), null) : new OracleJsonDecimalImpl(this.getBigDecimal()));
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_STRING: {
                    oracleJsonValue = new OracleJsonStringImpl(this.getString());
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_TRUE: {
                    oracleJsonValue = OracleJsonValue.TRUE;
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_FALSE: {
                    oracleJsonValue = OracleJsonValue.FALSE;
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_NULL: {
                    oracleJsonValue = OracleJsonValue.NULL;
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            string = null;
            if (arrayDeque.isEmpty()) break;
            this.next();
        }
        return oracleJsonValue;
    }

    private static void addValue(OracleJsonValue oracleJsonValue, ArrayDeque<OracleJsonStructure> arrayDeque, String string) {
        if (arrayDeque.isEmpty()) {
            return;
        }
        OracleJsonStructure oracleJsonStructure = arrayDeque.peek();
        if (oracleJsonStructure.getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            oracleJsonStructure.asJsonObject().put(string, oracleJsonValue);
        } else {
            oracleJsonStructure.asJsonArray().add(oracleJsonValue);
        }
    }

    @Override
    public void skipArray() {
        if (this.currentEvent == OracleJsonParser.Event.START_ARRAY) {
            this.currentContext.skip();
            this.currentContext = this.stack.pop();
            this.currentEvent = OracleJsonParser.Event.END_ARRAY;
        }
    }

    @Override
    public void skipObject() {
        if (this.currentEvent == OracleJsonParser.Event.START_OBJECT) {
            this.currentContext.skip();
            this.currentContext = this.stack.pop();
            this.currentEvent = OracleJsonParser.Event.END_OBJECT;
        }
    }

    public JsonLocationImpl getLocation() {
        return this.tokenizer.getLocation();
    }

    public JsonLocationImpl getLastCharLocation() {
        return this.tokenizer.getLastCharLocation();
    }

    @Override
    public boolean hasNext() {
        if (this.stack.isEmpty() && this.currentEvent != null && this.currentEvent.compareTo(OracleJsonParser.Event.KEY_NAME) > 0) {
            JsonTokenizer.JsonToken jsonToken = this.tokenizer.nextToken();
            if (jsonToken != JsonTokenizer.JsonToken.EOF) {
                throw OracleJsonExceptions.PARSER_EXPECTED_EOF.create(this.factory(), new Object[]{this.currentEvent});
            }
            return false;
        }
        if (!this.stack.isEmpty() && !this.tokenizer.hasNextToken()) {
            this.currentEvent = this.currentContext.getNextEvent();
            return false;
        }
        return true;
    }

    @Override
    public OracleJsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEvent = this.currentContext.getNextEvent();
        return this.currentEvent;
    }

    @Override
    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), new Object[]{this.currentEvent});
        }
    }

    private RuntimeException parsingException(JsonTokenizer.JsonToken jsonToken, String string) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return OracleJsonExceptions.PARSER_INVALID_TOKEN.create(this.factory(), new Object[]{jsonToken, jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber(), string});
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        try {
            return clazz.cast(new JsonpParserWrapper(this));
        }
        catch (ClassCastException classCastException) {
            throw OracleJsonExceptions.BAD_WRAP.create(this.factory(), classCastException, clazz.getName());
        }
    }

    @Override
    public Period getPeriod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Duration getDuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getBytes(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    private final class ArrayContext
    extends Context {
        private boolean firstValue;

        private ArrayContext() {
            this.firstValue = true;
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            if (jsonToken == JsonTokenizer.JsonToken.EOF) {
                switch (JsonParserImpl.this.currentEvent) {
                    case START_ARRAY: {
                        throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
                    }
                }
                throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA, CURLYCLOSE]");
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUARECLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return OracleJsonParser.Event.END_ARRAY;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (jsonToken != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA]");
                }
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (jsonToken.isValue()) {
                return jsonToken.getEvent();
            }
            if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return OracleJsonParser.Event.START_OBJECT;
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return OracleJsonParser.Event.START_ARRAY;
            }
            throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }

        @Override
        void skip() {
            JsonTokenizer.JsonToken jsonToken;
            int n2 = 1;
            do {
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
                switch (jsonToken) {
                    case SQUARECLOSE: {
                        --n2;
                        break;
                    }
                    case SQUAREOPEN: {
                        ++n2;
                        break;
                    }
                }
            } while (jsonToken != JsonTokenizer.JsonToken.SQUARECLOSE || n2 != 0);
        }
    }

    private final class ObjectContext
    extends Context {
        private boolean firstValue;

        private ObjectContext() {
            this.firstValue = true;
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            if (jsonToken == JsonTokenizer.JsonToken.EOF) {
                switch (JsonParserImpl.this.currentEvent) {
                    case START_OBJECT: {
                        throw JsonParserImpl.this.parsingException(jsonToken, "[STRING, CURLYCLOSE]");
                    }
                    case KEY_NAME: {
                        throw JsonParserImpl.this.parsingException(jsonToken, "[COLON]");
                    }
                }
                throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA, CURLYCLOSE]");
            }
            if (JsonParserImpl.this.currentEvent == OracleJsonParser.Event.KEY_NAME) {
                if (jsonToken != JsonTokenizer.JsonToken.COLON) {
                    throw JsonParserImpl.this.parsingException(jsonToken, "[COLON]");
                }
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
                if (jsonToken.isValue()) {
                    return jsonToken.getEvent();
                }
                if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ObjectContext();
                    return OracleJsonParser.Event.START_OBJECT;
                }
                if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ArrayContext();
                    return OracleJsonParser.Event.START_ARRAY;
                }
                throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
            }
            if (jsonToken == JsonTokenizer.JsonToken.CURLYCLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return OracleJsonParser.Event.END_OBJECT;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (jsonToken != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA]");
                }
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (jsonToken == JsonTokenizer.JsonToken.STRING) {
                return OracleJsonParser.Event.KEY_NAME;
            }
            throw JsonParserImpl.this.parsingException(jsonToken, "[STRING]");
        }

        @Override
        void skip() {
            JsonTokenizer.JsonToken jsonToken;
            int n2 = 1;
            do {
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
                switch (jsonToken) {
                    case CURLYCLOSE: {
                        --n2;
                        break;
                    }
                    case CURLYOPEN: {
                        ++n2;
                        break;
                    }
                }
            } while (jsonToken != JsonTokenizer.JsonToken.CURLYCLOSE || n2 != 0);
        }
    }

    private final class NoneContext
    extends Context {
        private NoneContext() {
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return OracleJsonParser.Event.START_OBJECT;
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return OracleJsonParser.Event.START_ARRAY;
            }
            if (jsonToken.isValue()) {
                return jsonToken.getEvent();
            }
            throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }

        @Override
        void skip() {
        }
    }

    private abstract class Context {
        Context next;

        private Context() {
        }

        abstract OracleJsonParser.Event getNextEvent();

        abstract void skip();
    }

    private static final class Stack {
        private Context head;

        private Stack() {
        }

        private void push(Context context) {
            context.next = this.head;
            this.head = context;
        }

        private Context pop() {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            Context context = this.head;
            this.head = this.head.next;
            return context;
        }

        private boolean isEmpty() {
            return this.head == null;
        }
    }
}

