/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class KeycloakPropertiesConfigSource
extends AbstractLocationConfigSourceLoader {
    private static final Pattern DOT_SPLIT = Pattern.compile("\\.");
    private static final String KEYCLOAK_CONFIG_FILE_ENV = "KC_CONFIG_FILE";
    private static final String KEYCLOAK_PROPERTIES = "keycloak.properties";
    public static final String KEYCLOAK_CONFIG_FILE_PROP = "kc.config.file";

    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        return new PropertiesConfigSource(KeycloakPropertiesConfigSource.transform(ConfigSourceUtil.urlToMap((URL)url)), KEYCLOAK_PROPERTIES, ordinal);
    }

    private static Map<String, String> transform(Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        properties.keySet().forEach(k -> {
            String key = KeycloakPropertiesConfigSource.transformKey(k);
            String value = StringPropertyReplacer.replaceProperties((String)((String)properties.get(k)));
            result.put(key, value);
            result.put(Configuration.getMappedPropertyName(key), value);
        });
        return result;
    }

    private static String transformKey(String key) {
        String[] keyParts = DOT_SPLIT.split(key);
        String extension = keyParts[0];
        String profile = "";
        String transformed = key;
        if (extension.startsWith("%")) {
            profile = String.format("%s.", keyParts[0]);
            extension = keyParts[1];
            transformed = key.substring(key.indexOf(46) + 1);
        }
        if (extension.equalsIgnoreCase("quarkus")) {
            return key;
        }
        String namespace = "kc";
        return profile + namespace + "." + transformed;
    }

    public static class InFileSystem
    extends KeycloakPropertiesConfigSource
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            Path configFile = this.getConfigurationFile();
            if (configFile == null) {
                return Collections.emptyList();
            }
            return this.loadConfigSources(configFile.toUri().toString(), 250, classLoader);
        }

        protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
            return Collections.emptyList();
        }

        private Path getConfigurationFile() {
            File file;
            String homeDir;
            String filePath = System.getProperty(KeycloakPropertiesConfigSource.KEYCLOAK_CONFIG_FILE_PROP);
            if (filePath == null) {
                filePath = System.getenv(KeycloakPropertiesConfigSource.KEYCLOAK_CONFIG_FILE_ENV);
            }
            if (filePath == null && (homeDir = Environment.getHomeDir()) != null && (file = Paths.get(homeDir, "conf", KeycloakPropertiesConfigSource.KEYCLOAK_PROPERTIES).toFile()).exists()) {
                filePath = file.getAbsolutePath();
            }
            if (filePath == null) {
                return null;
            }
            return Paths.get(filePath, new String[0]);
        }
    }

    public static class InClassPath
    extends KeycloakPropertiesConfigSource
    implements ConfigSourceProvider {
        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return this.loadConfigSources("META-INF/keycloak.properties", 240, classLoader);
        }

        protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
            try {
                return super.tryClassPath(uri, ordinal, classLoader);
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NoSuchFileException) {
                    return Collections.emptyList();
                }
                throw e;
            }
        }

        protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
            return Collections.emptyList();
        }
    }
}

