/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Comparator;
import org.jboss.logging.Logger;
import org.keycloak.truststore.JSSETruststoreConfigurator;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderSingleton;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory
implements Comparator {
    private static final Logger log = Logger.getLogger(SSLSocketFactory.class);
    private static SSLSocketFactory instance;
    private final javax.net.ssl.SSLSocketFactory sslsf;

    private SSLSocketFactory() {
        TruststoreProvider provider = TruststoreProviderSingleton.get();
        javax.net.ssl.SSLSocketFactory sf = null;
        if (provider != null) {
            sf = new JSSETruststoreConfigurator(provider).getSSLSocketFactory();
        }
        if (sf == null) {
            log.info((Object)"No truststore provider found - using default SSLSocketFactory");
            sf = (javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault();
        }
        this.sslsf = sf;
    }

    public static synchronized SSLSocketFactory getDefault() {
        if (instance == null) {
            instance = new SSLSocketFactory();
        }
        return instance;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslsf.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslsf.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.sslsf.createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.sslsf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.sslsf.createSocket(host, port, localHost, localPort);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.sslsf.createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sslsf.createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.sslsf.createSocket();
    }

    public int compare(Object socketFactory1, Object socketFactory2) {
        return socketFactory1.equals(socketFactory2) ? 0 : -1;
    }
}

