/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.maven.dependency.ArtifactKey;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DevModeContext
implements Serializable {
    public static final CompilationUnit EMPTY_COMPILATION_UNIT = new CompilationUnit(PathsCollection.of((Path[])new Path[0]), null, null, null);
    public static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private ModuleInfo applicationRoot;
    private final List<ModuleInfo> additionalModules = new ArrayList<ModuleInfo>();
    private final Map<String, String> systemProperties = new HashMap<String, String>();
    private final Map<String, String> buildSystemProperties = new HashMap<String, String>();
    private String sourceEncoding;
    private final List<URL> additionalClassPathElements = new ArrayList<URL>();
    private File cacheDir;
    private File projectDir;
    private boolean test;
    private boolean abortOnFailedStart;
    private File devModeRunnerJarFile;
    private boolean localProjectDiscovery = true;
    private String[] args;
    private List<String> compilerOptions;
    private String releaseJavaVersion;
    private String sourceJavaVersion;
    private String targetJvmVersion;
    private List<String> compilerPluginArtifacts;
    private List<String> compilerPluginsOptions;
    private String alternateEntryPoint;
    private QuarkusBootstrap.Mode mode = QuarkusBootstrap.Mode.DEV;
    private String baseName;
    private final Set<AppArtifactKey> localArtifacts = new HashSet<AppArtifactKey>();

    public boolean isLocalProjectDiscovery() {
        return this.localProjectDiscovery;
    }

    public DevModeContext setLocalProjectDiscovery(boolean localProjectDiscovery) {
        this.localProjectDiscovery = localProjectDiscovery;
        return this;
    }

    public String getAlternateEntryPoint() {
        return this.alternateEntryPoint;
    }

    public DevModeContext setAlternateEntryPoint(String alternateEntryPoint) {
        this.alternateEntryPoint = alternateEntryPoint;
        return this;
    }

    public ModuleInfo getApplicationRoot() {
        return this.applicationRoot;
    }

    public DevModeContext setApplicationRoot(ModuleInfo applicationRoot) {
        this.applicationRoot = applicationRoot;
        return this;
    }

    public List<ModuleInfo> getAdditionalModules() {
        return this.additionalModules;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getBuildSystemProperties() {
        return this.buildSystemProperties;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public List<URL> getAdditionalClassPathElements() {
        return this.additionalClassPathElements;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public boolean isAbortOnFailedStart() {
        return this.abortOnFailedStart;
    }

    public void setAbortOnFailedStart(boolean abortOnFailedStart) {
        this.abortOnFailedStart = abortOnFailedStart;
    }

    public List<String> getCompilerOptions() {
        return this.compilerOptions;
    }

    public void setCompilerOptions(List<String> compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public String getReleaseJavaVersion() {
        return this.releaseJavaVersion;
    }

    public void setReleaseJavaVersion(String releaseJavaVersion) {
        this.releaseJavaVersion = releaseJavaVersion;
    }

    public String getSourceJavaVersion() {
        return this.sourceJavaVersion;
    }

    public void setSourceJavaVersion(String sourceJavaVersion) {
        this.sourceJavaVersion = sourceJavaVersion;
    }

    public String getTargetJvmVersion() {
        return this.targetJvmVersion;
    }

    public void setTargetJvmVersion(String targetJvmVersion) {
        this.targetJvmVersion = targetJvmVersion;
    }

    public List<String> getCompilerPluginArtifacts() {
        return this.compilerPluginArtifacts;
    }

    public void setCompilerPluginArtifacts(List<String> compilerPluginArtifacts) {
        this.compilerPluginArtifacts = compilerPluginArtifacts;
    }

    public List<String> getCompilerPluginsOptions() {
        return this.compilerPluginsOptions;
    }

    public void setCompilerPluginsOptions(List<String> compilerPluginsOptions) {
        this.compilerPluginsOptions = compilerPluginsOptions;
    }

    public File getDevModeRunnerJarFile() {
        return this.devModeRunnerJarFile;
    }

    public void setDevModeRunnerJarFile(File devModeRunnerJarFile) {
        this.devModeRunnerJarFile = devModeRunnerJarFile;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public DevModeContext setProjectDir(File projectDir) {
        this.projectDir = projectDir;
        return this;
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public List<ModuleInfo> getAllModules() {
        ArrayList<ModuleInfo> ret = new ArrayList<ModuleInfo>();
        ret.add(this.applicationRoot);
        ret.addAll(this.additionalModules);
        return ret;
    }

    public QuarkusBootstrap.Mode getMode() {
        return this.mode;
    }

    public void setMode(QuarkusBootstrap.Mode mode) {
        this.mode = mode;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public Set<AppArtifactKey> getLocalArtifacts() {
        return this.localArtifacts;
    }

    public boolean isEnablePreview() {
        if (this.compilerOptions == null) {
            return false;
        }
        return this.compilerOptions.contains(ENABLE_PREVIEW_FLAG);
    }

    public static class CompilationUnit
    implements Serializable {
        private PathsCollection sourcePaths;
        private final String classesPath;
        private final PathsCollection resourcePaths;
        private final String resourcesOutputPath;

        public CompilationUnit(PathsCollection sourcePaths, String classesPath, PathsCollection resourcePaths, String resourcesOutputPath) {
            this.sourcePaths = sourcePaths;
            this.classesPath = classesPath;
            this.resourcePaths = resourcePaths;
            this.resourcesOutputPath = resourcesOutputPath;
        }

        public PathsCollection getSourcePaths() {
            return this.sourcePaths;
        }

        public String getClassesPath() {
            return this.classesPath;
        }

        public PathsCollection getResourcePaths() {
            return this.resourcePaths;
        }

        public String getResourcesOutputPath() {
            return this.resourcesOutputPath;
        }
    }

    public static class ModuleInfo
    implements Serializable {
        private final ArtifactKey appArtifactKey;
        private final String name;
        private final String projectDirectory;
        private final CompilationUnit main;
        private final CompilationUnit test;
        private final String preBuildOutputDir;
        private final PathsCollection sourceParents;
        private final String targetDir;

        ModuleInfo(Builder builder) {
            this.appArtifactKey = builder.appArtifactKey;
            this.name = builder.name;
            this.projectDirectory = builder.projectDirectory;
            this.main = new CompilationUnit(builder.sourcePaths, builder.classesPath, builder.resourcePaths, builder.resourcesOutputPath);
            this.test = builder.testClassesPath != null ? new CompilationUnit(builder.testSourcePaths, builder.testClassesPath, builder.testResourcePaths, builder.testResourcesOutputPath) : null;
            this.sourceParents = builder.sourceParents;
            this.preBuildOutputDir = builder.preBuildOutputDir;
            this.targetDir = builder.targetDir;
        }

        public String getName() {
            return this.name;
        }

        public String getProjectDirectory() {
            return this.projectDirectory;
        }

        public PathsCollection getSourceParents() {
            return this.sourceParents;
        }

        public void addSourcePaths(Collection<String> additionalPaths) {
            this.main.sourcePaths = this.main.sourcePaths.add((Path[])additionalPaths.stream().map(p -> Paths.get(p, new String[0]).isAbsolute() ? p : this.projectDirectory + File.separator + p).map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new));
        }

        public String getPreBuildOutputDir() {
            return this.preBuildOutputDir;
        }

        public String getTargetDir() {
            return this.targetDir;
        }

        public ArtifactKey getArtifactKey() {
            return this.appArtifactKey;
        }

        public CompilationUnit getMain() {
            return this.main;
        }

        public Optional<CompilationUnit> getTest() {
            return Optional.ofNullable(this.test);
        }

        public static class Builder {
            private ArtifactKey appArtifactKey;
            private String name;
            private String projectDirectory;
            private PathsCollection sourcePaths = PathsCollection.of((Path[])new Path[0]);
            private String classesPath;
            private PathsCollection resourcePaths = PathsCollection.of((Path[])new Path[0]);
            private String resourcesOutputPath;
            private String preBuildOutputDir;
            private PathsCollection sourceParents = PathsCollection.of((Path[])new Path[0]);
            private String targetDir;
            private PathsCollection testSourcePaths = PathsCollection.of((Path[])new Path[0]);
            private String testClassesPath;
            private PathsCollection testResourcePaths = PathsCollection.of((Path[])new Path[0]);
            private String testResourcesOutputPath;

            public Builder setArtifactKey(ArtifactKey appArtifactKey) {
                this.appArtifactKey = appArtifactKey;
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setProjectDirectory(String projectDirectory) {
                this.projectDirectory = projectDirectory;
                return this;
            }

            public Builder setSourcePaths(PathsCollection sourcePaths) {
                this.sourcePaths = sourcePaths;
                return this;
            }

            public Builder setClassesPath(String classesPath) {
                this.classesPath = classesPath;
                return this;
            }

            public Builder setResourcePaths(PathsCollection resourcePaths) {
                this.resourcePaths = resourcePaths;
                return this;
            }

            public Builder setResourcesOutputPath(String resourcesOutputPath) {
                this.resourcesOutputPath = resourcesOutputPath;
                return this;
            }

            public Builder setPreBuildOutputDir(String preBuildOutputDir) {
                this.preBuildOutputDir = preBuildOutputDir;
                return this;
            }

            public Builder setSourceParents(PathsCollection sourceParents) {
                this.sourceParents = sourceParents;
                return this;
            }

            public Builder setTargetDir(String targetDir) {
                this.targetDir = targetDir;
                return this;
            }

            public Builder setTestSourcePaths(PathsCollection testSourcePaths) {
                this.testSourcePaths = testSourcePaths;
                return this;
            }

            public Builder setTestClassesPath(String testClassesPath) {
                this.testClassesPath = testClassesPath;
                return this;
            }

            public Builder setTestResourcePaths(PathsCollection testResourcePaths) {
                this.testResourcePaths = testResourcePaths;
                return this;
            }

            public Builder setTestResourcesOutputPath(String testResourcesOutputPath) {
                this.testResourcesOutputPath = testResourcesOutputPath;
                return this;
            }

            public ModuleInfo build() {
                return new ModuleInfo(this);
            }
        }
    }
}

