/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.quarkus.hibernate.cache;

import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.infinispan.quarkus.hibernate.cache.InternalRegion;
import org.jboss.logging.Logger;

final class VersionedEntry {
    private static final Logger log = Logger.getLogger(VersionedEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final Duration TOMBSTONE_LIFESPAN = Duration.ofSeconds(60L);
    static final ExcludeEmptyFilter EXCLUDE_EMPTY_VERSIONED_ENTRY = new ExcludeEmptyFilter();
    private final Object value;
    private final Object version;
    private final long timestamp;
    private Duration lifespan = Duration.ofSeconds(Long.MAX_VALUE);

    VersionedEntry(Object value, Object version, long timestamp) {
        this.value = value;
        this.version = version;
        this.timestamp = timestamp;
    }

    VersionedEntry(long timestamp) {
        this(null, null, timestamp);
    }

    VersionedEntry(long timestamp, Duration lifespan) {
        this(null, null, timestamp);
        this.lifespan = lifespan;
    }

    Object getVersion() {
        return this.version;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    long getLifespanNanos() {
        return this.lifespan.toNanos();
    }

    Object getValue() {
        return this.value;
    }

    private static class ExcludeEmptyFilter
    implements Predicate<Map.Entry> {
        private ExcludeEmptyFilter() {
        }

        @Override
        public boolean test(Map.Entry entry) {
            if (entry.getValue() instanceof VersionedEntry) {
                return ((VersionedEntry)entry.getValue()).getValue() != null;
            }
            return true;
        }
    }

    static final class ComputeFn
    implements BiFunction<Object, Object, Object> {
        final VersionedEntry entry;
        final InternalRegion region;

        ComputeFn(VersionedEntry entry, InternalRegion region) {
            this.entry = entry;
            this.region = region;
        }

        @Override
        public Object apply(Object key, Object oldValue) {
            Object oldVersion;
            if (trace) {
                log.tracef("Applying %s to %s", (Object)this, oldValue);
            }
            if (this.entry.version == null) {
                this.entry.lifespan = TOMBSTONE_LIFESPAN;
                return this.entry;
            }
            long oldTimestamp = Long.MIN_VALUE;
            if (oldValue instanceof VersionedEntry) {
                VersionedEntry oldVersionedEntry = (VersionedEntry)oldValue;
                oldVersion = oldVersionedEntry.version;
                oldTimestamp = oldVersionedEntry.timestamp;
                oldValue = oldVersionedEntry.value;
            } else {
                oldVersion = ComputeFn.findVersion(oldValue);
            }
            if (oldVersion == null) {
                assert (oldValue == null || oldTimestamp != Long.MIN_VALUE) : oldValue;
                if (this.entry.timestamp <= oldTimestamp) {
                    assert (oldValue == null);
                    return null;
                }
                return this.entry.value instanceof CacheEntry ? this.entry.value : this.entry;
            }
            Comparator<Object> versionComparator = null;
            String subclass = ComputeFn.findSubclass(this.entry.value);
            if (subclass != null && (versionComparator = this.region.getComparator(subclass)) == null) {
                log.errorf("Cannot find comparator for %s", (Object)subclass);
            }
            if (versionComparator == null) {
                this.entry.lifespan = TOMBSTONE_LIFESPAN;
                return new VersionedEntry(null, null, this.entry.timestamp);
            }
            int compareResult = versionComparator.compare(this.entry.version, oldVersion);
            if (trace) {
                log.tracef("Comparing %s and %s -> %d (using %s)", new Object[]{this.entry.version, oldVersion, compareResult, versionComparator});
            }
            if (this.entry.value == null && compareResult >= 0) {
                this.entry.lifespan = TOMBSTONE_LIFESPAN;
                return this.entry;
            }
            if (compareResult > 0) {
                return this.entry.value instanceof CacheEntry ? this.entry.value : this.entry;
            }
            return oldValue;
        }

        private static Object findVersion(Object entry) {
            if (entry instanceof CacheEntry) {
                return ((CacheEntry)entry).getVersion();
            }
            if (entry instanceof Map) {
                return ((Map)entry).get("_version");
            }
            return null;
        }

        private static String findSubclass(Object entry) {
            if (entry instanceof CacheEntry) {
                return ((CacheEntry)entry).getSubclass();
            }
            if (entry instanceof Map) {
                Object maybeSubclass = ((Map)entry).get("_subclass");
                return maybeSubclass instanceof String ? (String)maybeSubclass : null;
            }
            return null;
        }
    }
}

