/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.sifs.EntryInfo;
import org.infinispan.persistence.sifs.EntryMetadata;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.Index;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.LogFactory;

class Compactor
implements Consumer<Object> {
    private static final Log log = LogFactory.getLog(Compactor.class, Log.class);
    private final NonBlockingManager nonBlockingManager;
    private final ConcurrentMap<Integer, Stats> fileStats = new ConcurrentHashMap<Integer, Stats>();
    private final FileProvider fileProvider;
    private final TemporaryTable temporaryTable;
    private final Marshaller marshaller;
    private final TimeService timeService;
    private final KeyPartitioner keyPartitioner;
    private final int maxFileSize;
    private final double compactionThreshold;
    private final FlowableProcessor<Object> processor;
    private Index index;
    private final AtomicBoolean clearSignal = new AtomicBoolean();
    private volatile boolean terminateSignal = false;
    private CompletableFuture<Void> paused = CompletableFutures.completedNull();
    private static final Object RESUME_PILL = new Object();
    private final ByteBuffer REUSED_BUFFER = ByteBuffer.allocate(27);
    FileProvider.Log logFile = null;
    long nextExpirationTime = -1L;
    int currentOffset = 0;

    public Compactor(NonBlockingManager nonBlockingManager, FileProvider fileProvider, TemporaryTable temporaryTable, Marshaller marshaller, TimeService timeService, KeyPartitioner keyPartitioner, int maxFileSize, double compactionThreshold, Executor blockingExecutor) {
        this.nonBlockingManager = nonBlockingManager;
        this.fileProvider = fileProvider;
        this.temporaryTable = temporaryTable;
        this.marshaller = marshaller;
        this.timeService = timeService;
        this.keyPartitioner = keyPartitioner;
        this.maxFileSize = maxFileSize;
        this.compactionThreshold = compactionThreshold;
        this.processor = UnicastProcessor.create();
        Scheduler scheduler = Schedulers.from((Executor)blockingExecutor);
        this.processor.observeOn(scheduler).delay(obj -> {
            if (obj == RESUME_PILL || obj instanceof CompletableFuture) {
                return Flowable.empty();
            }
            return RxJavaInterop.voidCompletionStageToFlowable(this.paused);
        }).subscribe((Consumer)this, error -> log.warn("Compactor encountered an exception", (Throwable)error));
    }

    public void setIndex(Index index) {
        this.index = index;
    }

    public void releaseStats(int file) {
        this.fileStats.remove(file);
    }

    public void free(int file, int size) {
        if (file < 0) {
            return;
        }
        this.recordFreeSpace(this.getStats(file, -1, -1L), file, size);
    }

    public void completeFile(int file, int currentSize, long nextExpirationTime) {
        Stats stats = this.getStats(file, currentSize, nextExpirationTime);
        stats.setCompleted();
        if (stats.readyToBeScheduled(this.compactionThreshold, stats.getFree())) {
            this.schedule(file, stats);
        }
    }

    public void performExpirationCompaction(CompactionExpirationSubscriber subscriber) {
        this.processor.onNext((Object)subscriber);
    }

    private Stats getStats(int file, int currentSize, long expirationTime) {
        int fileSize;
        Stats stats = (Stats)this.fileStats.get(file);
        if (stats == null) {
            fileSize = currentSize < 0 ? (int)this.fileProvider.getFileSize(file) : currentSize;
            stats = new Stats(fileSize, 0, expirationTime);
            Stats other = this.fileStats.putIfAbsent(file, stats);
            if (other != null) {
                if (fileSize > other.getTotal()) {
                    other.setTotal(fileSize);
                }
                return other;
            }
        }
        if (stats.getTotal() < 0) {
            int n = fileSize = currentSize < 0 ? (int)this.fileProvider.getFileSize(file) : currentSize;
            if (fileSize >= 0) {
                stats.setTotal(fileSize);
            }
        }
        return stats;
    }

    private void recordFreeSpace(Stats stats, int file, int size) {
        if (stats.addFree(size, this.compactionThreshold)) {
            this.schedule(file, stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(int file, Stats stats) {
        boolean shouldSchedule = false;
        Stats stats2 = stats;
        synchronized (stats2) {
            if (!stats.isScheduled()) {
                log.debugf("Scheduling file %d for compaction: %d/%d free", file, stats.free.get(), stats.total);
                stats.setScheduled();
                shouldSchedule = true;
            }
        }
        if (shouldSchedule) {
            this.processor.onNext((Object)file);
        }
    }

    public CompletionStage<Void> clearAndPause() {
        if (this.clearSignal.getAndSet(true)) {
            throw new IllegalStateException("Clear signal was already set for compactor, clear cannot be invoked concurrently with another!");
        }
        CompletableFuture<Void> clearFuture = new CompletableFuture<Void>();
        clearFuture.whenComplete((ignore, t) -> this.fileStats.clear());
        this.processor.onNext(clearFuture);
        return clearFuture;
    }

    public void resumeAfterClear() {
        if (!this.clearSignal.getAndSet(false)) {
            throw new IllegalStateException("Resume of compactor invoked without first clear and pausing!");
        }
    }

    private void resumeAfterPause() {
        this.processor.onNext(RESUME_PILL);
    }

    public void stopOperations() {
        this.terminateSignal = true;
        this.processor.onComplete();
    }

    public void accept(Object o) throws Throwable {
        if (this.terminateSignal) {
            return;
        }
        if (o == RESUME_PILL) {
            this.paused.complete(null);
            return;
        }
        if (this.clearSignal.get()) {
            if (o instanceof CompletableFuture) {
                log.tracef("Compactor ignoring all future compactions until resumed", new Object[0]);
                if (this.logFile != null) {
                    this.logFile.close();
                    this.logFile = null;
                    this.nextExpirationTime = -1L;
                }
                this.nonBlockingManager.complete((CompletableFuture)o, null);
            } else {
                log.tracef("Ignoring compaction request for %s as compactor is being cleared", o);
            }
            return;
        }
        if (o instanceof CompactionExpirationSubscriber) {
            CompactionExpirationSubscriber subscriber = (CompactionExpirationSubscriber)o;
            try {
                CloseableIterator<Integer> iter = this.fileProvider.getFileIterator();
                while (iter.hasNext()) {
                    int fileId = (Integer)iter.next();
                    Stats stats = (Stats)this.fileStats.get(fileId);
                    long currentTimeMilliseconds = this.timeService.wallClockTime();
                    boolean isLogFile = this.fileProvider.isLogFile(fileId);
                    if (stats != null && (stats.markedForDeletion() || stats.nextExpirationTime > currentTimeMilliseconds)) {
                        log.tracef("Skipping expiration for file %d since it is marked for deletion: %s or its expiration time %s is not yet", fileId, stats.markedForDeletion(), stats.nextExpirationTime);
                        continue;
                    }
                    this.compactSingleFile(fileId, isLogFile, subscriber, currentTimeMilliseconds);
                }
                subscriber.onComplete();
            }
            catch (Throwable t) {
                subscriber.onError(t);
            }
            return;
        }
        this.compactSingleFile((Integer)o, false, null, this.timeService.wallClockTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactSingleFile(int scheduledFile, boolean isLogFile, CompactionExpirationSubscriber subscriber, long currentTimeMilliseconds) throws IOException, ClassNotFoundException {
        assert (scheduledFile >= 0);
        if (subscriber == null) {
            log.tracef("Compacting file %d", scheduledFile);
        } else {
            log.tracef("Removing expired entries from file %d", scheduledFile);
        }
        int scheduledOffset = 0;
        ArrayList<EntryPosition> expiredTemp = subscriber != null ? new ArrayList<EntryPosition>() : null;
        ArrayList<EntryRecord> expiredIndex = subscriber != null ? new ArrayList<EntryRecord>() : null;
        FileProvider.Handle handle = this.fileProvider.getFile(scheduledFile);
        if (handle == null) {
            throw new IllegalStateException("Compactor should not get deleted file for compaction!");
        }
        try {
            EntryHeader header;
            Iterator aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            while (!this.clearSignal.get() && !this.terminateSignal && (header = EntryRecord.readEntryHeader(handle, scheduledOffset)) != null) {
                byte[] serializedKey = EntryRecord.readKey(handle, header, scheduledOffset);
                if (serializedKey == null) {
                    throw new IllegalStateException("End of file reached when reading key on " + handle.getFileId() + ":" + scheduledOffset);
                }
                Object key = this.marshaller.objectFromByteBuffer(serializedKey);
                int segment = this.keyPartitioner.getSegment(key);
                int valueLength = header.valueLength();
                int indexedOffset = valueLength > 0 ? scheduledOffset : ~scheduledOffset;
                boolean drop = !isLogFile;
                boolean truncate = false;
                EntryPosition entry = this.temporaryTable.get(segment, key);
                if (entry != null) {
                    EntryPosition entryPosition = entry;
                    synchronized (entryPosition) {
                        if (log.isTraceEnabled()) {
                            log.tracef("Key for %d:%d was found in temporary table on %d:%d", new Object[]{scheduledFile, scheduledOffset, entry.file, entry.offset});
                        }
                        if (entry.file == scheduledFile && entry.offset == indexedOffset) {
                            long entryExpiryTime = header.expiryTime();
                            if (entryExpiryTime >= 0L && entryExpiryTime <= currentTimeMilliseconds) {
                                if (expiredTemp != null && entry.offset >= 0) {
                                    truncate = true;
                                    expiredTemp.add(entry);
                                }
                            } else if (isLogFile) {
                                scheduledOffset += header.totalLength();
                                continue;
                            }
                        } else {
                            if (entry.file == scheduledFile && entry.offset == ~scheduledOffset) {
                                log.tracef("Key for %d:%d ignored as it was expired", new Object[0]);
                                scheduledOffset += header.totalLength();
                                continue;
                            }
                            truncate = true;
                        }
                    }
                    drop = false;
                } else {
                    EntryInfo info = this.index.getInfo(key, serializedKey);
                    assert (info != null) : "No index info found for key: " + key;
                    assert (info.numRecords > 0);
                    if (info.file == scheduledFile && info.offset == scheduledOffset) {
                        assert (header.valueLength() > 0);
                        long entryExpiryTime = header.expiryTime();
                        if (entryExpiryTime >= 0L && entryExpiryTime <= currentTimeMilliseconds) {
                            if (expiredIndex != null) {
                                EntryRecord record = this.index.getRecordEvenIfExpired(key, serializedKey);
                                truncate = true;
                                expiredIndex.add(record);
                                if (info.numRecords > 1) {
                                    drop = false;
                                }
                            } else {
                                drop = false;
                            }
                        } else {
                            if (isLogFile) {
                                scheduledOffset += header.totalLength();
                                continue;
                            }
                            drop = false;
                        }
                        if (log.isTraceEnabled()) {
                            log.tracef("Is %d:%d expired? %s, numRecords? %d", new Object[]{scheduledFile, scheduledOffset, truncate, info.numRecords});
                        }
                    } else {
                        if (isLogFile) {
                            scheduledOffset += header.totalLength();
                            continue;
                        }
                        if (info.file == scheduledFile && info.offset == ~scheduledOffset && info.numRecords > 1) {
                            drop = false;
                        } else if (log.isTraceEnabled()) {
                            log.tracef("Key for %d:%d was found in index on %d:%d, %d record => drop", new Object[]{scheduledFile, scheduledOffset, info.file, info.offset, info.numRecords});
                        }
                    }
                }
                if (drop) {
                    if (log.isTraceEnabled()) {
                        log.tracef("Drop %d:%d (%s)", scheduledFile, scheduledOffset, header.valueLength() > 0 ? "record" : "tombstone");
                    }
                    this.index.handleRequest(IndexRequest.dropped(segment, key, serializedKey, scheduledFile, scheduledOffset));
                } else {
                    int writtenLength;
                    int entryOffset;
                    if (this.logFile == null || this.currentOffset + header.totalLength() > this.maxFileSize) {
                        if (this.logFile != null) {
                            this.logFile.close();
                            this.completeFile(this.logFile.fileId, this.currentOffset, this.nextExpirationTime);
                            this.nextExpirationTime = -1L;
                        }
                        this.currentOffset = 0;
                        this.logFile = this.fileProvider.getFileForLog();
                        log.debugf("Compacting to %d", this.logFile.fileId);
                    }
                    byte[] serializedValue = null;
                    EntryMetadata metadata = null;
                    byte[] serializedInternalMetadata = null;
                    if (header.valueLength() > 0 && !truncate) {
                        if (header.metadataLength() > 0) {
                            metadata = EntryRecord.readMetadata(handle, header, scheduledOffset);
                        }
                        serializedValue = EntryRecord.readValue(handle, header, scheduledOffset);
                        if (header.internalMetadataLength() > 0) {
                            serializedInternalMetadata = EntryRecord.readInternalMetadata(handle, header, scheduledOffset);
                        }
                        entryOffset = this.currentOffset;
                        writtenLength = header.totalLength();
                        this.nextExpirationTime = ExpiryHelper.mostRecentExpirationTime(this.nextExpirationTime, header.expiryTime());
                    } else {
                        entryOffset = ~this.currentOffset;
                        writtenLength = header.getHeaderLength() + header.keyLength();
                    }
                    EntryRecord.writeEntry(this.logFile.fileChannel, this.REUSED_BUFFER, serializedKey, metadata, serializedValue, serializedInternalMetadata, header.seqId(), header.expiryTime());
                    TemporaryTable.LockedEntry lockedEntry = this.temporaryTable.replaceOrLock(segment, key, this.logFile.fileId, entryOffset, scheduledFile, indexedOffset);
                    if (lockedEntry == null) {
                        if (log.isTraceEnabled()) {
                            log.trace("Found entry in temporary table");
                        }
                    } else {
                        boolean update = false;
                        try {
                            EntryInfo info = this.index.getInfo(key, serializedKey);
                            if (info == null) {
                                throw new IllegalStateException(String.format("%s was not found in index but it was not in temporary table and there's entry on %d:%d", key, scheduledFile, indexedOffset));
                            }
                            boolean bl = update = info.file == scheduledFile && info.offset == indexedOffset;
                            if (log.isTraceEnabled()) {
                                log.tracef("In index the key is on %d:%d (%s)", info.file, info.offset, String.valueOf(update));
                            }
                        }
                        finally {
                            if (update) {
                                this.temporaryTable.updateAndUnlock(lockedEntry, this.logFile.fileId, entryOffset);
                            } else {
                                this.temporaryTable.removeAndUnlock(lockedEntry, segment, key);
                            }
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.tracef("Update %d:%d -> %d:%d | %d,%d", new Object[]{scheduledFile, indexedOffset, this.logFile.fileId, entryOffset, this.logFile.fileChannel.position(), this.logFile.fileChannel.size()});
                    }
                    IndexRequest indexRequest = isLogFile ? IndexRequest.update(segment, key, serializedKey, this.logFile.fileId, entryOffset, writtenLength) : IndexRequest.moved(segment, key, serializedKey, this.logFile.fileId, entryOffset, writtenLength, scheduledFile, indexedOffset);
                    this.index.handleRequest(indexRequest);
                    aggregateCompletionStage.dependsOn(indexRequest);
                    this.currentOffset += writtenLength;
                }
                scheduledOffset += header.totalLength();
            }
            if (!this.clearSignal.get()) {
                CompletionStage<Void> aggregate = aggregateCompletionStage.freeze();
                this.paused = new CompletableFuture();
                aggregate.whenComplete((ignore, t) -> {
                    this.resumeAfterPause();
                    if (t != null) {
                        log.error("There was a problem moving indexes for compactor with file " + this.logFile.fileId, (Throwable)t);
                    }
                });
            }
        }
        finally {
            handle.close();
        }
        if (subscriber != null) {
            for (EntryPosition entryPosition : expiredTemp) {
                subscriber.onEntryPosition(entryPosition);
            }
            for (EntryRecord entryRecord : expiredIndex) {
                subscriber.onEntryEntryRecord(entryRecord);
            }
        }
        if (isLogFile) {
            log.tracef("Finished expiring entries in log file %d, leaving file as is", scheduledFile);
        } else if (!this.terminateSignal && !this.clearSignal.get()) {
            log.tracef("Finished compacting %d, scheduling delete", scheduledFile);
            Stats stats = (Stats)this.fileStats.get(scheduledFile);
            if (stats != null) {
                stats.markForDeletion();
            }
            this.index.deleteFileAsync(scheduledFile);
        }
    }

    private static class Stats {
        private final AtomicInteger free;
        private volatile int total;
        private final long nextExpirationTime;
        private volatile boolean completed = false;
        private volatile boolean scheduled = false;
        private boolean markedForDeletion = false;

        private Stats(int total, int free, long nextExpirationTime) {
            this.free = new AtomicInteger(free);
            this.total = total;
            this.nextExpirationTime = nextExpirationTime;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public boolean addFree(int size, double compactionThreshold) {
            int free = this.free.addAndGet(size);
            return this.readyToBeScheduled(compactionThreshold, free);
        }

        public int getFree() {
            return this.free.get();
        }

        public boolean readyToBeScheduled(double compactionThreshold, int free) {
            int total = this.total;
            return this.completed && !this.scheduled && total >= 0 && (double)free >= (double)total * compactionThreshold;
        }

        public boolean isScheduled() {
            return this.scheduled;
        }

        public void setScheduled() {
            this.scheduled = true;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public void setCompleted() {
            this.completed = true;
        }

        public void markForDeletion() {
            this.markedForDeletion = true;
        }

        public boolean markedForDeletion() {
            return this.markedForDeletion;
        }
    }

    public static interface CompactionExpirationSubscriber {
        public void onEntryPosition(EntryPosition var1) throws IOException;

        public void onEntryEntryRecord(EntryRecord var1) throws IOException;

        public void onComplete();

        public void onError(Throwable var1);
    }
}

