/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.util.EncodeUtil;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.core.transport.VInt;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.Events;
import org.infinispan.server.hotrod.HashDistAware20Response;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.counter.listener.ClientCounterEvent;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.Stats;
import org.infinispan.topology.CacheTopology;
import org.jgroups.SuspectedException;

class Encoder2x
implements VersionedEncoder {
    private static final Log log = (Log)LogFactory.getLog(Encoder2x.class, Log.class);

    Encoder2x() {
    }

    @Override
    public void writeEvent(Events.Event e, ByteBuf buf) {
        this.writeHeaderNoTopology(buf, e.messageId, e.op);
        ExtendedByteBuf.writeRangedBytes(e.listenerId, buf);
        e.writeEvent(buf);
    }

    @Override
    public ByteBuf authResponse(HotRodHeader header, HotRodServer server, Channel channel, byte[] challenge) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        if (challenge != null) {
            buf.writeBoolean(false);
            ExtendedByteBuf.writeRangedBytes(challenge, buf);
        } else {
            buf.writeBoolean(true);
            ExtendedByteBuf.writeUnsignedInt(0, buf);
        }
        return buf;
    }

    @Override
    public ByteBuf authMechListResponse(HotRodHeader header, HotRodServer server, Channel channel, Set<String> mechs) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        ExtendedByteBuf.writeUnsignedInt(mechs.size(), buf);
        for (String s : mechs) {
            ExtendedByteBuf.writeString(s, buf);
        }
        return buf;
    }

    @Override
    public ByteBuf notExecutedResponse(HotRodHeader header, HotRodServer server, Channel channel, byte[] prev) {
        return this.valueResponse(header, server, channel, OperationStatus.NotExecutedWithPrevious, prev);
    }

    @Override
    public ByteBuf notExistResponse(HotRodHeader header, HotRodServer server, Channel channel) {
        return this.emptyResponse(header, server, channel, OperationStatus.KeyDoesNotExist);
    }

    @Override
    public ByteBuf valueResponse(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status, byte[] prev) {
        ByteBuf buf = this.writeHeader(header, server, channel, status);
        if (prev == null) {
            ExtendedByteBuf.writeUnsignedInt(0, buf);
        } else {
            ExtendedByteBuf.writeRangedBytes(prev, buf);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Write response to %s messageId=%d status=%s prev=%s", new Object[]{header.op, header.messageId, status, Util.printArray((byte[])prev)});
        }
        return buf;
    }

    @Override
    public ByteBuf successResponse(HotRodHeader header, HotRodServer server, Channel channel, byte[] result) {
        return this.valueResponse(header, server, channel, OperationStatus.SuccessWithPrevious, result);
    }

    @Override
    public ByteBuf errorResponse(HotRodHeader header, HotRodServer server, Channel channel, String message, OperationStatus status) {
        ByteBuf buf = this.writeHeader(header, server, channel, status);
        ExtendedByteBuf.writeString(message, buf);
        return buf;
    }

    @Override
    public ByteBuf bulkGetResponse(HotRodHeader header, HotRodServer server, Channel channel, int size, CacheSet<Map.Entry<byte[], byte[]>> entries) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        try (CloseableIterator iterator = entries.iterator();){
            int max = Integer.MAX_VALUE;
            if (size != 0) {
                if (log.isTraceEnabled()) {
                    log.tracef("About to write (max) %d messages to the client", size);
                }
                max = size;
            }
            for (int count = 0; iterator.hasNext() && count < max; ++count) {
                Map.Entry entry = (Map.Entry)iterator.next();
                buf.writeByte(1);
                ExtendedByteBuf.writeRangedBytes((byte[])entry.getKey(), buf);
                ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), buf);
            }
            buf.writeByte(0);
        }
        return buf;
    }

    @Override
    public ByteBuf emptyResponse(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status) {
        return this.writeHeader(header, server, channel, status);
    }

    @Override
    public ByteBuf pingResponse(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status) {
        if (HotRodVersion.HOTROD_30.isAtLeast(header.version)) {
            ByteBuf buf = this.writeHeader(header, server, channel, status, true);
            buf.writeByte((int)HotRodVersion.LATEST.getVersion());
            ExtendedByteBuf.writeUnsignedInt(HotRodOperation.REQUEST_COUNT, buf);
            for (HotRodOperation op : HotRodOperation.VALUES) {
                if (op.getRequestOpCode() <= 0) continue;
                buf.writeShort(op.getRequestOpCode());
            }
            return buf;
        }
        return this.writeHeader(header, server, channel, status, true);
    }

    @Override
    public ByteBuf statsResponse(HotRodHeader header, HotRodServer server, Channel channel, Stats stats, NettyTransport transport, ComponentRegistry cacheRegistry) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        int numStats = 9;
        if (transport != null) {
            numStats += 2;
        }
        ClusterCacheStats clusterCacheStats = null;
        if (HotRodVersion.HOTROD_24.isAtLeast(header.version) && (clusterCacheStats = (ClusterCacheStats)cacheRegistry.getComponent(ClusterCacheStats.class)) != null) {
            numStats += 7;
        }
        ExtendedByteBuf.writeUnsignedInt(numStats, buf);
        this.writePair(buf, "timeSinceStart", String.valueOf(stats.getTimeSinceStart()));
        this.writePair(buf, "currentNumberOfEntries", String.valueOf(stats.getCurrentNumberOfEntries()));
        this.writePair(buf, "totalNumberOfEntries", String.valueOf(stats.getTotalNumberOfEntries()));
        this.writePair(buf, "stores", String.valueOf(stats.getStores()));
        this.writePair(buf, "retrievals", String.valueOf(stats.getRetrievals()));
        this.writePair(buf, "hits", String.valueOf(stats.getHits()));
        this.writePair(buf, "misses", String.valueOf(stats.getMisses()));
        this.writePair(buf, "removeHits", String.valueOf(stats.getRemoveHits()));
        this.writePair(buf, "removeMisses", String.valueOf(stats.getRemoveMisses()));
        if (transport != null) {
            this.writePair(buf, "totalBytesRead", String.valueOf(transport.getTotalBytesRead()));
            this.writePair(buf, "totalBytesWritten", String.valueOf(transport.getTotalBytesWritten()));
        }
        if (clusterCacheStats != null) {
            this.writePair(buf, "globalCurrentNumberOfEntries", String.valueOf(clusterCacheStats.getCurrentNumberOfEntries()));
            this.writePair(buf, "globalStores", String.valueOf(clusterCacheStats.getStores()));
            this.writePair(buf, "globalRetrievals", String.valueOf(clusterCacheStats.getRetrievals()));
            this.writePair(buf, "globalHits", String.valueOf(clusterCacheStats.getHits()));
            this.writePair(buf, "globalMisses", String.valueOf(clusterCacheStats.getMisses()));
            this.writePair(buf, "globalRemoveHits", String.valueOf(clusterCacheStats.getRemoveHits()));
            this.writePair(buf, "globalRemoveMisses", String.valueOf(clusterCacheStats.getRemoveMisses()));
        }
        return buf;
    }

    private void writePair(ByteBuf buf, String key, String value) {
        ExtendedByteBuf.writeString(key, buf);
        ExtendedByteBuf.writeString(value, buf);
    }

    @Override
    public ByteBuf valueWithVersionResponse(HotRodHeader header, HotRodServer server, Channel channel, byte[] value, long version) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        buf.writeLong(version);
        ExtendedByteBuf.writeRangedBytes(value, buf);
        return buf;
    }

    @Override
    public ByteBuf getWithMetadataResponse(HotRodHeader header, HotRodServer server, Channel channel, CacheEntry<byte[], byte[]> entry) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        MetadataUtils.writeMetadata(MetadataUtils.extractLifespan(entry), MetadataUtils.extractMaxIdle(entry), MetadataUtils.extractCreated(entry), MetadataUtils.extractLastUsed(entry), MetadataUtils.extractVersion(entry), buf);
        ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), buf);
        return buf;
    }

    @Override
    public ByteBuf getStreamResponse(HotRodHeader header, HotRodServer server, Channel channel, int offset, CacheEntry<byte[], byte[]> entry) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        MetadataUtils.writeMetadata(MetadataUtils.extractLifespan(entry), MetadataUtils.extractMaxIdle(entry), MetadataUtils.extractCreated(entry), MetadataUtils.extractLastUsed(entry), MetadataUtils.extractVersion(entry), buf);
        ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), offset, buf);
        return buf;
    }

    @Override
    public ByteBuf getAllResponse(HotRodHeader header, HotRodServer server, Channel channel, Map<byte[], byte[]> entries) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        ExtendedByteBuf.writeUnsignedInt(entries.size(), buf);
        for (Map.Entry<byte[], byte[]> entry : entries.entrySet()) {
            ExtendedByteBuf.writeRangedBytes(entry.getKey(), buf);
            ExtendedByteBuf.writeRangedBytes(entry.getValue(), buf);
        }
        return buf;
    }

    @Override
    public ByteBuf bulkGetKeysResponse(HotRodHeader header, HotRodServer server, Channel channel, CloseableIterator<byte[]> iterator) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        while (iterator.hasNext()) {
            buf.writeByte(1);
            ExtendedByteBuf.writeRangedBytes((byte[])iterator.next(), buf);
        }
        buf.writeByte(0);
        return buf;
    }

    @Override
    public ByteBuf iterationStartResponse(HotRodHeader header, HotRodServer server, Channel channel, String iterationId) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        ExtendedByteBuf.writeString(iterationId, buf);
        return buf;
    }

    @Override
    public ByteBuf iterationNextResponse(HotRodHeader header, HotRodServer server, Channel channel, IterableIterationResult iterationResult) {
        ByteBuf buf = this.writeHeader(header, server, channel, iterationResult.getStatusCode());
        ExtendedByteBuf.writeRangedBytes(iterationResult.segmentsToBytes(), buf);
        List<CacheEntry> entries = iterationResult.getEntries();
        ExtendedByteBuf.writeUnsignedInt(entries.size(), buf);
        Optional<Integer> projectionLength = Encoder2x.projectionInfo(entries, header.version);
        projectionLength.ifPresent(i -> ExtendedByteBuf.writeUnsignedInt(i, buf));
        for (CacheEntry cacheEntry : entries) {
            if (HotRodVersion.HOTROD_25.isAtLeast(header.version)) {
                if (iterationResult.isMetadata()) {
                    buf.writeByte(1);
                    InternalCacheEntry ice = (InternalCacheEntry)cacheEntry;
                    int lifespan = ice.getLifespan() < 0L ? -1 : (int)(ice.getLifespan() / 1000L);
                    int maxIdle = ice.getMaxIdle() < 0L ? -1 : (int)(ice.getMaxIdle() / 1000L);
                    long lastUsed = ice.getLastUsed();
                    long created = ice.getCreated();
                    long dataVersion = MetadataUtils.extractVersion((CacheEntry)ice);
                    MetadataUtils.writeMetadata(lifespan, maxIdle, created, lastUsed, dataVersion, buf);
                } else {
                    buf.writeByte(0);
                }
            }
            Object key = iterationResult.getResultFunction().apply(cacheEntry.getKey());
            Object value = cacheEntry.getValue();
            ExtendedByteBuf.writeRangedBytes((byte[])key, buf);
            if (value instanceof Object[]) {
                for (Object o : (Object[])value) {
                    ExtendedByteBuf.writeRangedBytes((byte[])o, buf);
                }
                continue;
            }
            if (value instanceof byte[]) {
                ExtendedByteBuf.writeRangedBytes((byte[])value, buf);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type passed: " + value.getClass());
        }
        return buf;
    }

    @Override
    public ByteBuf counterConfigurationResponse(HotRodHeader header, HotRodServer server, Channel channel, CounterConfiguration configuration) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        EncodeUtil.encodeConfiguration((CounterConfiguration)configuration, arg_0 -> ((ByteBuf)buf).writeByte(arg_0), arg_0 -> ((ByteBuf)buf).writeLong(arg_0), value -> ExtendedByteBuf.writeUnsignedInt(value, buf));
        return buf;
    }

    @Override
    public ByteBuf counterNamesResponse(HotRodHeader header, HotRodServer server, Channel channel, Collection<String> counterNames) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        VInt.write((ByteBuf)buf, (int)counterNames.size());
        for (String s : counterNames) {
            ExtendedByteBuf.writeString(s, buf);
        }
        return buf;
    }

    @Override
    public ByteBuf multimapCollectionResponse(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status, Collection<byte[]> values) {
        ByteBuf buf = this.writeHeader(header, server, channel, status);
        ExtendedByteBuf.writeUnsignedInt(values.size(), buf);
        for (byte[] v : values) {
            ExtendedByteBuf.writeRangedBytes(v, buf);
        }
        return buf;
    }

    @Override
    public ByteBuf multimapEntryResponse(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status, CacheEntry<byte[], Collection<byte[]>> entry) {
        ByteBuf buf = this.writeHeader(header, server, channel, status);
        MetadataUtils.writeMetadata(MetadataUtils.extractLifespan(entry), MetadataUtils.extractMaxIdle(entry), MetadataUtils.extractCreated(entry), MetadataUtils.extractLastUsed(entry), MetadataUtils.extractVersion(entry), buf);
        Collection values = (Collection)entry.getValue();
        if (values == null) {
            buf.writeByte(0);
        } else {
            ExtendedByteBuf.writeUnsignedInt(values.size(), buf);
            for (byte[] v : values) {
                ExtendedByteBuf.writeRangedBytes(v, buf);
            }
        }
        return buf;
    }

    @Override
    public ByteBuf booleanResponse(HotRodHeader header, HotRodServer server, Channel channel, boolean result) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        buf.writeByte(result ? 1 : 0);
        return buf;
    }

    @Override
    public ByteBuf unsignedLongResponse(HotRodHeader header, HotRodServer server, Channel channel, long value) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        ExtendedByteBuf.writeUnsignedLong(value, buf);
        return buf;
    }

    @Override
    public ByteBuf longResponse(HotRodHeader header, HotRodServer server, Channel channel, long value) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        buf.writeLong(value);
        return buf;
    }

    @Override
    public ByteBuf transactionResponse(HotRodHeader header, HotRodServer server, Channel channel, int xaReturnCode) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        buf.writeInt(xaReturnCode);
        return buf;
    }

    @Override
    public ByteBuf recoveryResponse(HotRodHeader header, HotRodServer server, Channel channel, Collection<XidImpl> xids) {
        ByteBuf buf = this.writeHeader(header, server, channel, OperationStatus.Success);
        ExtendedByteBuf.writeUnsignedInt(xids.size(), buf);
        for (XidImpl xid : xids) {
            ExtendedByteBuf.writeXid(xid, buf);
        }
        return buf;
    }

    @Override
    public OperationStatus errorStatus(Throwable t) {
        if (t instanceof SuspectException) {
            return OperationStatus.NodeSuspected;
        }
        if (t instanceof IllegalLifecycleStateException) {
            return OperationStatus.IllegalLifecycleState;
        }
        if (t instanceof CacheException) {
            Throwable cause;
            Throwable throwable = cause = t.getCause() == null ? t : t.getCause();
            if (cause instanceof SuspectedException) {
                return OperationStatus.NodeSuspected;
            }
            if (cause instanceof IllegalLifecycleStateException) {
                return OperationStatus.IllegalLifecycleState;
            }
            if (cause instanceof InterruptedException) {
                return OperationStatus.IllegalLifecycleState;
            }
            return OperationStatus.ServerError;
        }
        if (t instanceof InterruptedException) {
            return OperationStatus.IllegalLifecycleState;
        }
        if (t instanceof PrivilegedActionException) {
            return this.errorStatus(t.getCause());
        }
        if (t instanceof SuspectedException) {
            return OperationStatus.NodeSuspected;
        }
        return OperationStatus.ServerError;
    }

    private ByteBuf writeHeader(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status) {
        return this.writeHeader(header, server, channel, status, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteBuf writeHeader(HotRodHeader header, HotRodServer server, Channel channel, OperationStatus status, boolean sendMediaType) {
        Optional<Object> newTopology;
        CacheTopology cacheTopology;
        ByteBuf buf = channel.alloc().ioBuffer();
        Cache<Address, ServerAddress> addressCache = HotRodVersion.forVersion(header.version) != HotRodVersion.UNKNOWN ? server.getAddressCache() : null;
        MediaType keyMediaType = null;
        MediaType valueMediaType = null;
        boolean objectStorage = false;
        if (header.op != HotRodOperation.ERROR) {
            if ("org.infinispan.COUNTER".equals(header.cacheName)) {
                cacheTopology = this.getCounterCacheTopology(server.getCacheManager());
                newTopology = this.getTopologyResponse(header.clientIntel, header.topologyId, addressCache, CacheMode.DIST_SYNC, cacheTopology);
            } else if (header.cacheName.isEmpty() && !server.hasDefaultCache()) {
                cacheTopology = null;
                newTopology = Optional.empty();
            } else {
                HotRodServer.ExtendedCacheInfo cacheInfo = server.getCacheInfo(header);
                Configuration configuration = cacheInfo.configuration;
                CacheMode cacheMode = configuration.clustering().cacheMode();
                cacheTopology = cacheMode.isClustered() ? cacheInfo.distributionManager.getCacheTopology() : null;
                newTopology = this.getTopologyResponse(header.clientIntel, header.topologyId, addressCache, cacheMode, cacheTopology);
                keyMediaType = configuration.encoding().keyDataType().mediaType();
                valueMediaType = configuration.encoding().valueDataType().mediaType();
                objectStorage = MediaType.APPLICATION_OBJECT.match(keyMediaType);
            }
        } else {
            cacheTopology = null;
            newTopology = Optional.empty();
        }
        buf.writeByte(161);
        ExtendedByteBuf.writeUnsignedLong(header.messageId, buf);
        buf.writeByte(header.op.getResponseOpCode());
        this.writeStatus(header, buf, server, objectStorage, status);
        if (newTopology.isPresent()) {
            AbstractTopologyResponse topology = (AbstractTopologyResponse)newTopology.get();
            if (topology instanceof TopologyAwareResponse) {
                this.writeTopologyUpdate((TopologyAwareResponse)topology, buf, ((InetSocketAddress)channel.localAddress()).getAddress());
                if (header.clientIntel == 3) {
                    this.writeEmptyHashInfo(topology, buf);
                }
            } else {
                if (!(topology instanceof HashDistAware20Response)) throw new IllegalArgumentException("Unsupported response: " + topology);
                this.writeHashTopologyUpdate((HashDistAware20Response)topology, cacheTopology, buf, ((InetSocketAddress)channel.localAddress()).getAddress());
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Write topology response header with no change");
            }
            buf.writeByte(0);
        }
        if (!sendMediaType || !HotRodVersion.HOTROD_29.isAtLeast(header.version)) return buf;
        this.writeMediaType(buf, keyMediaType);
        this.writeMediaType(buf, valueMediaType);
        return buf;
    }

    @Override
    public void writeCounterEvent(ClientCounterEvent event, ByteBuf buffer) {
        this.writeHeaderNoTopology(buffer, 0L, HotRodOperation.COUNTER_EVENT);
        event.writeTo(buffer);
    }

    private CacheTopology getCounterCacheTopology(EmbeddedCacheManager cacheManager) {
        AdvancedCache cache = cacheManager.getCache("org.infinispan.COUNTER").getAdvancedCache();
        return cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? cache.getComponentRegistry().getDistributionManager().getCacheTopology() : null;
    }

    private void writeHeaderNoTopology(ByteBuf buffer, long messageId, HotRodOperation operation) {
        buffer.writeByte(161);
        ExtendedByteBuf.writeUnsignedLong(messageId, buffer);
        buffer.writeByte(operation.getResponseOpCode());
        buffer.writeByte((int)OperationStatus.Success.getCode());
        buffer.writeByte(0);
    }

    private void writeStatus(HotRodHeader header, ByteBuf buf, HotRodServer server, boolean objStorage, OperationStatus status) {
        if (server == null || HotRodVersion.HOTROD_24.isOlder(header.version) || HotRodVersion.HOTROD_29.isAtLeast(header.version)) {
            buf.writeByte((int)status.getCode());
        } else {
            OperationStatus st = OperationStatus.withLegacyStorageHint(status, objStorage);
            buf.writeByte((int)st.getCode());
        }
    }

    private void writeMediaType(ByteBuf buf, MediaType mediaType) {
        if (mediaType == null) {
            buf.writeByte(0);
        } else {
            Short id = MediaTypeIds.getId((MediaType)mediaType);
            if (id != null) {
                buf.writeByte(1);
                VInt.write((ByteBuf)buf, (int)id.shortValue());
            } else {
                buf.writeByte(2);
                ExtendedByteBuf.writeString(mediaType.toString(), buf);
            }
            Map parameters = mediaType.getParameters();
            VInt.write((ByteBuf)buf, (int)parameters.size());
            parameters.forEach((key, value) -> {
                ExtendedByteBuf.writeString(key, buf);
                ExtendedByteBuf.writeString(value, buf);
            });
        }
    }

    private void writeTopologyUpdate(TopologyAwareResponse t, ByteBuf buffer, InetAddress localAddress) {
        Map topologyMap = t.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            log.noMembersInTopology();
            buffer.writeByte(0);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Write topology change response header %s", t);
            }
            buffer.writeByte(1);
            ExtendedByteBuf.writeUnsignedInt(t.topologyId, buffer);
            ExtendedByteBuf.writeUnsignedInt(topologyMap.size(), buffer);
            for (ServerAddress address : topologyMap.values()) {
                ExtendedByteBuf.writeString(address.getHost(localAddress), buffer);
                ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
            }
        }
    }

    private void writeEmptyHashInfo(AbstractTopologyResponse t, ByteBuf buffer) {
        if (log.isTraceEnabled()) {
            log.tracef("Return limited hash distribution aware header because the client %s doesn't ", t);
        }
        buffer.writeByte(0);
        ExtendedByteBuf.writeUnsignedInt(t.numSegments, buffer);
    }

    private void writeHashTopologyUpdate(HashDistAware20Response h, CacheTopology cacheTopology, ByteBuf buf, InetAddress localAddress) {
        ConsistentHash ch = cacheTopology.getReadConsistentHash();
        Map<Address, ServerAddress> members = h.serverEndpointsMap.entrySet().stream().filter(e -> ch.getMembers().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (log.isTraceEnabled()) {
            log.trace("Topology cache contains: " + h.serverEndpointsMap);
            log.trace("After read consistent hash filter, members are: " + members);
        }
        if (members.isEmpty()) {
            log.noMembersInHashTopology(ch, h.serverEndpointsMap.toString());
            buf.writeByte(0);
        } else {
            if (log.isTraceEnabled()) {
                log.tracef("Write hash distribution change response header %s", h);
            }
            buf.writeByte(1);
            ExtendedByteBuf.writeUnsignedInt(h.topologyId, buf);
            AtomicInteger indexCount = new AtomicInteger(-1);
            ExtendedByteBuf.writeUnsignedInt(members.size(), buf);
            HashMap indexedMembers = new HashMap();
            members.forEach((addr, serverAddr) -> {
                ExtendedByteBuf.writeString(serverAddr.getHost(localAddress), buf);
                ExtendedByteBuf.writeUnsignedShort(serverAddr.getPort(), buf);
                indexCount.incrementAndGet();
                indexedMembers.put(addr, indexCount.get());
            });
            int numSegments = ch.getNumSegments();
            buf.writeByte((int)h.hashFunction);
            ExtendedByteBuf.writeUnsignedInt(numSegments, buf);
            for (int segmentId = 0; segmentId < numSegments; ++segmentId) {
                List<Address> owners = ch.locateOwnersForSegment(segmentId).stream().filter(members::containsKey).collect(Collectors.toList());
                int ownersSize = owners.size();
                if (ownersSize == 0) {
                    buf.writeByte(1);
                    ExtendedByteBuf.writeUnsignedInt(0, buf);
                    continue;
                }
                buf.writeByte(ownersSize);
                owners.forEach(ownerAddr -> {
                    Integer index = (Integer)indexedMembers.get(ownerAddr);
                    if (index != null) {
                        ExtendedByteBuf.writeUnsignedInt(index, buf);
                    }
                });
            }
        }
    }

    private Optional<AbstractTopologyResponse> getTopologyResponse(short clientIntel, int topologyId, Cache<Address, ServerAddress> addressCache, CacheMode cacheMode, CacheTopology cacheTopology) {
        if (addressCache != null) {
            switch (clientIntel) {
                case 2: 
                case 3: {
                    int currentTopologyId;
                    if (!cacheMode.isClustered() || topologyId >= (currentTopologyId = cacheTopology.getTopologyId())) break;
                    return this.generateTopologyResponse(clientIntel, topologyId, addressCache, cacheMode, cacheTopology);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<AbstractTopologyResponse> generateTopologyResponse(short clientIntel, int responseTopologyId, Cache<Address, ServerAddress> addressCache, CacheMode cacheMode, CacheTopology cacheTopology) {
        int currentTopologyId = cacheTopology.getTopologyId();
        List cacheMembers = cacheTopology.getActualMembers();
        HashMap<Address, ServerAddress> serverEndpoints = new HashMap<Address, ServerAddress>();
        addressCache.forEach(serverEndpoints::put);
        int topologyId = currentTopologyId;
        if (log.isTraceEnabled()) {
            log.tracef("Check for partial topologies: members=%s, endpoints=%s, client-topology=%s, server-topology=%s", new Object[]{cacheMembers, cacheMembers, responseTopologyId, topologyId});
        }
        if (!serverEndpoints.keySet().containsAll(cacheMembers)) {
            if (currentTopologyId - responseTopologyId < 2) {
                if (log.isTraceEnabled()) {
                    log.trace("Postpone topology update");
                }
                return Optional.empty();
            }
            --topologyId;
            if (log.isTraceEnabled()) {
                log.tracef("Send partial topology update with topology id %s", topologyId);
            }
        }
        if (clientIntel == 3 && !cacheMode.isInvalidation()) {
            int numSegments = cacheTopology.getReadConsistentHash().getNumSegments();
            return Optional.of(new HashDistAware20Response(topologyId, serverEndpoints, numSegments, 3));
        }
        return Optional.of(new TopologyAwareResponse(topologyId, serverEndpoints, 0));
    }

    private static Optional<Integer> projectionInfo(List<CacheEntry> entries, byte version) {
        if (!entries.isEmpty()) {
            CacheEntry entry = entries.get(0);
            if (entry.getValue() instanceof Object[]) {
                return Optional.of(((Object[])entry.getValue()).length);
            }
            if (HotRodVersion.HOTROD_24.isAtLeast(version)) {
                return Optional.of(1);
            }
        }
        return Optional.empty();
    }
}

