/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap;

import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.BootstrapUtils;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ProcessedSources;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public class IDELauncherImpl
implements Closeable {
    public static final String FORCE_COLOR_SUPPORT = "io.quarkus.force-color-support";
    private final CuratedApplication curatedApp;
    private final Closeable runningApp;

    public static Closeable launch(Path classesDir, Map<String, Object> context) {
        System.setProperty(FORCE_COLOR_SUPPORT, "true");
        System.setProperty("quarkus.test.basic-console", "true");
        Path projectDir = BuildToolHelper.getProjectDir(classesDir);
        if (projectDir == null) {
            throw new IllegalStateException("Failed to locate project dir for " + classesDir);
        }
        try {
            QuarkusBootstrap.Builder builder = QuarkusBootstrap.builder().setBaseClassLoader(IDELauncherImpl.class.getClassLoader()).setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.DEV).setTargetDirectory(classesDir.getParent());
            if (BuildToolHelper.isGradleProject(classesDir)) {
                ApplicationModel quarkusModel = BuildToolHelper.enableGradleAppModelForDevMode(classesDir);
                context.put("quarkus-internal.serialized-app-model.path", BootstrapUtils.serializeAppModel((ApplicationModel)quarkusModel, (boolean)false));
                Path launchingModulePath = ((ProcessedSources)quarkusModel.getApplicationModule().getMainSources().iterator().next()).getDestinationDir().toPath();
                builder.setProjectRoot(launchingModulePath).setApplicationRoot(launchingModulePath).setTargetDirectory(quarkusModel.getApplicationModule().getBuildDir().toPath());
                for (WorkspaceModule additionalModule : quarkusModel.getWorkspaceModules()) {
                    additionalModule.getMainSources().forEach(src -> builder.addAdditionalApplicationArchive(new AdditionalDependency(src.getDestinationDir().toPath(), true, false)));
                    additionalModule.getMainResources().forEach(src -> builder.addAdditionalApplicationArchive(new AdditionalDependency(src.getDestinationDir().toPath(), true, false)));
                }
            } else {
                builder.setApplicationRoot(classesDir).setProjectRoot(projectDir);
                BootstrapMavenContext mvnCtx = new BootstrapMavenContext(BootstrapMavenContext.config().setCurrentProject(projectDir.toString()));
                MavenArtifactResolver mvnResolver = new MavenArtifactResolver(mvnCtx);
                builder.setMavenArtifactResolver(mvnResolver);
            }
            CuratedApplication curatedApp = builder.build().bootstrap();
            Object appInstance = curatedApp.runInAugmentClassLoader("io.quarkus.deployment.dev.IDEDevModeMain", context);
            return new IDELauncherImpl(curatedApp, appInstance == null ? null : (appInstance instanceof Closeable ? (Closeable)appInstance : null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IDELauncherImpl(CuratedApplication curatedApp, Closeable runningApp) {
        this.curatedApp = curatedApp;
        this.runningApp = runningApp;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.runningApp != null) {
                this.runningApp.close();
            }
        }
        finally {
            if (this.curatedApp != null) {
                this.curatedApp.close();
            }
        }
    }
}

