/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.ws.rs.core.MediaType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.SseUtil;
import org.jboss.resteasy.reactive.server.core.StreamingUtil;
import org.jboss.resteasy.reactive.server.jaxrs.OutboundSseEventImpl;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.StreamingResponse;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class PublisherResponseHandler
implements ServerRestHandler {
    private List<StreamingResponseCustomizer> streamingResponseCustomizers = Collections.emptyList();
    private static final Logger log = Logger.getLogger(PublisherResponseHandler.class);
    private static final ServerRestHandler[] AWOL = new ServerRestHandler[]{new ServerRestHandler(){

        @Override
        public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
            throw new IllegalStateException("FAILURE: should never be restarted");
        }
    }};

    public void setStreamingResponseCustomizers(List<StreamingResponseCustomizer> streamingResponseCustomizers) {
        this.streamingResponseCustomizers = streamingResponseCustomizers;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (requestContext.getResult() instanceof Publisher) {
            Publisher result = (Publisher)requestContext.getResult();
            MediaType[] mediaTypes = requestContext.getTarget().getProduces().getSortedMediaTypes();
            if (mediaTypes.length != 1) {
                throw new IllegalStateException("Negotiation or dynamic media type not supported yet for Multi: please use a single @Produces annotation");
            }
            requestContext.setResponseContentType(mediaTypes[0]);
            requestContext.setGenericReturnType(requestContext.getTarget().getReturnType());
            requestContext.suspend();
            if (mediaTypes[0].isCompatible(MediaType.SERVER_SENT_EVENTS_TYPE)) {
                this.handleSse(requestContext, result);
            } else {
                boolean json = mediaTypes[0].isCompatible(MediaType.APPLICATION_JSON_TYPE);
                this.handleStreaming(requestContext, result, json);
            }
        }
    }

    private void handleStreaming(ResteasyReactiveRequestContext requestContext, Publisher<?> result, boolean json) {
        result.subscribe((Subscriber)new StreamingMultiSubscriber(requestContext, this.streamingResponseCustomizers, json));
    }

    private void handleSse(ResteasyReactiveRequestContext requestContext, Publisher<?> result) {
        result.subscribe((Subscriber)new SseMultiSubscriber(requestContext, this.streamingResponseCustomizers));
    }

    public static interface StreamingResponseCustomizer {
        public void customize(StreamingResponse<?> var1);

        public static class AddHeadersCustomizer
        implements StreamingResponseCustomizer {
            private Map<String, List<String>> headers;

            public AddHeadersCustomizer(Map<String, List<String>> headers) {
                this.headers = headers;
            }

            public AddHeadersCustomizer() {
            }

            public Map<String, List<String>> getHeaders() {
                return this.headers;
            }

            public void setHeaders(Map<String, List<String>> headers) {
                this.headers = headers;
            }

            @Override
            public void customize(StreamingResponse<?> streamingResponse) {
                for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
                    streamingResponse.setResponseHeader((CharSequence)entry.getKey(), (Iterable<CharSequence>)entry.getValue());
                }
            }
        }

        public static class StatusCustomizer
        implements StreamingResponseCustomizer {
            private int status;

            public StatusCustomizer(int status) {
                this.status = status;
            }

            public StatusCustomizer() {
            }

            public int getStatus() {
                return this.status;
            }

            public void setStatus(int status) {
                this.status = status;
            }

            @Override
            public void customize(StreamingResponse<?> streamingResponse) {
                streamingResponse.setStatusCode(this.status);
            }
        }
    }

    static abstract class AbstractMultiSubscriber
    implements Subscriber<Object> {
        protected Subscription subscription;
        protected ResteasyReactiveRequestContext requestContext;
        protected List<StreamingResponseCustomizer> customizers;
        private boolean weClosed = false;

        AbstractMultiSubscriber(ResteasyReactiveRequestContext requestContext, List<StreamingResponseCustomizer> customizers) {
            this.requestContext = requestContext;
            this.customizers = customizers;
            requestContext.restart(AWOL, true);
            requestContext.serverResponse().addCloseHandler(() -> {
                if (!this.weClosed && this.subscription != null) {
                    this.subscription.cancel();
                }
            });
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            s.request(1L);
        }

        public void onComplete() {
            this.weClosed = true;
            this.requestContext.serverResponse().end();
            this.requestContext.close();
        }

        public void onError(Throwable t) {
            this.handleException(this.requestContext, t);
        }

        protected void handleException(ResteasyReactiveRequestContext requestContext, Throwable t) {
            if (requestContext.serverResponse().headWritten()) {
                log.error((Object)"Exception in SSE server handling, impossible to send it to client", t);
            } else {
                requestContext.resume(t, true);
            }
        }
    }

    private static class StreamingMultiSubscriber
    extends AbstractMultiSubscriber {
        private boolean json;
        private String nextJsonPrefix;
        private boolean hadItem;

        StreamingMultiSubscriber(ResteasyReactiveRequestContext requestContext, List<StreamingResponseCustomizer> customizers, boolean json) {
            super(requestContext, customizers);
            this.json = json;
            this.nextJsonPrefix = "[";
            this.hadItem = false;
        }

        public void onNext(Object item) {
            this.hadItem = true;
            StreamingUtil.send(this.requestContext, this.customizers, item, this.json ? this.nextJsonPrefix : null).handle(new BiFunction<Object, Throwable, Object>(){

                @Override
                public Object apply(Object v, Throwable t) {
                    if (t != null) {
                        try {
                            subscription.cancel();
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                        }
                        this.handleException(requestContext, t);
                    } else {
                        nextJsonPrefix = ",";
                        subscription.request(1L);
                    }
                    return null;
                }
            });
        }

        @Override
        public void onComplete() {
            if (!this.hadItem) {
                StreamingUtil.setHeaders(this.requestContext, this.requestContext.serverResponse(), this.customizers);
            }
            if (this.json) {
                String postfix = !this.hadItem ? "[]" : "]";
                byte[] postfixBytes = postfix.getBytes(StandardCharsets.US_ASCII);
                this.requestContext.serverResponse().write(postfixBytes).handle((v, t) -> {
                    super.onComplete();
                    return null;
                });
            } else {
                super.onComplete();
            }
        }
    }

    private static class SseMultiSubscriber
    extends AbstractMultiSubscriber {
        SseMultiSubscriber(ResteasyReactiveRequestContext requestContext, List<StreamingResponseCustomizer> customizers) {
            super(requestContext, customizers);
        }

        public void onNext(Object item) {
            OutboundSseEventImpl event = new OutboundSseEventImpl.BuilderImpl().data(item).build();
            SseUtil.send(this.requestContext, event, this.customizers).handle(new BiFunction<Object, Throwable, Object>(){

                @Override
                public Object apply(Object v, Throwable t) {
                    if (t != null) {
                        subscription.cancel();
                        this.handleException(requestContext, t);
                    } else {
                        subscription.request(1L);
                    }
                    return null;
                }
            });
        }
    }
}

