/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PolicyEvaluationService;
import org.keycloak.authorization.admin.PolicyResourceService;
import org.keycloak.authorization.admin.PolicyTypeService;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyProviderRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.util.JsonSerialization;

public class PolicyService {
    protected final ResourceServer resourceServer;
    protected final AuthorizationProvider authorization;
    protected final AdminPermissionEvaluator auth;
    protected final AdminEventBuilder adminEvent;

    public PolicyService(ResourceServer resourceServer, AuthorizationProvider authorization, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.AUTHORIZATION_POLICY);
    }

    @Path(value="{type}")
    public Object getResource(@PathParam(value="type") String type) {
        PolicyProviderFactory providerFactory = this.getPolicyProviderFactory(type);
        if (providerFactory != null) {
            return this.doCreatePolicyTypeResource(type);
        }
        Policy policy = this.authorization.getStoreFactory().getPolicyStore().findById(type, this.resourceServer.getId());
        return this.doCreatePolicyResource(policy);
    }

    protected PolicyTypeService doCreatePolicyTypeResource(String type) {
        return new PolicyTypeService(type, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    protected Object doCreatePolicyResource(Policy policy) {
        return new PolicyResourceService(policy, this.resourceServer, this.authorization, this.auth, this.adminEvent);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response create(String payload, @Context KeycloakSession session) {
        if (this.auth != null) {
            this.auth.realm().requireManageAuthorization();
        }
        AbstractPolicyRepresentation representation = this.doCreateRepresentation(payload);
        Policy policy = this.create(representation);
        representation.setId(policy.getId());
        this.audit(representation, representation.getId(), OperationType.CREATE, session);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)representation).build();
    }

    protected AbstractPolicyRepresentation doCreateRepresentation(String payload) {
        PolicyRepresentation representation;
        try {
            representation = (PolicyRepresentation)JsonSerialization.readValue((String)payload, PolicyRepresentation.class);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize representation", cause);
        }
        return representation;
    }

    public Policy create(AbstractPolicyRepresentation representation) {
        PolicyStore policyStore = this.authorization.getStoreFactory().getPolicyStore();
        Policy existing = policyStore.findByName(representation.getName(), this.resourceServer.getId());
        if (existing != null) {
            throw new ErrorResponseException("Policy with name [" + representation.getName() + "] already exists", "Conflicting policy", Response.Status.CONFLICT);
        }
        return policyStore.create(representation, this.resourceServer);
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findByName(@QueryParam(value="name") String name, @QueryParam(value="fields") String fields) {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Policy model = storeFactory.getPolicyStore().findByName(name, this.resourceServer.getId());
        if (model == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)this.toRepresentation(model, fields, this.authorization)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findAll(@QueryParam(value="policyId") String id, @QueryParam(value="name") String name, @QueryParam(value="type") String type, @QueryParam(value="resource") String resource, @QueryParam(value="scope") String scope, @QueryParam(value="permission") Boolean permission, @QueryParam(value="owner") String owner, @QueryParam(value="fields") String fields, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        HashMap<String, String[]> search = new HashMap<String, String[]>();
        if (id != null && !"".equals(id.trim())) {
            search.put("id", new String[]{id});
        }
        if (name != null && !"".equals(name.trim())) {
            search.put("name", new String[]{name});
        }
        if (type != null && !"".equals(type.trim())) {
            search.put("type", new String[]{type});
        }
        if (owner != null && !"".equals(owner.trim())) {
            search.put("owner", new String[]{owner});
        }
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (resource != null && !"".equals(resource.trim())) {
            ResourceStore resourceStore = storeFactory.getResourceStore();
            Resource resourceModel = resourceStore.findById(resource, this.resourceServer.getId());
            if (resourceModel == null) {
                Set<String> resources;
                HashMap<String, String[]> resourceFilters = new HashMap<String, String[]>();
                resourceFilters.put("name", new String[]{resource});
                if (owner != null) {
                    resourceFilters.put("owner", new String[]{owner});
                }
                if ((resources = resourceStore.findByResourceServer(resourceFilters, this.resourceServer.getId(), -1, 1).stream().map(Resource::getId).collect(Collectors.toSet())).isEmpty()) {
                    return Response.noContent().build();
                }
                search.put("resource", resources.toArray(new String[resources.size()]));
            } else {
                search.put("resource", new String[]{resourceModel.getId()});
            }
        }
        if (scope != null && !"".equals(scope.trim())) {
            ScopeStore scopeStore = storeFactory.getScopeStore();
            Scope scopeModel = scopeStore.findById(scope, this.resourceServer.getId());
            if (scopeModel == null) {
                HashMap<String, String[]> scopeFilters = new HashMap<String, String[]>();
                scopeFilters.put("name", new String[]{scope});
                Set<String> scopes = scopeStore.findByResourceServer(scopeFilters, this.resourceServer.getId(), -1, 1).stream().map(Scope::getId).collect(Collectors.toSet());
                if (scopes.isEmpty()) {
                    return Response.noContent().build();
                }
                search.put("scope", scopes.toArray(new String[scopes.size()]));
            } else {
                search.put("scope", new String[]{scopeModel.getId()});
            }
        }
        if (permission != null) {
            search.put("permission", new String[]{permission.toString()});
        }
        return Response.ok(this.doSearch(firstResult, maxResult, fields, search)).build();
    }

    protected AbstractPolicyRepresentation toRepresentation(Policy model, String fields, AuthorizationProvider authorization) {
        return ModelToRepresentation.toRepresentation((Policy)model, (AuthorizationProvider)authorization, (boolean)true, (boolean)false, (fields != null && fields.equals("*") ? 1 : 0) != 0);
    }

    protected List<Object> doSearch(Integer firstResult, Integer maxResult, String fields, Map<String, String[]> filters) {
        PolicyStore policyStore = this.authorization.getStoreFactory().getPolicyStore();
        return policyStore.findByResourceServer(filters, this.resourceServer.getId(), firstResult != null ? firstResult : -1, maxResult != null ? maxResult : 100).stream().map(policy -> this.toRepresentation((Policy)policy, fields, this.authorization)).collect(Collectors.toList());
    }

    @Path(value="providers")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response findPolicyProviders() {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        return Response.ok(this.authorization.getProviderFactories().stream().filter(factory -> !factory.isInternal()).map(factory -> {
            PolicyProviderRepresentation representation = new PolicyProviderRepresentation();
            representation.setName(factory.getName());
            representation.setGroup(factory.getGroup());
            representation.setType(factory.getId());
            return representation;
        }).collect(Collectors.toList())).build();
    }

    @Path(value="evaluate")
    public PolicyEvaluationService getPolicyEvaluateResource() {
        if (this.auth != null) {
            this.auth.realm().requireViewAuthorization();
        }
        PolicyEvaluationService resource = new PolicyEvaluationService(this.resourceServer, this.authorization, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    protected PolicyProviderAdminService getPolicyProviderAdminResource(String policyType) {
        return this.getPolicyProviderFactory(policyType).getAdminResource(this.resourceServer, this.authorization);
    }

    protected PolicyProviderFactory getPolicyProviderFactory(String policyType) {
        return this.authorization.getProviderFactory(policyType);
    }

    private void audit(AbstractPolicyRepresentation resource, String id, OperationType operation, KeycloakSession session) {
        if (id != null) {
            this.adminEvent.operation(operation).resourcePath((UriInfo)session.getContext().getUri(), id).representation(resource).success();
        } else {
            this.adminEvent.operation(operation).resourcePath((UriInfo)session.getContext().getUri()).representation(resource).success();
        }
    }
}

