/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.keycloak.Config;
import org.keycloak.common.Version;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.DefaultKeyProviders;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.RealmManager;

public class ApplianceBootstrap {
    private final KeycloakSession session;

    public ApplianceBootstrap(KeycloakSession session) {
        this.session = session;
    }

    public boolean isNewInstall() {
        return this.session.realms().getRealm(Config.getAdminRealm()) == null;
    }

    public boolean isNoMasterUser() {
        RealmModel realm = this.session.realms().getRealm(Config.getAdminRealm());
        return this.session.users().getUsersCount(realm) == 0;
    }

    public boolean createMasterRealm() {
        if (!this.isNewInstall()) {
            throw new IllegalStateException("Can't create default realm as realms already exists");
        }
        String adminRealmName = Config.getAdminRealm();
        ServicesLogger.LOGGER.initializingAdminRealm(adminRealmName);
        RealmManager manager = new RealmManager(this.session);
        RealmModel realm = manager.createRealm(adminRealmName, adminRealmName);
        realm.setName(adminRealmName);
        realm.setDisplayName(Version.NAME);
        realm.setDisplayNameHtml(Version.NAME_HTML);
        realm.setEnabled(true);
        realm.addRequiredCredential("password");
        realm.setSsoSessionIdleTimeout(1800);
        realm.setAccessTokenLifespan(60);
        realm.setAccessTokenLifespanForImplicitFlow(900);
        realm.setSsoSessionMaxLifespan(36000);
        realm.setOfflineSessionIdleTimeout(2592000);
        realm.setOfflineSessionMaxLifespanEnabled(false);
        realm.setOfflineSessionMaxLifespan(5184000);
        realm.setAccessCodeLifespan(60);
        realm.setAccessCodeLifespanUserAction(300);
        realm.setAccessCodeLifespanLogin(1800);
        realm.setSslRequired(SslRequired.EXTERNAL);
        realm.setRegistrationAllowed(false);
        realm.setRegistrationEmailAsUsername(false);
        this.session.getContext().setRealm(realm);
        DefaultKeyProviders.createProviders((RealmModel)realm);
        return true;
    }

    public void createMasterRealmUser(String username, String password) {
        RealmModel realm = this.session.realms().getRealm(Config.getAdminRealm());
        this.session.getContext().setRealm(realm);
        if (this.session.users().getUsersCount(realm) > 0) {
            throw new IllegalStateException("Can't create initial user as users already exists");
        }
        UserModel adminUser = this.session.users().addUser(realm, username);
        adminUser.setEnabled(true);
        PasswordUserCredentialModel usrCredModel = UserCredentialModel.password((String)password);
        this.session.userCredentialManager().updateCredential(realm, adminUser, (CredentialInput)usrCredModel);
        RoleModel adminRole = realm.getRole(AdminRoles.ADMIN);
        adminUser.grantRole(adminRole);
    }
}

