/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.util.Models;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.RealmAuth;

public class ResourceSetService {
    private final AuthorizationProvider authorization;
    private final RealmAuth auth;
    private ResourceServer resourceServer;

    public ResourceSetService(ResourceServer resourceServer, AuthorizationProvider authorization, RealmAuth auth) {
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(ResourceRepresentation resource) {
        this.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource existingResource = storeFactory.getResourceStore().findByName(resource.getName(), this.resourceServer.getId());
        if (existingResource != null && existingResource.getResourceServer().getId().equals(this.resourceServer.getId()) && existingResource.getOwner().equals(resource.getOwner())) {
            return ErrorResponse.exists("Resource with name [" + resource.getName() + "] already exists.");
        }
        Resource model = Models.toModel(resource, this.resourceServer, this.authorization);
        ResourceRepresentation representation = new ResourceRepresentation();
        representation.setId(model.getId());
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)representation).build();
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="id") String id, ResourceRepresentation resource) {
        this.requireManage();
        resource.setId(id);
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        ResourceStore resourceStore = storeFactory.getResourceStore();
        Resource model = resourceStore.findById(resource.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        model.setName(resource.getName());
        model.setType(resource.getType());
        model.setUri(resource.getUri());
        model.setIconUri(resource.getIconUri());
        model.updateScopes(resource.getScopes().stream().map(scope -> Models.toModel(scope, this.resourceServer, this.authorization)).collect(Collectors.toSet()));
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id) {
        this.requireManage();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource resource = storeFactory.getResourceStore().findById(id);
        if (resource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List policies = policyStore.findByResource(id);
        for (Policy policyModel : policies) {
            if (policyModel.getResources().size() == 1) {
                policyStore.delete(policyModel.getId());
                continue;
            }
            policyModel.addResource(resource);
        }
        storeFactory.getResourceStore().delete(id);
        return Response.noContent().build();
    }

    @Path(value="{id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        Resource model = storeFactory.getResourceStore().findById(id);
        if (model == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)Models.toRepresentation(model, this.resourceServer, this.authorization)).build();
    }

    @Path(value="/search")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response find(@QueryParam(value="name") String name) {
        this.auth.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        if (name == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Resource model = storeFactory.getResourceStore().findByName(name, this.resourceServer.getId());
        if (model == null) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        return Response.ok((Object)Models.toRepresentation(model, this.resourceServer, this.authorization)).build();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response findAll() {
        this.requireView();
        StoreFactory storeFactory = this.authorization.getStoreFactory();
        return Response.ok(storeFactory.getResourceStore().findByResourceServer(this.resourceServer.getId()).stream().map(resource -> Models.toRepresentation(resource, this.resourceServer, this.authorization)).collect(Collectors.toList())).build();
    }

    private void requireView() {
        if (this.auth != null) {
            this.auth.requireView();
        }
    }

    private void requireManage() {
        if (this.auth != null) {
            this.auth.requireManage();
        }
    }
}

