/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.oidc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.services.clientregistration.ClientRegistrationException;

public class DescriptionConverter {
    public static ClientRepresentation toInternal(OIDCClientRepresentation clientOIDC) throws ClientRegistrationException {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(clientOIDC.getClientId());
        client.setName(clientOIDC.getClientName());
        client.setRedirectUris(clientOIDC.getRedirectUris());
        client.setBaseUrl(clientOIDC.getClientUri());
        List<String> oidcResponseTypes = clientOIDC.getResponseTypes();
        if (oidcResponseTypes == null || oidcResponseTypes.isEmpty()) {
            oidcResponseTypes = Collections.singletonList("code");
        }
        List oidcGrantTypes = clientOIDC.getGrantTypes();
        try {
            OIDCResponseType responseType = OIDCResponseType.parse(oidcResponseTypes);
            client.setStandardFlowEnabled(Boolean.valueOf(responseType.hasResponseType("code")));
            client.setImplicitFlowEnabled(Boolean.valueOf(responseType.isImplicitOrHybridFlow()));
            if (oidcGrantTypes != null) {
                client.setDirectAccessGrantsEnabled(Boolean.valueOf(oidcGrantTypes.contains("password")));
                client.setServiceAccountsEnabled(Boolean.valueOf(oidcGrantTypes.contains("client_credentials")));
            }
        }
        catch (IllegalArgumentException iae) {
            throw new ClientRegistrationException(iae.getMessage(), iae);
        }
        return client;
    }

    public static OIDCClientRepresentation toExternalResponse(ClientRepresentation client, URI uri) {
        OIDCClientRepresentation response = new OIDCClientRepresentation();
        response.setClientId(client.getClientId());
        response.setClientName(client.getName());
        response.setClientUri(client.getBaseUrl());
        response.setClientSecret(client.getSecret());
        response.setRedirectUris(client.getRedirectUris());
        response.setRegistrationAccessToken(client.getRegistrationAccessToken());
        response.setRegistrationClientUri(uri.toString());
        response.setResponseTypes(DescriptionConverter.getOIDCResponseTypes(client));
        response.setGrantTypes(DescriptionConverter.getOIDCGrantTypes(client));
        return response;
    }

    private static List<String> getOIDCResponseTypes(ClientRepresentation client) {
        ArrayList<String> responseTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            responseTypes.add("code");
            responseTypes.add("none");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("id_token");
            responseTypes.add("id_token token");
        }
        if (client.isStandardFlowEnabled().booleanValue() && client.isImplicitFlowEnabled().booleanValue()) {
            responseTypes.add("code id_token");
            responseTypes.add("code token");
            responseTypes.add("code id_token token");
        }
        return responseTypes;
    }

    private static List<String> getOIDCGrantTypes(ClientRepresentation client) {
        ArrayList<String> grantTypes = new ArrayList<String>();
        if (client.isStandardFlowEnabled().booleanValue()) {
            grantTypes.add("authorization_code");
        }
        if (client.isImplicitFlowEnabled().booleanValue()) {
            grantTypes.add("implicit");
        }
        if (client.isDirectAccessGrantsEnabled().booleanValue()) {
            grantTypes.add("password");
        }
        if (client.isServiceAccountsEnabled().booleanValue()) {
            grantTypes.add("client_credentials");
        }
        grantTypes.add("refresh_token");
        return grantTypes;
    }
}

