/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClientInitialAccessResource {
    private final RealmAuth auth;
    private final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    @Context
    protected KeycloakSession session;
    @Context
    protected UriInfo uriInfo;

    public ClientInitialAccessResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ClientInitialAccessPresentation create(ClientInitialAccessCreatePresentation config, @Context HttpServletResponse response) {
        this.auth.requireManage();
        int expiration = config.getExpiration() != null ? config.getExpiration() : 0;
        int count = config.getCount() != null ? config.getCount() : 1;
        ClientInitialAccessModel clientInitialAccessModel = this.session.sessions().createClientInitialAccessModel(this.realm, expiration, count);
        this.adminEvent.operation(OperationType.CREATE).resourcePath(this.uriInfo, clientInitialAccessModel.getId()).representation(config).success();
        if (this.session.getTransactionManager().isActive()) {
            this.session.getTransactionManager().commit();
        }
        ClientInitialAccessPresentation rep = this.wrap(clientInitialAccessModel);
        String token = ClientRegistrationTokenUtils.createInitialAccessToken(this.realm, this.uriInfo, clientInitialAccessModel);
        rep.setToken(token);
        response.setStatus(Response.Status.CREATED.getStatusCode());
        response.setHeader("Location", this.uriInfo.getAbsolutePathBuilder().path(clientInitialAccessModel.getId()).build(new Object[0]).toString());
        return rep;
    }

    @GET
    @Produces(value={"application/json"})
    public List<ClientInitialAccessPresentation> list() {
        this.auth.requireView();
        List models = this.session.sessions().listClientInitialAccess(this.realm);
        LinkedList<ClientInitialAccessPresentation> reps = new LinkedList<ClientInitialAccessPresentation>();
        for (ClientInitialAccessModel m : models) {
            ClientInitialAccessPresentation r = this.wrap(m);
            reps.add(r);
        }
        return reps;
    }

    @DELETE
    @Path(value="{id}")
    public void delete(@PathParam(value="id") String id) {
        this.auth.requireManage();
        this.session.sessions().removeClientInitialAccessModel(this.realm, id);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    private ClientInitialAccessPresentation wrap(ClientInitialAccessModel model) {
        ClientInitialAccessPresentation rep = new ClientInitialAccessPresentation();
        rep.setId(model.getId());
        rep.setTimestamp(Integer.valueOf(model.getTimestamp()));
        rep.setExpiration(Integer.valueOf(model.getExpiration()));
        rep.setCount(Integer.valueOf(model.getCount()));
        rep.setRemainingCount(Integer.valueOf(model.getRemainingCount()));
        return rep;
    }
}

