/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.broker;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.broker.AbstractIdpAuthenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.authentication.requiredactions.VerifyEmail;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.email.EmailException;
import org.keycloak.email.EmailTemplateProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.LoginActionsService;

public class IdpEmailVerificationAuthenticator
extends AbstractIdpAuthenticator {
    protected static ServicesLogger logger = ServicesLogger.ROOT_LOGGER;

    @Override
    protected void authenticateImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        KeycloakSession session = context.getSession();
        RealmModel realm = context.getRealm();
        ClientSessionModel clientSession = context.getClientSession();
        if (realm.getSmtpConfig().size() == 0) {
            logger.smtpNotConfigured();
            context.attempted();
            return;
        }
        LoginActionsService.createActionCookie(context.getRealm(), context.getUriInfo(), context.getConnection(), context.getClientSession().getId());
        VerifyEmail.setupKey(clientSession);
        UserModel existingUser = IdpEmailVerificationAuthenticator.getExistingUser(session, realm, clientSession);
        String link = UriBuilder.fromUri((URI)context.getActionUrl()).queryParam("key", new Object[]{clientSession.getNote("VERIFY_EMAIL_KEY")}).build(new Object[0]).toString();
        EventBuilder event = context.getEvent().clone().event(EventType.SEND_IDENTITY_PROVIDER_LINK).user(existingUser).detail("username", existingUser.getUsername()).detail("email", existingUser.getEmail()).detail("code_id", clientSession.getId()).removeDetail("auth_method").removeDetail("auth_type");
        long expiration = TimeUnit.SECONDS.toMinutes(context.getRealm().getAccessCodeLifespanUserAction());
        try {
            ((EmailTemplateProvider)context.getSession().getProvider(EmailTemplateProvider.class)).setRealm(realm).setUser(existingUser).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).sendConfirmIdentityBrokerLink(link, expiration);
            event.success();
        }
        catch (EmailException e) {
            event.error("email_send_failed");
            logger.confirmBrokerEmailFailed(e);
            Response challenge = context.form().setError("emailSendErrorMessage", new Object[0]).createErrorPage();
            context.failure(AuthenticationFlowError.INTERNAL_ERROR, challenge);
            return;
        }
        Response challenge = context.form().setStatus(Response.Status.OK).setAttribute("identityProviderBrokerCtx", (Object)brokerContext).createIdpLinkEmailPage();
        context.forceChallenge(challenge);
    }

    @Override
    protected void actionImpl(AuthenticationFlowContext context, SerializedBrokeredIdentityContext serializedCtx, BrokeredIdentityContext brokerContext) {
        MultivaluedMap queryParams = context.getSession().getContext().getUri().getQueryParameters();
        String key = (String)queryParams.getFirst((Object)"key");
        ClientSessionModel clientSession = context.getClientSession();
        RealmModel realm = context.getRealm();
        KeycloakSession session = context.getSession();
        if (key != null) {
            String keyFromSession = clientSession.getNote("VERIFY_EMAIL_KEY");
            clientSession.removeNote("VERIFY_EMAIL_KEY");
            if (key.equals(keyFromSession)) {
                UserModel existingUser = IdpEmailVerificationAuthenticator.getExistingUser(session, realm, clientSession);
                logger.debugf("User '%s' confirmed that wants to link with identity provider '%s' . Identity provider username is '%s' ", existingUser.getUsername(), brokerContext.getIdpConfig().getAlias(), brokerContext.getUsername());
                String actionCookieValue = LoginActionsService.getActionCookie(session.getContext().getRequestHeaders(), realm, session.getContext().getUri(), context.getConnection());
                if (actionCookieValue == null || !actionCookieValue.equals(clientSession.getId())) {
                    clientSession.setNote("IS_DIFFERENT_BROWSER", "true");
                }
                context.setUser(existingUser);
                context.success();
            } else {
                logger.keyParamDoesNotMatch();
                Response challengeResponse = context.form().setError("invalidAccessCodeMessage", new Object[0]).createErrorPage();
                context.failureChallenge(AuthenticationFlowError.IDENTITY_PROVIDER_ERROR, challengeResponse);
            }
        } else {
            Response challengeResponse = context.form().setError("missingParameterMessage", new Object[]{"key"}).createErrorPage();
            context.failureChallenge(AuthenticationFlowError.IDENTITY_PROVIDER_ERROR, challengeResponse);
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return false;
    }
}

