/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints.request;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.services.util.CertificateInfoHelper;
import org.keycloak.util.JsonSerialization;

class AuthzEndpointRequestObjectParser
extends AuthzEndpointRequestParser {
    private final Map<String, Object> requestParams;

    public AuthzEndpointRequestObjectParser(String requestObject, ClientModel client) throws Exception {
        JWSInput input = new JWSInput(requestObject);
        JWSHeader header = input.getHeader();
        Algorithm requestedSignatureAlgorithm = OIDCAdvancedConfigWrapper.fromClientModel(client).getRequestObjectSignatureAlg();
        if (requestedSignatureAlgorithm != null && requestedSignatureAlgorithm != header.getAlgorithm()) {
            throw new RuntimeException("Request object signed with different algorithm than client requested algorithm");
        }
        if (header.getAlgorithm() == Algorithm.none) {
            this.requestParams = (Map)JsonSerialization.readValue((byte[])input.getContent(), TypedHashMap.class);
        } else if (header.getAlgorithm() == Algorithm.RS256) {
            PublicKey clientPublicKey = CertificateInfoHelper.getSignatureValidationKey(client, "jwt.credential");
            boolean verified = RSAProvider.verify((JWSInput)input, (PublicKey)clientPublicKey);
            if (!verified) {
                throw new RuntimeException("Failed to verify signature on 'request' object");
            }
            this.requestParams = (Map)JsonSerialization.readValue((byte[])input.getContent(), TypedHashMap.class);
        } else {
            throw new RuntimeException("Unsupported JWA algorithm used for signed request");
        }
    }

    @Override
    protected String getParameter(String paramName) {
        Object val = this.requestParams.get(paramName);
        return val == null ? null : val.toString();
    }

    @Override
    protected Integer getIntParameter(String paramName) {
        Object val = this.requestParams.get(paramName);
        return val == null ? null : Integer.valueOf(Integer.parseInt(this.getParameter(paramName)));
    }

    @Override
    protected Set<String> keySet() {
        return this.requestParams.keySet();
    }

    static class TypedHashMap
    extends HashMap<String, Object> {
        TypedHashMap() {
        }
    }
}

