/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

public class UserRealmRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "oidc-usermodel-realm-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Realm Role";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user realm role to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        String rolePrefix = (String)mappingModel.getConfig().get("usermodel.realmRoleMapping.rolePrefix");
        Set<String> realmRoleNames = this.flattenRoleModelToRoleNames(user.getRoleMappings(), rolePrefix);
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, realmRoleNames);
    }

    static {
        ProviderConfigProperty realmRolePrefix = new ProviderConfigProperty();
        realmRolePrefix.setName("usermodel.realmRoleMapping.rolePrefix");
        realmRolePrefix.setLabel("usermodel.realmRoleMapping.rolePrefix.label");
        realmRolePrefix.setHelpText("usermodel.realmRoleMapping.rolePrefix.tooltip");
        realmRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(realmRolePrefix);
        OIDCAttributeMapperHelper.addAttributeConfig(CONFIG_PROPERTIES);
    }
}

