/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.Config;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.services.resources.RealmsResource;

public class SamlIDPDescriptorClientInstallation
implements ClientInstallationProvider {
    public static String getIDPDescriptorForClient(RealmModel realm, ClientModel client, URI serverBaseUri) {
        SamlClient samlClient = new SamlClient(client);
        String idpEntityId = RealmsResource.realmBaseUrl(UriBuilder.fromUri((URI)serverBaseUri)).build(new Object[]{realm.getName()}).toString();
        String idp = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<EntityDescriptor entityID=\"" + idpEntityId + "\"\n                   xmlns=\"urn:oasis:names:tc:SAML:2.0:metadata\"\n                   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n   <IDPSSODescriptor WantAuthnRequestsSigned=\"" + Boolean.toString(samlClient.requiresClientSignature()) + "\"\n      protocolSupportEnumeration=\"urn:oasis:names:tc:SAML:2.0:protocol\">\n";
        idp = samlClient.forceNameIDFormat() && samlClient.getNameIDFormat() != null ? idp + "   <NameIDFormat>" + samlClient.getNameIDFormat() + "</NameIDFormat>\n" : idp + "   <NameIDFormat>urn:oasis:names:tc:SAML:2.0:nameid-format:persistent</NameIDFormat>\n   <NameIDFormat>urn:oasis:names:tc:SAML:2.0:nameid-format:transient</NameIDFormat>\n   <NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified</NameIDFormat>\n   <NameIDFormat>urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress</NameIDFormat>\n";
        String bindUrl = RealmsResource.protocolUrl(UriBuilder.fromUri((URI)serverBaseUri)).build(new Object[]{realm.getName(), "saml"}).toString();
        idp = idp + "\n      <SingleSignOnService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n         Location=\"" + bindUrl + "\" />\n";
        if (!samlClient.forcePostBinding()) {
            idp = idp + "      <SingleSignOnService Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n         Location=\"" + bindUrl + "\" />\n";
        }
        idp = idp + "      <SingleLogoutService\n         Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST\"\n         Location=\"" + bindUrl + "\" />\n";
        if (!samlClient.forcePostBinding()) {
            idp = idp + "      <SingleLogoutService\n         Binding=\"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect\"\n         Location=\"" + bindUrl + "\" />\n";
        }
        idp = idp + "      <KeyDescriptor use=\"signing\">\n          <dsig:KeyInfo xmlns:dsig=\"http://www.w3.org/2000/09/xmldsig#\">\n              <dsig:X509Data>\n                  <dsig:X509Certificate>\n                      " + realm.getCertificatePem() + "\n                  </dsig:X509Certificate>\n              </dsig:X509Data>\n          </dsig:KeyInfo>\n      </KeyDescriptor>\n   </IDPSSODescriptor>\n</EntityDescriptor>\n";
        return idp;
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        String descriptor = SamlIDPDescriptorClientInstallation.getIDPDescriptorForClient(realm, client, serverBaseUri);
        return Response.ok((Object)descriptor, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "SAML Metadata IDPSSODescriptor";
    }

    public String getHelpText() {
        return "SAML Metadata IDSSODescriptor tailored for the client.  This is special because not every client may require things like digital signatures";
    }

    public String getFilename() {
        return "client-tailored-saml-idp-metadata.xml";
    }

    public String getMediaType() {
        return "application/xml";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "saml-idp-descriptor";
    }
}

