/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.transaction;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakTransaction;

public class JtaTransactionWrapper
implements KeycloakTransaction {
    private static final Logger logger = Logger.getLogger(JtaTransactionWrapper.class);
    protected TransactionManager tm;
    protected Transaction ut;
    protected Transaction suspended;
    protected Exception ended;

    public JtaTransactionWrapper(TransactionManager tm) {
        this.tm = tm;
        try {
            this.suspended = tm.suspend();
            logger.debug((Object)"new JtaTransactionWrapper");
            logger.debugv("was existing? {0}", (Object)(this.suspended != null ? 1 : 0));
            tm.begin();
            this.ut = tm.getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void begin() {
    }

    public void commit() {
        try {
            logger.debug((Object)"JtaTransactionWrapper  commit");
            this.tm.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.end();
        }
    }

    public void rollback() {
        try {
            logger.debug((Object)"JtaTransactionWrapper rollback");
            this.tm.rollback();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.end();
        }
    }

    public void setRollbackOnly() {
        try {
            this.tm.setRollbackOnly();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getRollbackOnly() {
        try {
            return this.tm.getStatus() == 1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isActive() {
        try {
            return this.tm.getStatus() == 0;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void end() {
        this.ended = null;
        logger.debug((Object)"JtaTransactionWrapper end");
        if (this.suspended != null) {
            try {
                logger.debug((Object)"JtaTransactionWrapper resuming suspended");
                this.tm.resume(this.suspended);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

