/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.RealmModel;

public abstract class AbstractRsaKeyProvider
implements KeyProvider {
    private final boolean enabled;
    private final boolean active;
    private final ComponentModel model;
    private final Keys keys;

    public AbstractRsaKeyProvider(RealmModel realm, ComponentModel model) {
        this.model = model;
        this.enabled = model.get("enabled", true);
        this.active = model.get("active", true);
        if (model.hasNote(Keys.class.getName())) {
            this.keys = (Keys)model.getNote(Keys.class.getName());
        } else {
            this.keys = this.loadKeys(realm, model);
            model.setNote(Keys.class.getName(), (Object)this.keys);
        }
    }

    protected abstract Keys loadKeys(RealmModel var1, ComponentModel var2);

    public final String getKid() {
        return this.isActive() ? this.keys.getKid() : null;
    }

    public final PrivateKey getPrivateKey() {
        return this.isActive() ? this.keys.getKeyPair().getPrivate() : null;
    }

    public final PublicKey getPublicKey(String kid) {
        return this.isEnabled() && kid.equals(this.keys.getKid()) ? this.keys.getKeyPair().getPublic() : null;
    }

    public X509Certificate getCertificate(String kid) {
        return this.isEnabled() && kid.equals(this.keys.getKid()) ? this.keys.getCertificate() : null;
    }

    public final List<KeyMetadata> getKeyMetadata() {
        String kid = this.keys.getKid();
        PublicKey publicKey = this.keys.getKeyPair().getPublic();
        if (kid != null && publicKey != null) {
            KeyMetadata k = new KeyMetadata();
            k.setProviderId(this.model.getId());
            k.setProviderPriority(this.model.get("priority", 0L));
            k.setKid(kid);
            if (this.isActive()) {
                k.setStatus(KeyMetadata.Status.ACTIVE);
            } else if (this.isEnabled()) {
                k.setStatus(KeyMetadata.Status.PASSIVE);
            } else {
                k.setStatus(KeyMetadata.Status.DISABLED);
            }
            k.setType(KeyMetadata.Type.RSA);
            k.setPublicKey(publicKey);
            k.setCertificate((Certificate)this.keys.getCertificate());
            return Collections.singletonList(k);
        }
        return Collections.emptyList();
    }

    public void close() {
    }

    private boolean isEnabled() {
        return this.keys != null && this.enabled;
    }

    private boolean isActive() {
        return this.isEnabled() && this.active;
    }

    public static class Keys {
        private String kid;
        private KeyPair keyPair;
        private X509Certificate certificate;

        public Keys(String kid, KeyPair keyPair, X509Certificate certificate) {
            this.kid = kid;
            this.keyPair = keyPair;
            this.certificate = certificate;
        }

        public String getKid() {
            return this.kid;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }
    }
}

