/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.util.List;
import java.util.Map;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.OAuthErrorException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.endpoints.TokenIntrospectionEndpoint;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.Cors;

public class TokenEndpoint {
    private static final Logger logger = Logger.getLogger(TokenEndpoint.class);
    private MultivaluedMap<String, String> formParams;
    private ClientModel client;
    private Map<String, String> clientAuthAttributes;
    @Context
    private KeycloakSession session;
    @Context
    private HttpRequest request;
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private ClientConnection clientConnection;
    private final TokenManager tokenManager;
    private final RealmModel realm;
    private final EventBuilder event;
    private Action action;
    private String grantType;

    public TokenEndpoint(TokenManager tokenManager, RealmModel realm, EventBuilder event) {
        this.tokenManager = tokenManager;
        this.realm = realm;
        this.event = event;
    }

    @POST
    public Response build() {
        this.formParams = this.request.getDecodedFormParameters();
        this.grantType = (String)this.formParams.getFirst((Object)"grant_type");
        this.checkSsl();
        this.checkRealm();
        this.checkGrantType();
        this.checkClient();
        switch (this.action) {
            case AUTHORIZATION_CODE: {
                return this.buildAuthorizationCodeAccessTokenResponse();
            }
            case REFRESH_TOKEN: {
                return this.buildRefreshToken();
            }
            case PASSWORD: {
                return this.buildResourceOwnerPasswordCredentialsGrant();
            }
            case CLIENT_CREDENTIALS: {
                return this.buildClientCredentialsGrant();
            }
        }
        throw new RuntimeException("Unknown action " + (Object)((Object)this.action));
    }

    @Path(value="introspect")
    public Object introspect() {
        TokenIntrospectionEndpoint tokenIntrospectionEndpoint = new TokenIntrospectionEndpoint(this.realm, this.event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)tokenIntrospectionEndpoint);
        return tokenIntrospectionEndpoint;
    }

    @OPTIONS
    public Response preflight() {
        if (logger.isDebugEnabled()) {
            logger.debugv("CORS preflight from: {0}", this.headers.getRequestHeaders().getFirst((Object)"Origin"));
        }
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    private void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event);
        this.client = clientAuth.getClient();
        this.clientAuthAttributes = clientAuth.getClientAuthAttributes();
        if (this.client.isBearerOnly()) {
            throw new ErrorResponseException("invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    private void checkGrantType() {
        if (this.grantType == null) {
            throw new ErrorResponseException("invalid_request", "Missing form parameter: grant_type", Response.Status.BAD_REQUEST);
        }
        if (this.grantType.equals("authorization_code")) {
            this.event.event(EventType.CODE_TO_TOKEN);
            this.action = Action.AUTHORIZATION_CODE;
        } else if (this.grantType.equals("refresh_token")) {
            this.event.event(EventType.REFRESH_TOKEN);
            this.action = Action.REFRESH_TOKEN;
        } else if (this.grantType.equals("password")) {
            this.event.event(EventType.LOGIN);
            this.action = Action.PASSWORD;
        } else if (this.grantType.equals("client_credentials")) {
            this.event.event(EventType.CLIENT_LOGIN);
            this.action = Action.CLIENT_CREDENTIALS;
        } else {
            throw new ErrorResponseException("invalid_request", "Invalid grant_type", Response.Status.BAD_REQUEST);
        }
        this.event.detail("grant_type", this.grantType);
    }

    public Response buildAuthorizationCodeAccessTokenResponse() {
        String code = (String)this.formParams.getFirst((Object)"code");
        if (code == null) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_request", "Missing parameter: code", Response.Status.BAD_REQUEST);
        }
        ClientSessionCode.ParseResult parseResult = ClientSessionCode.parseResult((String)code, (KeycloakSession)this.session, (RealmModel)this.realm);
        if (parseResult.isClientSessionNotFound() || parseResult.isIllegalHash()) {
            String[] parts = code.split("\\.");
            if (parts.length == 2) {
                this.event.detail("code_id", parts[1]);
            }
            this.event.error("invalid_code");
            if (parseResult.getClientSession() != null) {
                this.session.sessions().removeClientSession(this.realm, parseResult.getClientSession());
            }
            throw new ErrorResponseException("invalid_grant", "Code not valid", Response.Status.BAD_REQUEST);
        }
        ClientSessionModel clientSession = parseResult.getClientSession();
        this.event.detail("code_id", clientSession.getId());
        if (!parseResult.getCode().isValid(ClientSessionModel.Action.CODE_TO_TOKEN.name(), ClientSessionCode.ActionType.CLIENT)) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        parseResult.getCode().setAction(null);
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_grant", "User session not found", Response.Status.BAD_REQUEST);
        }
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new ErrorResponseException("invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new ErrorResponseException("invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        this.event.session(userSession.getId());
        String redirectUri = clientSession.getNote("redirect_uri");
        if (redirectUri != null && !redirectUri.equals(this.formParams.getFirst((Object)"redirect_uri"))) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Incorrect redirect_uri", Response.Status.BAD_REQUEST);
        }
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            this.event.error("invalid_code");
            throw new ErrorResponseException("invalid_grant", "Auth error", Response.Status.BAD_REQUEST);
        }
        if (!this.client.isStandardFlowEnabled()) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed to exchange code", Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            this.event.error("user_session_not_found");
            throw new ErrorResponseException("invalid_grant", "Session not active", Response.Status.BAD_REQUEST);
        }
        this.updateClientSession(clientSession);
        this.updateUserSessionFromClientAuth(userSession);
        AccessToken token = this.tokenManager.createClientAccessToken(this.session, parseResult.getCode().getRequestedRoles(), this.realm, this.client, user, userSession, clientSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).accessToken(token).generateIDToken().generateRefreshToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res).type(MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response buildRefreshToken() {
        AccessTokenResponse res;
        String refreshToken = (String)this.formParams.getFirst((Object)"refresh_token");
        if (refreshToken == null) {
            throw new ErrorResponseException("invalid_request", "No refresh token", Response.Status.BAD_REQUEST);
        }
        try {
            TokenManager.RefreshResult result = this.tokenManager.refreshAccessToken(this.session, this.uriInfo, this.clientConnection, this.realm, this.client, refreshToken, this.event, this.headers);
            res = result.getResponse();
            if (!result.isOfflineToken()) {
                UserSessionModel userSession = this.session.sessions().getUserSession(this.realm, res.getSessionState());
                this.updateClientSessions(userSession.getClientSessions());
                this.updateUserSessionFromClientAuth(userSession);
            }
        }
        catch (OAuthErrorException e) {
            this.event.error("invalid_token");
            throw new ErrorResponseException(e.getError(), e.getDescription(), Response.Status.BAD_REQUEST);
        }
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private void updateClientSession(ClientSessionModel clientSession) {
        if (clientSession == null) {
            ServicesLogger.LOGGER.clientSessionNull();
            return;
        }
        String adapterSessionId = (String)this.formParams.getFirst((Object)"client_session_state");
        if (adapterSessionId != null) {
            String adapterSessionHost = (String)this.formParams.getFirst((Object)"client_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)this.client.getClientId(), (Object)adapterSessionHost);
            this.event.detail("client_session_state", adapterSessionId);
            clientSession.setNote("client_session_state", adapterSessionId);
            this.event.detail("client_session_host", adapterSessionHost);
            clientSession.setNote("client_session_host", adapterSessionHost);
        }
    }

    private void updateClientSessions(List<ClientSessionModel> clientSessions) {
        if (clientSessions == null) {
            ServicesLogger.LOGGER.clientSessionNull();
            return;
        }
        for (ClientSessionModel clientSession : clientSessions) {
            if (clientSession == null) {
                ServicesLogger.LOGGER.clientSessionNull();
                continue;
            }
            if (clientSession.getClient() == null) {
                ServicesLogger.LOGGER.clientModelNull();
                continue;
            }
            if (!this.client.getId().equals(clientSession.getClient().getId())) continue;
            this.updateClientSession(clientSession);
        }
    }

    private void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    public Response buildResourceOwnerPasswordCredentialsGrant() {
        this.event.detail("auth_method", "oauth_credentials");
        if (!this.client.isDirectAccessGrantsEnabled()) {
            this.event.error("not_allowed");
            throw new ErrorResponseException("invalid_grant", "Client not allowed for direct access grants", Response.Status.BAD_REQUEST);
        }
        if (this.client.isConsentRequired()) {
            this.event.error("consent_denied");
            throw new ErrorResponseException("invalid_client", "Client requires user consent", Response.Status.BAD_REQUEST);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        UserSessionProvider sessions = this.session.sessions();
        ClientSessionModel clientSession = sessions.createClientSession(this.realm, this.client);
        clientSession.setAuthMethod("openid-connect");
        clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
        clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        clientSession.setNote("scope", scope);
        AuthenticationFlowModel flow = this.realm.getDirectGrantFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowId(flowId).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        Response challenge = processor.authenticateOnly();
        if (challenge != null) {
            return challenge;
        }
        processor.evaluateRequiredActionTriggers();
        UserModel user = clientSession.getAuthenticatedUser();
        if (user.getRequiredActions() != null && user.getRequiredActions().size() > 0) {
            this.event.error("resolve_required_actions");
            throw new ErrorResponseException("invalid_grant", "Account is not fully set up", Response.Status.BAD_REQUEST);
        }
        processor.attachSession();
        UserSessionModel userSession = processor.getUserSession();
        this.updateUserSessionFromClientAuth(userSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).generateAccessToken().generateRefreshToken().generateIDToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    public Response buildClientCredentialsGrant() {
        if (this.client.isBearerOnly()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.error("invalid_client");
            throw new ErrorResponseException("unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        UserModel clientUser = this.session.users().getServiceAccount(this.client);
        if (clientUser == null || this.client.getProtocolMapperByName("openid-connect", "Client ID") == null) {
            logger.debugf("Service account user for client '%s' not found or default protocol mapper for service account not found. Creating now", (Object)this.client.getClientId());
            new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
            clientUser = this.session.users().getServiceAccount(this.client);
        }
        String clientUsername = clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(clientUser);
        if (!clientUser.isEnabled()) {
            this.event.error("user_disabled");
            throw new ErrorResponseException("invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = (String)this.formParams.getFirst((Object)"scope");
        UserSessionProvider sessions = this.session.sessions();
        ClientSessionModel clientSession = sessions.createClientSession(this.realm, this.client);
        clientSession.setAuthMethod("openid-connect");
        clientSession.setNote("iss", Urls.realmIssuer(this.uriInfo.getBaseUri(), this.realm.getName()));
        clientSession.setNote("scope", scope);
        UserSessionModel userSession = sessions.createUserSession(this.realm, clientUser, clientUsername, this.clientConnection.getRemoteAddr(), "client_auth", false, null, null);
        this.event.session(userSession);
        TokenManager.attachClientSession(userSession, clientSession);
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteAddr());
        this.updateUserSessionFromClientAuth(userSession);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSession).generateAccessToken().generateRefreshToken().generateIDToken().build();
        this.event.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(this.client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    private static enum Action {
        AUTHORIZATION_CODE,
        REFRESH_TOKEN,
        PASSWORD,
        CLIENT_CREDENTIALS;

    }
}

