/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractUserRoleMappingMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

public class UserClientRoleMappingMapper
extends AbstractUserRoleMappingMapper {
    public static final String PROVIDER_ID = "oidc-usermodel-client-role-mapper";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Client Role";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map a user client role to a token claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        String clientId = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.clientId");
        if (clientId != null) {
            ClientModel clientModel = userSession.getRealm().getClientByClientId(clientId.trim());
            Set clientRoleMappings = user.getClientRoleMappings(clientModel);
            String rolePrefix = (String)mappingModel.getConfig().get("usermodel.clientRoleMapping.rolePrefix");
            Set<String> clientRoleNames = this.flattenRoleModelToRoleNames(clientRoleMappings, rolePrefix);
            OIDCAttributeMapperHelper.mapClaim(token, mappingModel, clientRoleNames);
        }
    }

    public static ProtocolMapperModel create(String clientId, String clientRolePrefix, String name, String tokenClaimName, boolean accessToken, boolean idToken) {
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper(name, "foo", tokenClaimName, "String", true, name, accessToken, idToken, PROVIDER_ID);
        mapper.getConfig().put("usermodel.clientRoleMapping.clientId", clientId);
        mapper.getConfig().put("usermodel.clientRoleMapping.rolePrefix", clientRolePrefix);
        return mapper;
    }

    static {
        ProviderConfigProperty clientId = new ProviderConfigProperty();
        clientId.setName("usermodel.clientRoleMapping.clientId");
        clientId.setLabel("usermodel.clientRoleMapping.clientId.label");
        clientId.setHelpText("usermodel.clientRoleMapping.clientId.tooltip");
        clientId.setType("ClientList");
        CONFIG_PROPERTIES.add(clientId);
        ProviderConfigProperty clientRolePrefix = new ProviderConfigProperty();
        clientRolePrefix.setName("usermodel.clientRoleMapping.rolePrefix");
        clientRolePrefix.setLabel("usermodel.clientRoleMapping.rolePrefix.label");
        clientRolePrefix.setHelpText("usermodel.clientRoleMapping.rolePrefix.tooltip");
        clientRolePrefix.setType("String");
        CONFIG_PROPERTIES.add(clientRolePrefix);
        OIDCAttributeMapperHelper.addAttributeConfig(CONFIG_PROPERTIES, UserClientRoleMappingMapper.class);
    }
}

