/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerDeployer;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.provider.Spi;
import org.keycloak.services.DefaultKeycloakSession;
import org.keycloak.services.ServicesLogger;

public class DefaultKeycloakSessionFactory
implements KeycloakSessionFactory,
ProviderManagerDeployer {
    private static final Logger logger = Logger.getLogger(DefaultKeycloakSessionFactory.class);
    private Set<Spi> spis = new HashSet<Spi>();
    private Map<Class<? extends Provider>, String> provider = new HashMap<Class<? extends Provider>, String>();
    private volatile Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
    protected CopyOnWriteArrayList<ProviderEventListener> listeners = new CopyOnWriteArrayList();
    protected long serverStartupTimestamp;

    public void register(ProviderEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(ProviderEventListener listener) {
        this.listeners.remove(listener);
    }

    public void publish(ProviderEvent event) {
        for (ProviderEventListener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    public void init() {
        this.serverStartupTimestamp = System.currentTimeMillis();
        ProviderManager pm = new ProviderManager(this.getClass().getClassLoader(), Config.scope((String[])new String[0]).getArray("providers"));
        this.spis.addAll(pm.loadSpis());
        this.factoriesMap = this.loadFactories(pm);
        for (ProviderManager providerManager : ProviderManagerRegistry.SINGLETON.getPreBoot()) {
            Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoryMap = this.loadFactories(providerManager);
            for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : factoryMap.entrySet()) {
                Map<String, ProviderFactory> factories = this.factoriesMap.get(entry.getKey());
                if (factories == null) {
                    this.factoriesMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                factories.putAll(entry.getValue());
            }
        }
        this.checkProvider();
        for (Map map : this.factoriesMap.values()) {
            for (ProviderFactory factory : map.values()) {
                factory.postInit((KeycloakSessionFactory)this);
            }
        }
        ProviderManagerRegistry.SINGLETON.setDeployer(this);
    }

    protected Map<Class<? extends Provider>, Map<String, ProviderFactory>> getFactoriesCopy() {
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> copy = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : this.factoriesMap.entrySet()) {
            HashMap<String, ProviderFactory> valCopy = new HashMap<String, ProviderFactory>();
            valCopy.putAll(entry.getValue());
            copy.put(entry.getKey(), valCopy);
        }
        return copy;
    }

    @Override
    public void deploy(ProviderManager pm) {
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> copy = this.getFactoriesCopy();
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> newFactories = this.loadFactories(pm);
        LinkedList<ProviderFactory> undeployed = new LinkedList<ProviderFactory>();
        for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> entry : newFactories.entrySet()) {
            Map<String, ProviderFactory> current = copy.get(entry.getKey());
            if (current == null) {
                copy.put(entry.getKey(), entry.getValue());
                continue;
            }
            for (ProviderFactory f : entry.getValue().values()) {
                ProviderFactory old = current.remove(f.getId());
                if (old == null) continue;
                undeployed.add(old);
            }
            current.putAll(entry.getValue());
        }
        this.factoriesMap = copy;
        for (ProviderFactory factory : undeployed) {
            factory.close();
        }
    }

    @Override
    public void undeploy(ProviderManager pm) {
        logger.debug((Object)"undeploy");
        Map<Class<? extends Provider>, Map<String, ProviderFactory>> copy = this.getFactoriesCopy();
        MultivaluedHashMap<Class<? extends Provider>, ProviderFactory> factories = pm.getLoadedFactories();
        LinkedList<ProviderFactory> undeployed = new LinkedList<ProviderFactory>();
        for (Map.Entry entry : factories.entrySet()) {
            Map<String, ProviderFactory> registered = copy.get(entry.getKey());
            for (ProviderFactory factory : (List)entry.getValue()) {
                undeployed.add(factory);
                logger.debugv("undeploying {0} of id {1}", (Object)factory.getClass().getName(), (Object)factory.getId());
                if (registered == null) continue;
                registered.remove(factory.getId());
            }
        }
        this.factoriesMap = copy;
        for (ProviderFactory factory : undeployed) {
            factory.close();
        }
    }

    protected void checkProvider() {
        for (Spi spi : this.spis) {
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                this.provider.put(spi.getProviderClass(), provider);
                if (this.getProviderFactory(spi.getProviderClass(), provider) != null) continue;
                throw new RuntimeException("Failed to find provider " + provider + " for " + spi.getName());
            }
            Map<String, ProviderFactory> factories = this.factoriesMap.get(spi.getProviderClass());
            if (factories == null || factories.size() != 1) continue;
            provider = factories.values().iterator().next().getId();
            this.provider.put(spi.getProviderClass(), provider);
        }
    }

    protected Map<Class<? extends Provider>, Map<String, ProviderFactory>> loadFactories(ProviderManager pm) {
        HashMap<Class<? extends Provider>, Map<String, ProviderFactory>> factoryMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
        Set<Spi> spiList = this.spis;
        for (Spi spi : spiList) {
            HashMap<String, ProviderFactory> factories = new HashMap<String, ProviderFactory>();
            factoryMap.put(spi.getProviderClass(), factories);
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                Config.Scope scope;
                ProviderFactory factory = pm.load(spi, provider);
                if (factory == null || !this.isEnabled(factory, scope = Config.scope((String[])new String[]{spi.getName(), provider}))) continue;
                factory.init(scope);
                if (spi.isInternal() && !this.isInternal(factory)) {
                    ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                }
                factories.put(factory.getId(), factory);
                logger.debugv("Loaded SPI {0} (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            for (ProviderFactory factory : pm.load(spi)) {
                Config.Scope scope;
                if (this.isEnabled(factory, scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()}))) {
                    factory.init(scope);
                    if (spi.isInternal() && !this.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    factories.put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
        }
        return factoryMap;
    }

    private boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            return ((EnvironmentDependentProviderFactory)factory).isSupported();
        }
        return true;
    }

    protected void loadSPIs(ProviderManager pm, List<Spi> spiList) {
        for (Spi spi : spiList) {
            this.spis.add(spi);
            HashMap<String, ProviderFactory> factories = new HashMap<String, ProviderFactory>();
            this.factoriesMap.put(spi.getProviderClass(), factories);
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                this.provider.put(spi.getProviderClass(), provider);
                ProviderFactory factory = pm.load(spi, provider);
                if (factory == null) {
                    throw new RuntimeException("Failed to find provider " + provider + " for " + spi.getName());
                }
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), provider});
                factory.init(scope);
                if (spi.isInternal() && !this.isInternal(factory)) {
                    ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                }
                factories.put(factory.getId(), factory);
                logger.debugv("Loaded SPI {0} (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            for (ProviderFactory factory : pm.load(spi)) {
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                if (scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
                    factory.init(scope);
                    if (spi.isInternal() && !this.isInternal(factory)) {
                        ServicesLogger.LOGGER.spiMayChange(factory.getId(), factory.getClass().getName(), spi.getName());
                    }
                    factories.put(factory.getId(), factory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)factory.getId());
            }
            if (factories.size() == 1) {
                provider = ((ProviderFactory)factories.values().iterator().next()).getId();
                this.provider.put(spi.getProviderClass(), provider);
                logger.debugv("Loaded SPI {0} (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            logger.debugv("Loaded SPI {0} (providers = {1})", (Object)spi.getName(), factories.keySet());
        }
    }

    public KeycloakSession create() {
        DefaultKeycloakSession session = new DefaultKeycloakSession(this);
        return session;
    }

    <T extends Provider> String getDefaultProvider(Class<T> clazz) {
        return this.provider.get(clazz);
    }

    public Set<Spi> getSpis() {
        return this.spis;
    }

    public Spi getSpi(Class<? extends Provider> providerClass) {
        for (Spi spi : this.spis) {
            if (!spi.getProviderClass().equals(providerClass)) continue;
            return spi;
        }
        return null;
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        return this.getProviderFactory(clazz, this.provider.get(clazz));
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        Map<String, ProviderFactory> map = this.factoriesMap.get(clazz);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    public List<ProviderFactory> getProviderFactories(Class<? extends Provider> clazz) {
        LinkedList<ProviderFactory> list = new LinkedList<ProviderFactory>();
        if (this.factoriesMap == null) {
            return list;
        }
        Map<String, ProviderFactory> providerFactoryMap = this.factoriesMap.get(clazz);
        if (providerFactoryMap == null) {
            return list;
        }
        list.addAll(providerFactoryMap.values());
        return list;
    }

    <T extends Provider> Set<String> getAllProviderIds(Class<T> clazz) {
        HashSet<String> ids = new HashSet<String>();
        for (ProviderFactory f : this.factoriesMap.get(clazz).values()) {
            ids.add(f.getId());
        }
        return ids;
    }

    Class<? extends Provider> getProviderClass(String providerClassName) {
        for (Class<? extends Provider> clazz : this.factoriesMap.keySet()) {
            if (!clazz.getName().equals(providerClassName)) continue;
            return clazz;
        }
        return null;
    }

    public void close() {
        ProviderManagerRegistry.SINGLETON.setDeployer(null);
        for (Map<String, ProviderFactory> factories : this.factoriesMap.values()) {
            for (ProviderFactory factory : factories.values()) {
                factory.close();
            }
        }
    }

    private boolean isInternal(ProviderFactory<?> factory) {
        return factory.getClass().getPackage().getName().startsWith("org.keycloak");
    }

    public long getServerStartupTimestamp() {
        return this.serverStartupTimestamp;
    }
}

