/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.AuthorizationService;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.AccountService;
import org.keycloak.services.resources.ClientsManagementService;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.PublicRealmResource;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.utils.ProfileHelper;
import org.keycloak.wellknown.WellKnownProvider;

@Path(value="/realms")
public class RealmsResource {
    protected static final Logger logger = Logger.getLogger(RealmsResource.class);
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;
    @Context
    private HttpRequest request;
    @Context
    private UriInfo uriInfo;

    public static UriBuilder realmBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return RealmsResource.realmBaseUrl(baseUriBuilder);
    }

    public static UriBuilder realmBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getRealmResource");
    }

    public static UriBuilder accountUrl(UriBuilder base) {
        return base.path(RealmsResource.class).path(RealmsResource.class, "getAccountService");
    }

    public static UriBuilder protocolUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder protocolUrl(UriBuilder builder) {
        return builder.path(RealmsResource.class).path(RealmsResource.class, "getProtocol");
    }

    public static UriBuilder clientRegistrationUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getClientsService");
    }

    public static UriBuilder brokerUrl(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().path(RealmsResource.class).path(RealmsResource.class, "getBrokerService");
    }

    public static UriBuilder wellKnownProviderUrl(UriBuilder builder) {
        return builder.path(RealmsResource.class).path(RealmsResource.class, "getWellKnown");
    }

    @Path(value="{realm}/protocol/{protocol}")
    public Object getProtocol(@PathParam(value="realm") String name, @PathParam(value="protocol") String protocol) {
        RealmModel realm = this.init(name);
        LoginProtocolFactory factory = (LoginProtocolFactory)this.session.getKeycloakSessionFactory().getProviderFactory(LoginProtocol.class, protocol);
        if (factory == null) {
            logger.debugf("protocol %s not found", (Object)protocol);
            throw new NotFoundException("Protocol not found");
        }
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        Object endpoint = factory.createProtocolEndpoint(realm, event);
        ResteasyProviderFactory.getInstance().injectProperties(endpoint);
        return endpoint;
    }

    @GET
    @Path(value="{realm}/clients/{client_id}/redirect")
    public Response getRedirect(@PathParam(value="realm") String realmName, @PathParam(value="client_id") String clientId) {
        RealmModel realm = this.init(realmName);
        if (realm == null) {
            return null;
        }
        ClientModel client = realm.getClientByClientId(clientId);
        if (client == null) {
            return null;
        }
        if (client.getRootUrl() == null && client.getBaseUrl() == null) {
            return null;
        }
        URI targetUri = client.getRootUrl() != null && (client.getBaseUrl() == null || client.getBaseUrl().isEmpty()) ? KeycloakUriBuilder.fromUri((String)client.getRootUrl()).build(new Object[0]) : KeycloakUriBuilder.fromUri((String)ResolveRelative.resolveRelativeUri(this.uriInfo.getRequestUri(), client.getRootUrl(), client.getBaseUrl())).build(new Object[0]);
        return Response.seeOther((URI)targetUri).build();
    }

    @Path(value="{realm}/login-actions")
    public LoginActionsService getLoginActionsService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        LoginActionsService service = new LoginActionsService(realm, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="{realm}/clients-registrations")
    public ClientRegistrationService getClientsService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        ClientRegistrationService service = new ClientRegistrationService(event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="{realm}/clients-managements")
    public ClientsManagementService getClientsManagementService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        ClientsManagementService service = new ClientsManagementService(realm, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    private RealmModel init(String realmName) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            throw new NotFoundException("Realm does not exist");
        }
        this.session.getContext().setRealm(realm);
        return realm;
    }

    @Path(value="{realm}/account")
    public AccountService getAccountService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        ClientModel client = realm.getClientByClientId("account");
        if (client == null || !client.isEnabled()) {
            logger.debug((Object)"account management not enabled");
            throw new NotFoundException("account management not enabled");
        }
        EventBuilder event = new EventBuilder(realm, this.session, this.clientConnection);
        AccountService accountService = new AccountService(realm, client, event);
        ResteasyProviderFactory.getInstance().injectProperties((Object)accountService);
        accountService.init();
        return accountService;
    }

    @Path(value="{realm}")
    public PublicRealmResource getRealmResource(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        PublicRealmResource realmResource = new PublicRealmResource(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)realmResource);
        return realmResource;
    }

    @Path(value="{realm}/broker")
    public IdentityBrokerService getBrokerService(@PathParam(value="realm") String name) {
        RealmModel realm = this.init(name);
        IdentityBrokerService brokerService = new IdentityBrokerService(realm);
        ResteasyProviderFactory.getInstance().injectProperties((Object)brokerService);
        brokerService.init();
        return brokerService;
    }

    @OPTIONS
    @Path(value="{realm}/.well-known/{provider}")
    @Produces(value={"application/json"})
    public Response getVersionPreflight(@PathParam(value="realm") String name, @PathParam(value="provider") String providerName) {
        return Cors.add(this.request, Response.ok()).allowedMethods("GET").preflight().auth().build();
    }

    @GET
    @Path(value="{realm}/.well-known/{provider}")
    @Produces(value={"application/json"})
    public Response getWellKnown(@PathParam(value="realm") String name, @PathParam(value="provider") String providerName) {
        this.init(name);
        WellKnownProvider wellKnown = (WellKnownProvider)this.session.getProvider(WellKnownProvider.class, providerName);
        Response.ResponseBuilder responseBuilder = Response.ok((Object)wellKnown.getConfig()).cacheControl(CacheControlUtil.getDefaultCacheControl());
        return Cors.add(this.request, responseBuilder).allowedOrigins("*").auth().build();
    }

    @Path(value="{realm}/authz")
    public Object getAuthorizationService(@PathParam(value="realm") String name) {
        ProfileHelper.requirePreview();
        this.init(name);
        AuthorizationProvider authorization = (AuthorizationProvider)this.session.getProvider(AuthorizationProvider.class);
        AuthorizationService service = new AuthorizationService(authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="{realm}/{extension}")
    public Object resolveRealmExtension(@PathParam(value="realm") String realmName, @PathParam(value="extension") String extension) {
        RealmResourceProvider provider = (RealmResourceProvider)this.session.getProvider(RealmResourceProvider.class, extension);
        if (provider != null) {
            this.init(realmName);
            Object resource = provider.getResource();
            if (resource != null) {
                return resource;
            }
        }
        throw new NotFoundException();
    }
}

