/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.protocol.oid4vc.model.Claim;
import org.keycloak.protocol.oid4vc.model.Claims;
import org.keycloak.util.JsonSerialization;

public class ClaimsTest {
    @Test
    public void toJsonString() throws JsonProcessingException {
        Claims claims = new Claims();
        claims.put((Object)"firstName", (Object)new Claim());
        claims.put((Object)"lastName", (Object)new Claim());
        claims.put((Object)"email", (Object)new Claim());
        String jsonString = claims.toJsonString();
        JsonNode jsonNode = JsonSerialization.mapper.readTree(jsonString);
        Assert.assertNotNull((Object)jsonNode.get("firstName"));
        Assert.assertNotNull((Object)jsonNode.get("lastName"));
        Assert.assertNotNull((Object)jsonNode.get("email"));
    }

    @Test
    public void fromJsonString() {
        String serializeForm = "{ \"firstName\": {}, \"lastName\": {}, \"email\": {} }";
        Claims claims = Claims.fromJsonString((String)"{ \"firstName\": {}, \"lastName\": {}, \"email\": {} }");
        Assert.assertNotNull((Object)claims);
        Assert.assertNotNull((Object)claims.get((Object)"firstName"));
        Assert.assertNotNull((Object)claims.get((Object)"lastName"));
        Assert.assertNotNull((Object)claims.get((Object)"email"));
    }

    @Test
    public void fromJsonStringDeepClaim() {
        String serializeForm = "{ \"firstName\": {\"mandatory\":false}, \"lastName\": {\"mandatory\":false}, \"email\": {\"mandatory\":true} }";
        Claims claims = Claims.fromJsonString((String)"{ \"firstName\": {\"mandatory\":false}, \"lastName\": {\"mandatory\":false}, \"email\": {\"mandatory\":true} }");
        Assert.assertNotNull((Object)claims);
        Assert.assertNotNull((Object)claims.get((Object)"firstName"));
        Assert.assertFalse((boolean)((Claim)claims.get((Object)"firstName")).getMandatory());
        Assert.assertNotNull((Object)claims.get((Object)"lastName"));
        Assert.assertFalse((boolean)((Claim)claims.get((Object)"lastName")).getMandatory());
        Assert.assertNotNull((Object)claims.get((Object)"email"));
        Assert.assertTrue((boolean)((Claim)claims.get((Object)"email")).getMandatory());
    }
}

