/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.spi.HttpRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.resteasy.HttpRequestImpl;
import org.keycloak.services.resteasy.ResteasyKeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;

public class RedirectUtilsTest {
    private static KeycloakSession session;

    @BeforeClass
    public static void beforeClass() {
        HttpRequestImpl httpRequest = new HttpRequestImpl((HttpRequest)MockHttpRequest.create((String)"GET", (URI)URI.create("https://keycloak.org/"), (URI)URI.create("https://keycloak.org")));
        Profile.defaults();
        CryptoIntegration.init((ClassLoader)CryptoProvider.class.getClassLoader());
        ResteasyKeycloakSessionFactory sessionFactory = new ResteasyKeycloakSessionFactory();
        sessionFactory.init();
        session = new ResteasyKeycloakSession(sessionFactory);
        session.getContext().setHttpRequest((org.keycloak.http.HttpRequest)httpRequest);
    }

    @Test
    public void testverifyRedirectUriHttps() {
        Set set = Stream.of("https://keycloak.org/test1", "https://keycloak.org/test2", "https://keycloak.org/parent/*").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/test1", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test1", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test2", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test2", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/parent", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/parent", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/parent/child", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/parent/child", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test1/child", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.com/test", set, (boolean)false));
    }

    @Test
    public void testVerifyRedirectUriNative() {
        Set set = Stream.of("http://127.0.0.1", "http://127.0.0.1/callback", "http://[::1]", "http://[::1]/callback", "http://127.0.0.1/callback", "http://localhost", "http://localhost/callback").collect(Collectors.toSet());
        Assert.assertEquals((Object)"http://127.0.0.1", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1", set, (boolean)false));
        Assert.assertEquals((Object)"http://127.0.0.1:12324", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1:12324", set, (boolean)false));
        Assert.assertEquals((Object)"http://127.0.0.1/callback", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1/callback", set, (boolean)false));
        Assert.assertEquals((Object)"http://127.0.0.1:12324/callback", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1:12324/callback", set, (boolean)false));
        Assert.assertEquals((Object)"http://[::1]", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]", set, (boolean)false));
        Assert.assertEquals((Object)"http://[::1]:12324", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]:12324", set, (boolean)false));
        Assert.assertEquals((Object)"http://[::1]/callback", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]/callback", set, (boolean)false));
        Assert.assertEquals((Object)"http://[::1]:12324/callback", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]:12324/callback", set, (boolean)false));
        Assert.assertEquals((Object)"http://localhost", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost", set, (boolean)false));
        Assert.assertEquals((Object)"http://localhost:12324", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost:12324", set, (boolean)false));
        Assert.assertEquals((Object)"http://localhost/callback", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost/callback", set, (boolean)false));
        Assert.assertEquals((Object)"http://localhost:12324/callback", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost:12324/callback", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1@invalid.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1:12324@invalid.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1@invalid.com/callback", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://127.0.0.1:12324@invalid.com/callback", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]@invalid.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]:12324@invalid.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]@invalid.com/callback", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://[::1]:12324@invalid.com/callback", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost@invalid.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost:12324@invalid.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost@invalid.com/callback", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://localhost:12324@invalid.com/callback", set, (boolean)false));
    }

    @Test
    public void testverifyRedirectUriMixedSchemes() {
        Set set = Stream.of("https://keycloak.org/*", "custom1:/test1", "custom1:/test2", "custom1:/parent/*", "custom2:*").collect(Collectors.toSet());
        Assert.assertEquals((Object)"custom1:/test1", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/test1", set, (boolean)false));
        Assert.assertEquals((Object)"custom1:/test2", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/test2", set, (boolean)false));
        Assert.assertEquals((Object)"custom1:/parent/child", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/parent/child", set, (boolean)false));
        Assert.assertEquals((Object)"custom2:/something", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom2:/something", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/test", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/test1/test", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom3:/test", set, (boolean)false));
    }

    @Test
    public void testverifyRedirectUriInvalidScheme() {
        Set set = Stream.of("custom1:/test1", "custom1:/test2", "custom1:/parent/*", "custom2:*", "*").collect(Collectors.toSet());
        Assert.assertEquals((Object)"custom1:/test1", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/test1", set, (boolean)false));
        Assert.assertEquals((Object)"custom1:/test2", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/test2", set, (boolean)false));
        Assert.assertEquals((Object)"custom1:/parent/child", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom1:/parent/child", set, (boolean)false));
        Assert.assertEquals((Object)"custom2:/something", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom2:/something", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test", set, (boolean)false));
        Assert.assertEquals((Object)"http://keycloak.org/test", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://keycloak.org/test", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"/test", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.com/test", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, (String)"https://keycloak.com", (String)"/test", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"custom3:/test", set, (boolean)false));
    }

    @Test
    public void testverifyRedirectUriWithCurlyBrackets() {
        Set set = Stream.of("https://keycloak.org/%7B123%7D", "https://keycloak.org/parent/*").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/%7B123%7D", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/%7B123%7D", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/parent/%7B123%7D", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/parent/%7B123%7D", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/%7Babc%7D", set, (boolean)false));
    }

    @Test
    public void testverifyInvalidRedirectUri() {
        Set set = Stream.of("https://keycloak.org/*").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/path%20space/", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/path%20space/", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/path%3Cless/", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/path%3Cless/", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/path/index.jsp?param=v1+v2", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/path/index.jsp?param=v1+v2", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/path space/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/path<less/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/path/index.jsp?param=v1 v2", set, (boolean)false));
    }

    @Test
    public void testverifyCaseIsSensitive() {
        Set set = Stream.of("https://keycloak.org/*", "http://KeyCloak.org/*", "no.host.Name.App:/Test").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/index.html", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/index.html", set, (boolean)false));
        Assert.assertEquals((Object)"http://KeyCloak.org/index.html", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://KeyCloak.org/index.html", set, (boolean)false));
        Assert.assertEquals((Object)"no.host.Name.App:/Test", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"no.host.Name.App:/Test", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://KeyCloak.org/index.html", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://keycloak.org/index.html", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"HTTPS://keycloak.org/index.html", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"no.host.Name.app:/Test", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"no.host.Name.App:/test", set, (boolean)false));
    }

    @Test
    public void testRelativeRedirectUri() {
        Set set = Stream.of("*").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/path", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, (String)"https://keycloak.org", (String)"/path", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/path", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, (String)"https://keycloak.org", (String)"path", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/../other", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/../other", set, (boolean)false));
        Assert.assertEquals((Object)"http://keycloak.org/test%2Fother", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"http://keycloak.org/test%2Fother", set, (boolean)false));
    }

    @Test
    public void testUserInfo() {
        Set set = Stream.of("https://keycloak.org/*", "https://test*", "https://something@keycloak.com/exact").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/index.html", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/index.html", set, (boolean)false));
        Assert.assertEquals((Object)"https://test.com/index.html", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://test.com/index.html", set, (boolean)false));
        Assert.assertEquals((Object)"https://something@keycloak.com/exact", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://something@keycloak.com/exact", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://something@other.com/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org@other.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org%2F@other.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://test@other.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://test.com@other.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://something@keycloak.org/path", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://some%20thing@test.com/path", set, (boolean)false));
    }

    @Test
    public void testEncodedRedirectUri() {
        Set set = Stream.of("https://keycloak.org/test/*", "https://keycloak.org/exact/%5C%2F/..").collect(Collectors.toSet());
        Assert.assertEquals((Object)"https://keycloak.org/test/index.html", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/index.html", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test?encodeTest=a%3Cb", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test?encodeTest=a%3Cb", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test?encodeTest=a%3Cb#encode2=a%3Cb", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test?encodeTest=a%3Cb#encode2=a%3Cb", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/#encode2=a%3Cb", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/#encode2=a%3Cb", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/../", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test\\..\\", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%2E%2E/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%2e%2e/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%2E./", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%2E.", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test\\%2E.", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test%2f%2E%2e%2F", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test%5C%2E.%5c", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test%5C..", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%2F%2E%2E%2Fdocumentation", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/.../", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/.../", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/%2E../", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%2E../", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/some%2Fthing/", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/some%2Fthing/", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/./", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/./", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/%252E%252E/", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%252E%252E/", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/%252E%252E/#encodeTest=a%3Cb", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%252E%252E/#encodeTest=a%3Cb", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/test/%25252E%25252E/", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test/%25252E%25252E/", set, (boolean)false));
        Assert.assertEquals((Object)"https://keycloak.org/exact/%5C%2F/..", (Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/exact/%5C%2F/..", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak%2Eorg/test/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org%2Ftest%2F%40sample.com", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test%2Fanother/../any/path/", set, (boolean)false));
        Assert.assertNull((Object)RedirectUtils.verifyRedirectUri((KeycloakSession)session, null, (String)"https://keycloak.org/test%2Fanother/%2E%2E/any/path/", set, (boolean)false));
    }
}

