/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.profile.util;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.saml.profile.util.Soap;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.services.resteasy.ResteasyKeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;
import org.keycloak.utils.ScopeUtil;
import org.w3c.dom.Document;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SoapTest {
    private static HttpServer server;

    @BeforeClass
    public static void startHttpServer() throws IOException {
        server = HttpServer.create(new InetSocketAddress(8280), 0);
        server.createContext("/", new MyHandler());
        server.setExecutor(null);
        server.start();
    }

    @AfterClass
    public static void stopHttpServer() {
        server.stop(0);
    }

    private LogoutRequestType createLogoutRequestType() throws ConfigurationException {
        NameIDType nameId = new NameIDType();
        nameId.setFormat(URI.create(JBossSAMLURIConstants.NAMEID_FORMAT_TRANSIENT.get()));
        nameId.setValue("user1");
        return new SAML2LogoutRequestBuilder().assertionExpiration(60).issuer("http://sample.com").nameId(nameId).destination("http://sample.com/logout").sessionIndex("idx").createLogoutRequest();
    }

    @Test
    public void test1ResponseOK() throws Exception {
        LogoutRequestType request = this.createLogoutRequestType();
        Document doc = SAML2Request.convert((RequestAbstractType)request);
        Profile.defaults();
        CryptoIntegration.init((ClassLoader)CryptoProvider.class.getClassLoader());
        ResteasyKeycloakSessionFactory sessionFactory = new ResteasyKeycloakSessionFactory();
        sessionFactory.init();
        ResteasyKeycloakSession session = new ResteasyKeycloakSession(sessionFactory);
        SOAPMessage soapResponse = Soap.createMessage().addMimeHeader("SOAPAction", "http://www.oasis-open.org/committees/security").addMimeHeader("custom-header", "custom-value").addToBody(doc).call("http://localhost:8280", (KeycloakSession)session);
        Assert.assertArrayEquals((Object[])new String[]{"no-cache, no-store"}, (Object[])soapResponse.getMimeHeaders().getHeader("Cache-Control"));
        Assert.assertArrayEquals((Object[])new String[]{"http://www.oasis-open.org/committees/security"}, (Object[])soapResponse.getMimeHeaders().getHeader("SOAPAction"));
        Assert.assertArrayEquals((Object[])new String[]{"custom-value"}, (Object[])soapResponse.getMimeHeaders().getHeader("custom-header"));
        Document responseDoc = Soap.extractSoapMessage((SOAPMessage)soapResponse);
        SAMLDocumentHolder samlDocResponse = SAML2Request.getSAML2ObjectFromDocument((Document)responseDoc);
        SAML2Object samlObject = samlDocResponse.getSamlObject();
        MatcherAssert.assertThat((Object)samlObject, (Matcher)CoreMatchers.instanceOf(LogoutRequestType.class));
        LogoutRequestType response = (LogoutRequestType)samlObject;
        Assert.assertEquals((Object)request.getNameID().getValue(), (Object)response.getNameID().getValue());
    }

    @Test
    public void test2ConfigurationUsed() throws Exception {
        LogoutRequestType request = this.createLogoutRequestType();
        Document doc = SAML2Request.convert((RequestAbstractType)request);
        Profile.defaults();
        CryptoIntegration.init((ClassLoader)CryptoProvider.class.getClassLoader());
        Config.init((Config.ConfigProvider)new Config.ConfigProvider(){

            public String getProvider(String spi) {
                return null;
            }

            public String getDefaultProvider(String spi) {
                return null;
            }

            public Config.Scope scope(String ... scope) {
                if (scope.length == 2 && "connectionsHttpClient".equals(scope[0]) && "default".equals(scope[1])) {
                    return ScopeUtil.createScope(Collections.singletonMap("proxy-mappings", "localhost;http://localhost:8281"));
                }
                return ScopeUtil.createScope(new HashMap<String, String>());
            }
        });
        ResteasyKeycloakSessionFactory sessionFactory = new ResteasyKeycloakSessionFactory();
        sessionFactory.init();
        ResteasyKeycloakSession session = new ResteasyKeycloakSession(sessionFactory);
        SOAPException ex = (SOAPException)Assert.assertThrows(SOAPException.class, () -> SoapTest.lambda$test2ConfigurationUsed$0(doc, (KeycloakSession)session));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"localhost:8281"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Connection refused"));
    }

    private static /* synthetic */ void lambda$test2ConfigurationUsed$0(Document doc, KeycloakSession session) throws Throwable {
        Soap.createMessage().addToBody(doc).call("http://localhost:8280", session);
    }

    private static class MyHandler
    implements HttpHandler {
        private MyHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if ("POST".equals(exchange.getRequestMethod())) {
                exchange.getResponseHeaders().putAll(exchange.getRequestHeaders());
                try (InputStream is = exchange.getRequestBody();
                     OutputStream os = exchange.getResponseBody();){
                    exchange.sendResponseHeaders(200, Long.parseLong(exchange.getRequestHeaders().getFirst("Content-Length")));
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
            }
            exchange.sendResponseHeaders(400, 0L);
        }
    }
}

