/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.services.validation.Validation;

public class ValidationTest {
    @Test
    public void testEmailValidation() {
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"abc@abc.cz"));
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"435@coco.foo.cz"));
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"A@something"));
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"A@some-thing.foo"));
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"1@A"));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"A@some_thing.foo"));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"@some_thing.foo"));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"abc@"));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"abc@."));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"abc@.foo"));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"abc@foo."));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"abc@foo..bar"));
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"dieg\u00f8@foo.com"));
        Assert.assertTrue((boolean)Validation.isEmailValid((String)"qwertyuiopasdfghjklz@foo.com"));
        Assert.assertFalse((boolean)Validation.isEmailValid((String)"qwertyuiopasdfghjklzxcvbnmqwertyuiopasdfghjklzxcvbnmqwertyqwertyu@foo.com"));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)Validation.isEmpty(null));
        Assert.assertTrue((boolean)Validation.isEmpty((String)""));
        Assert.assertFalse((boolean)Validation.isEmpty((String)" "));
        Assert.assertFalse((boolean)Validation.isEmpty((String)"     "));
        Assert.assertFalse((boolean)Validation.isEmpty((String)"a"));
        Assert.assertFalse((boolean)Validation.isEmpty((String)"    a "));
        Assert.assertFalse((boolean)Validation.isEmpty((String)"asgadfgedfs"));
    }

    @Test
    public void testIsBlank() {
        Assert.assertTrue((boolean)Validation.isBlank(null));
        Assert.assertTrue((boolean)Validation.isBlank((String)""));
        Assert.assertTrue((boolean)Validation.isBlank((String)" "));
        Assert.assertTrue((boolean)Validation.isBlank((String)"  \n   "));
        Assert.assertFalse((boolean)Validation.isBlank((String)"a"));
        Assert.assertFalse((boolean)Validation.isBlank((String)"    a "));
        Assert.assertFalse((boolean)Validation.isBlank((String)"asgadfgedfs"));
    }
}

