/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.broker.oidc;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.IdentityProviderModel;

public class AbstractOAuth2IdentityProviderTest {
    @Test
    public void constructor_defaultScopeHandling() {
        TestProvider tested = this.getTested();
        Assert.assertEquals((Object)tested.getDefaultScopes(), (Object)tested.getConfig().getDefaultScope());
        IdentityProviderModel model = new IdentityProviderModel();
        OAuth2IdentityProviderConfig config = new OAuth2IdentityProviderConfig(model);
        config.setDefaultScope("myscope");
        tested = new TestProvider(config);
        Assert.assertEquals((Object)"myscope", (Object)tested.getConfig().getDefaultScope());
    }

    @Test
    public void getJsonProperty_asJsonNode() throws IOException {
        TestProvider tested = this.getTested();
        JsonNode jsonNode = tested.asJsonNode("{\"nullone\":null, \"emptyone\":\"\", \"blankone\": \" \", \"withvalue\" : \"my value\", \"withbooleanvalue\" : true, \"withnumbervalue\" : 10}");
        Assert.assertNull((Object)tested.getJsonProperty(jsonNode, "nonexisting"));
        Assert.assertNull((Object)tested.getJsonProperty(jsonNode, "nullone"));
        Assert.assertNull((Object)tested.getJsonProperty(jsonNode, "emptyone"));
        Assert.assertEquals((Object)" ", (Object)tested.getJsonProperty(jsonNode, "blankone"));
        Assert.assertEquals((Object)"my value", (Object)tested.getJsonProperty(jsonNode, "withvalue"));
        Assert.assertEquals((Object)"true", (Object)tested.getJsonProperty(jsonNode, "withbooleanvalue"));
        Assert.assertEquals((Object)"10", (Object)tested.getJsonProperty(jsonNode, "withnumbervalue"));
    }

    @Test(expected=IdentityBrokerException.class)
    public void getFederatedIdentity_responseUrlLine_tokenNotFound() {
        TestProvider tested = this.getTested();
        tested.getFederatedIdentity("cosi=sss");
    }

    @Test(expected=IdentityBrokerException.class)
    public void getFederatedIdentity_responseJSON_tokenNotFound() {
        TestProvider tested = this.getTested();
        HashMap notes = new HashMap();
        tested.getFederatedIdentity("{\"cosi\":\"sss\"}");
    }

    @Test(expected=IdentityBrokerException.class)
    public void getFederatedIdentity_responseJSON_invalidFormat() {
        TestProvider tested = this.getTested();
        HashMap notes = new HashMap();
        tested.getFederatedIdentity("{\"cosi\":\"sss\"");
    }

    @Test(expected=IdentityBrokerException.class)
    public void getFederatedIdentity_responseJSON_emptyTokenField() {
        TestProvider tested = this.getTested();
        tested.getFederatedIdentity("{\"access_token\" : \"\"}");
    }

    @Test(expected=IdentityBrokerException.class)
    public void getFederatedIdentity_responseJSON_nullTokenField() {
        TestProvider tested = this.getTested();
        tested.getFederatedIdentity("{\"access_token\" : null}");
    }

    @Test
    public void getFederatedIdentity_responseJSON() {
        TestProvider tested = this.getTested();
        BrokeredIdentityContext fi = tested.getFederatedIdentity("{\"access_token\" : \"458rt\"}");
        Assert.assertNotNull((Object)fi);
        Assert.assertEquals((Object)"458rt", (Object)fi.getId());
    }

    @Test
    public void getFederatedIdentity_responseUrlLine() {
        TestProvider tested = this.getTested();
        BrokeredIdentityContext fi = tested.getFederatedIdentity("cosi=sss&access_token=458rtf&kdesi=ss}");
        Assert.assertNotNull((Object)fi);
        Assert.assertEquals((Object)"458rtf", (Object)fi.getId());
    }

    private TestProvider getTested() {
        return new TestProvider(this.getConfig(null, null, null, Boolean.FALSE, Boolean.FALSE));
    }

    private OAuth2IdentityProviderConfig getConfig(String autorizationUrl, String defaultScope, String clientId, Boolean isLoginHint, Boolean passMaxAge) {
        IdentityProviderModel model = new IdentityProviderModel();
        OAuth2IdentityProviderConfig config = new OAuth2IdentityProviderConfig(model);
        config.setAuthorizationUrl(autorizationUrl);
        config.setDefaultScope(defaultScope);
        config.setClientId(clientId);
        config.setLoginHint(isLoginHint.booleanValue());
        config.setPassMaxAge(passMaxAge.booleanValue());
        return config;
    }

    private static class TestProvider
    extends AbstractOAuth2IdentityProvider<OAuth2IdentityProviderConfig> {
        public TestProvider(OAuth2IdentityProviderConfig config) {
            super(null, config);
        }

        protected String getDefaultScopes() {
            return "default";
        }

        protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
            return new BrokeredIdentityContext(accessToken, (IdentityProviderModel)this.getConfig());
        }
    }
}

