/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.broker.oidc.mappers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;

public class AbstractJsonUserAttributeMapperTest {
    private static ObjectMapper mapper = new ObjectMapper();
    private static JsonNode baseNode;

    private JsonNode getJsonNode() throws IOException {
        if (baseNode == null) {
            baseNode = mapper.readTree("{ \"dotted.claim\": \"claimValue\", \"nested.claim\" : { \"claim.with.dots\" : \"nested.claim.with.dots\"}, \"value1\" : \"v1 \",\"value_null\" : null,\"value_empty\" : \"\", \"value_b\" : true, \"value_i\" : 454,  \"value_array\":[\"a1\",\"a2\"],  \"nest1\": {\"value1\": \" fgh \",\"value_null\" : null,\"value_empty\" : \"\", \"nest2\":{\"value_b\" : false, \"value_i\" : 43}},  \"nesta\": { \"a\":[{\"av1\": \"vala1\"},{\"av1\": \"vala2\"}]} }");
        }
        return baseNode;
    }

    @Test
    public void getJsonValue_invalidPath() throws IOException {
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"."));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)".."));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"...value1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)".value1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value1."));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"[]"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"[value1"));
    }

    @Test
    public void getJsonValue_simpleValues() throws IOException {
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_unknown"));
        Assert.assertEquals((Object)"v1", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_null"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_empty"));
        Assert.assertEquals((Object)"true", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_b"));
        Assert.assertEquals((Object)"454", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_i"));
        Assert.assertEquals((Object)"claimValue", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"dotted\\.claim"));
        Assert.assertEquals((Object)"nested.claim.with.dots", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nested\\.claim.claim\\.with\\.dots"));
    }

    @Test
    public void getJsonValue_nestedSimpleValues() throws IOException {
        Assert.assertEquals((Object)mapper.readTree("{\n\t\t\"value1\": \" fgh \",\n\t\t\"value_null\" : null,\n\t\t\"value_empty\" : \"\",\n\t\t\"nest2\":{\n\t\t\t\"value_b\" : false,\n\t\t\t\"value_i\" : 43\n\t\t}\n\t}"), (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1"));
        Assert.assertEquals((Object)mapper.readTree("{\n\t\t\t\"value_b\" : false,\n\t\t\t\"value_i\" : 43\n\t\t}"), (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.nest2"));
        Assert.assertEquals((Object)mapper.readTree("{\"av1\": \"vala1\"}"), (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[0]"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.value_unknown"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.nest2.value_unknown"));
        Assert.assertEquals((Object)"fgh", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.value1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.value_null"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.value_empty"));
        Assert.assertEquals((Object)"false", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.nest2.value_b"));
        Assert.assertEquals((Object)"43", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.nest2.value_i"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1."));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nest1.nest2."));
    }

    @Test
    public void getJsonValue_simpleArray() throws IOException {
        Assert.assertEquals(Arrays.asList("a1", "a2"), (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array[2]"));
        Assert.assertEquals((Object)"a1", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array[0]"));
        Assert.assertEquals((Object)"a2", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array[1]"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array[]"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array]"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array["));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array[a]"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"value_array[-2]"));
    }

    @Test
    public void getJsonValue_nestedArrayWithObjects() throws IOException {
        Assert.assertEquals((Object)"vala1", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[0].av1"));
        Assert.assertEquals((Object)"vala2", (Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[1].av1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[2].av1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[0].av_unknown"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[].av1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a.av1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a].av1"));
        Assert.assertNull((Object)AbstractJsonUserAttributeMapper.getJsonValue((JsonNode)this.getJsonNode(), (String)"nesta.a[.av1"));
    }
}

