/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.broker.saml;

import java.util.HashMap;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.saml.mappers.XPathAttributeMapper;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;

public class XPathAttributeMapperTest {
    private static final String ATTRIBUTE_NAME = "attributeName";
    private static final String USER_ATTRIBUTE_NAME_FOR_TEST = "email";
    private static final String XPATH_FOR_TEST = "//*[local-name()='Street']";
    private static final String EXPECTED_RESULT = "Zillestra\u00dfe";
    private static final String XML_FRAGMENT = "<Street>Zillestra\u00dfe</Street><HouseNumber>17</HouseNumber><ZipCode>10585</ZipCode><City>Berlin</City><Country>DE</Country>";
    private static final String XML_WITH_NAMESPACE = "<myPrefix:Address xmlns:myPrefix=\"http://my.custom.de/schema/saml/extensions\"><myPrefix:Street>Zillestra\u00dfe</myPrefix:Street><myPrefix:HouseNumber>17</myPrefix:HouseNumber><myPrefix:ZipCode>10585</myPrefix:ZipCode><myPrefix:City>Berlin</myPrefix:City><myPrefix:Country>DE</myPrefix:Country></myPrefix:Address>";

    @Test
    public void testInvalidXpath() {
        Assert.assertNull((Object)this.testMapping(XML_FRAGMENT, "//"));
    }

    @Test
    public void testInvalidXml() {
        RuntimeException actualException = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.testMapping("<Open>Foo</Close>", "//*"));
        MatcherAssert.assertThat((Object)actualException.getCause(), (Matcher)CoreMatchers.instanceOf(ParsingException.class));
        Assert.assertNull((Object)this.testMapping(XML_WITH_NAMESPACE, "//*[local-name()=$street]"));
        Assert.assertNull((Object)this.testMapping(XML_WITH_NAMESPACE, "//*[local-name()=myPrefix:add(1,2)]"));
    }

    @Test
    public void testNotFound() {
        Assert.assertNull((Object)this.testMapping(XML_FRAGMENT, "//*[local-name()='Unknown']"));
        Assert.assertNull((Object)this.testMapping(XML_FRAGMENT, "//unknownPrefix:Street"));
    }

    @Test
    public void testSuccess_Value() {
        MatcherAssert.assertThat((Object)this.testMapping(EXPECTED_RESULT, "//*"), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
        MatcherAssert.assertThat((Object)this.testMapping(EXPECTED_RESULT, "/root"), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
    }

    @Test
    public void testSuccess_XmlFragment() {
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, XPATH_FOR_TEST), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
    }

    @Test
    public void testSuccess_XmlWithNamespace() {
        MatcherAssert.assertThat((Object)this.testMapping(XML_WITH_NAMESPACE, XPATH_FOR_TEST), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
        MatcherAssert.assertThat((Object)this.testMapping(XML_WITH_NAMESPACE, "//myPrefix:Street"), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
    }

    @Test
    public void testSuccess_FindAllElements() {
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, "/"), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)EXPECTED_RESULT), (Matcher)CoreMatchers.containsString((String)"Berlin")));
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, "//*"), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)EXPECTED_RESULT), (Matcher)CoreMatchers.containsString((String)"Berlin")));
    }

    @Test
    public void testUserAttributeNames() {
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, XPATH_FOR_TEST, "firstName"), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, XPATH_FOR_TEST, "lastName"), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, XPATH_FOR_TEST, "userAttribute"), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
    }

    @Test
    public void testAttributeNames() {
        Assert.assertNull((Object)this.testMapping(XML_FRAGMENT, XPATH_FOR_TEST, USER_ATTRIBUTE_NAME_FOR_TEST, "attributeNamex"));
        MatcherAssert.assertThat((Object)this.testMapping(XML_FRAGMENT, XPATH_FOR_TEST, USER_ATTRIBUTE_NAME_FOR_TEST, null), (Matcher)CoreMatchers.is((Object)EXPECTED_RESULT));
    }

    private String testMapping(String attributeValue, String xpath) {
        return this.testMapping(attributeValue, xpath, USER_ATTRIBUTE_NAME_FOR_TEST);
    }

    private String testMapping(String attributeValue, String xpath, String attribute) {
        return this.testMapping(attributeValue, xpath, attribute, ATTRIBUTE_NAME);
    }

    private String testMapping(String attributeValue, String xpath, String attribute, String attributeNameToSearch) {
        IdentityProviderMapperModel mapperModel = new IdentityProviderMapperModel();
        HashMap<String, String> config = new HashMap<String, String>();
        mapperModel.setConfig(config);
        config.put("attribute.name", attributeNameToSearch);
        config.put("user.attribute", attribute);
        config.put("attribute.xpath", xpath);
        BrokeredIdentityContext context = new BrokeredIdentityContext("brokeredIdentityContext", new IdentityProviderModel());
        AssertionType assertion = AssertionUtil.createAssertion((String)"assertionId", (NameIDType)NameIDType.deserializeFromString((String)"nameIDType"));
        AttributeStatementType statement = new AttributeStatementType();
        assertion.addStatement((StatementAbstractType)statement);
        AttributeType attributeType = new AttributeType(ATTRIBUTE_NAME);
        attributeType.addAttributeValue((Object)attributeValue);
        statement.addAttribute(new AttributeStatementType.ASTChoiceType(attributeType));
        AttributeType otherAttributeType = new AttributeType("Some other String");
        otherAttributeType.addAttributeValue((Object)"Foobar");
        statement.addAttribute(new AttributeStatementType.ASTChoiceType(otherAttributeType));
        AttributeType booleanAttributeType = new AttributeType("Some boolean");
        booleanAttributeType.addAttributeValue((Object)true);
        statement.addAttribute(new AttributeStatementType.ASTChoiceType(booleanAttributeType));
        AttributeType longAttributeType = new AttributeType("Some long");
        longAttributeType.addAttributeValue((Object)123L);
        statement.addAttribute(new AttributeStatementType.ASTChoiceType(longAttributeType));
        context.getContextData().put("SAML_ASSERTION", assertion);
        new XPathAttributeMapper().preprocessFederatedIdentity(null, null, mapperModel, context);
        Object userAttributes = context.getContextData().get("user.attributes." + attribute);
        return userAttributes == null ? null : ((List)userAttributes).get(0).toString();
    }
}

