/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.url.HostnameV2ProviderFactory;
import org.keycloak.utils.ScopeUtil;

public class HostnameV2ProviderFactoryTest {
    @Test
    public void hostnameUrlValidationTest() throws IOException {
        this.assertHostname("https://my-example.com/auth.this", true);
        this.assertHostname("https://my-example.com:8080", true);
        this.assertHostname("https://my-example.com/auth%20this", true);
        this.assertHostname("my-example.com", true);
        this.assertHostname("192.196.0.0", true);
        this.assertHostname("[2001:0000:130F:0000:0000:09C0:876A:130B]", true);
        this.assertHostname("https://my-example.com?auth.this", false);
        this.assertHostname("my-example.com/auth.this", false);
        this.assertHostname("https://my-example.com:8080#fragment", false);
        this.assertHostname("my-example.com:8080", false);
        this.assertHostname("ldap://my-example.com/auth%20this", false);
        this.assertHostname("?my-example.com", false);
        this.assertHostname("192.196.0.5555", false);
    }

    @Test
    public void hostnameUrlExpected() throws IOException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hostname", "short");
        values.put("hostname-admin", "https://other");
        HostnameV2ProviderFactory factory = new HostnameV2ProviderFactory();
        Assert.assertEquals((Object)"hostname must be set to a URL when hostname-admin is set", (Object)((IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> factory.init((Config.Scope)ScopeUtil.createScope(values)))).getMessage());
    }

    private void assertHostname(String hostname, boolean valid) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hostname", hostname);
        HostnameV2ProviderFactory factory = new HostnameV2ProviderFactory();
        try {
            factory.init((Config.Scope)ScopeUtil.createScope(values));
            Assert.assertTrue((boolean)valid);
        }
        catch (IllegalArgumentException e) {
            Assert.assertFalse((boolean)valid);
        }
    }
}

