/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.userprofile.validator.UsernameProhibitedCharactersValidator;

public class UsernameProhibitedCharactersValidatorTest {
    @Test
    public void allowed() {
        this.assertValid("a");
        this.assertValid("A");
        this.assertValid("z");
        this.assertValid("Z");
        this.assertValid("0");
        this.assertValid("9");
        this.assertValid("\u010d");
        this.assertValid("\u01b1");
        this.assertValid("\u0397");
        this.assertValid(".");
        this.assertValid("-");
        this.assertValid("_");
        this.assertValid("@");
    }

    @Test
    public void disallowed() {
        this.assertInvalid(" ");
        this.assertInvalid("\t");
        this.assertInvalid("\n");
        this.assertInvalid("\f");
        this.assertInvalid("\r");
        this.assertInvalid("\u0000");
        this.assertInvalid("/");
        this.assertInvalid("\\");
        this.assertInvalid("<");
        this.assertInvalid(">");
        this.assertInvalid("'");
        this.assertInvalid("\"");
        this.assertInvalid("&");
        this.assertInvalid("*");
        this.assertInvalid("$");
        this.assertInvalid("%");
        this.assertInvalid("#");
        this.assertInvalid("(");
        this.assertInvalid(")");
        this.assertInvalid("{");
        this.assertInvalid("}");
        this.assertInvalid("|");
        this.assertInvalid("`");
        this.assertInvalid("~");
        this.assertInvalid("^");
        this.assertInvalid("!");
        this.assertInvalid("?");
        this.assertInvalid(":");
        this.assertInvalid(",");
        this.assertInvalid(";");
        this.assertInvalid("\u00a7");
        this.assertInvalid("=");
        this.assertInvalid("as tr");
        this.assertInvalid("\tastr");
        this.assertInvalid("astr\t");
    }

    private void assertValid(String value) {
        Assert.assertTrue((boolean)UsernameProhibitedCharactersValidator.INSTANCE.validate((Object)value).isValid());
    }

    private void assertInvalid(String value) {
        Assert.assertFalse((boolean)UsernameProhibitedCharactersValidator.INSTANCE.validate((Object)value).isValid());
    }
}

