/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.keycloak.services.util.JsonConfigProvider;

public class ScopeUtil {
    public static JsonConfigProvider.JsonScope createScope(Map<String, String> properties) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode config = mapper.readTree(ScopeUtil.json(properties));
            return new JsonConfigProvider.JsonScope(new JsonConfigProvider(config, new Properties()), config);
        }
        catch (IOException e) {
            Assert.fail((String)"Could not parse json");
            return null;
        }
    }

    static String json(Map<String, String> properties) {
        CharSequence[] params = (String[])properties.entrySet().stream().map(e -> ScopeUtil.param((String)e.getKey(), (String)e.getValue())).toArray(String[]::new);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(String.join((CharSequence)",", params));
        sb.append("}");
        return sb.toString();
    }

    static String param(String key, String value) {
        return "\"" + key + "\" : \"" + value + "\"";
    }
}

