/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSession;
import org.keycloak.services.resteasy.ResteasyKeycloakSessionFactory;
import org.keycloak.vault.FilesPlainTextVaultProviderFactory;
import org.keycloak.vault.Scenario;
import org.keycloak.vault.VaultNotFoundException;
import org.keycloak.vault.VaultProvider;

public class PlainTextVaultProviderFactoryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void shouldInitializeVaultCorrectly() {
        VaultConfig config = new VaultConfig(Scenario.EXISTING.getAbsolutePathAsString());
        ResteasyKeycloakSession session = new ResteasyKeycloakSession(new ResteasyKeycloakSessionFactory());
        FilesPlainTextVaultProviderFactory factory = new FilesPlainTextVaultProviderFactory(){

            protected String getRealmName(KeycloakSession session) {
                return "test";
            }
        };
        factory.init((Config.Scope)config);
        VaultProvider provider = factory.create((KeycloakSession)session);
        Assert.assertNotNull((Object)provider);
    }

    @Test
    public void shouldThrowAnExceptionWhenUsingNonExistingDirectory() {
        VaultConfig config = new VaultConfig(Scenario.NON_EXISTING.getAbsolutePathAsString());
        FilesPlainTextVaultProviderFactory factory = new FilesPlainTextVaultProviderFactory();
        this.expectedException.expect(VaultNotFoundException.class);
        factory.init((Config.Scope)config);
    }

    @Test
    public void shouldReturnNullWhenWithNullDirectory() {
        VaultConfig config = new VaultConfig(null);
        FilesPlainTextVaultProviderFactory factory = new FilesPlainTextVaultProviderFactory();
        factory.init((Config.Scope)config);
        VaultProvider provider = factory.create(null);
        Assert.assertNull((Object)provider);
    }

    private static class VaultConfig
    implements Config.Scope {
        private String vaultDirectory;

        public VaultConfig(String vaultDirectory) {
            this.vaultDirectory = vaultDirectory;
        }

        public String get(String key) {
            return "dir".equals(key) ? this.vaultDirectory : null;
        }

        public String get(String key, String defaultValue) {
            throw new UnsupportedOperationException("not implemented");
        }

        public String[] getArray(String key) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Integer getInt(String key) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Integer getInt(String key, Integer defaultValue) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Long getLong(String key) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Long getLong(String key, Long defaultValue) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Boolean getBoolean(String key) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Boolean getBoolean(String key, Boolean defaultValue) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Config.Scope scope(String ... scope) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Set<String> getPropertyNames() {
            throw new UnsupportedOperationException("not implemented");
        }
    }
}

