/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.vault.AbstractVaultProviderFactory;
import org.keycloak.vault.FilesPlainTextVaultProvider;
import org.keycloak.vault.Scenario;
import org.keycloak.vault.SecretContains;
import org.keycloak.vault.VaultRawSecret;

public class PlainTextVaultProviderTest {
    @Test
    public void shouldObtainSecret() throws Exception {
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(Scenario.EXISTING.getPath(), "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        VaultRawSecret secret1 = provider.obtainSecret("key1");
        Assert.assertNotNull((Object)secret1);
        Assert.assertNotNull(secret1.get().get());
        MatcherAssert.assertThat((Object)secret1, SecretContains.secretContains("secret1"));
    }

    @Test
    public void shouldReplaceUnderscoreWithTwoUnderscores() throws Exception {
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(Scenario.EXISTING.getPath(), "test_realm", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        VaultRawSecret secret1 = provider.obtainSecret("underscore_key1");
        Assert.assertNotNull((Object)secret1);
        Assert.assertNotNull(secret1.get().get());
        MatcherAssert.assertThat((Object)secret1, SecretContains.secretContains("underscore_secret1"));
    }

    @Test
    public void shouldReturnEmptyOptionalOnMissingSecret() throws Exception {
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(Scenario.EXISTING.getPath(), "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        VaultRawSecret secret = provider.obtainSecret("non-existing-key");
        Assert.assertNotNull((Object)secret);
        Assert.assertFalse((boolean)secret.get().isPresent());
    }

    @Test
    public void shouldOperateOnNonExistingVaultDirectory() throws Exception {
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(Scenario.NON_EXISTING.getPath(), "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver()));
        VaultRawSecret secret = provider.obtainSecret("non-existing-key");
        Assert.assertNotNull((Object)secret);
        Assert.assertFalse((boolean)secret.get().isPresent());
    }

    @Test
    public void shouldOperateOnRealmDirectory() throws Exception {
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(Scenario.EXISTING.getPath(), "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_FILESEPARATOR_KEY.getVaultKeyResolver()));
        VaultRawSecret secret = provider.obtainSecret("key2");
        Assert.assertNotNull((Object)secret);
        Assert.assertNotNull(secret.get().get());
        MatcherAssert.assertThat((Object)secret, SecretContains.secretContains("secret2"));
    }

    @Test
    public void shouldObtainSecretWithMultipleResolvers() throws Exception {
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(Scenario.EXISTING.getPath(), "test", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.REALM_UNDERSCORE_KEY.getVaultKeyResolver(), AbstractVaultProviderFactory.AvailableResolvers.REALM_FILESEPARATOR_KEY.getVaultKeyResolver()));
        VaultRawSecret secret = provider.obtainSecret("key2");
        Assert.assertNotNull((Object)secret);
        Assert.assertNotNull(secret.get().get());
        MatcherAssert.assertThat((Object)secret, SecretContains.secretContains("secret2"));
    }

    @Test
    public void shouldReflectChangesInASecretFile() throws Exception {
        Path temporarySecretFile = Files.createTempFile("vault", null, new FileAttribute[0]);
        Path vaultDirectory = temporarySecretFile.getParent();
        String secretName = temporarySecretFile.getFileName().toString();
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(vaultDirectory, "ignored", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.KEY_ONLY.getVaultKeyResolver()));
        String secret1AsString = null;
        String secret2AsString = null;
        Files.write(temporarySecretFile, "secret1".getBytes(), new OpenOption[0]);
        try (VaultRawSecret secret1 = provider.obtainSecret(secretName);){
            secret1AsString = StandardCharsets.UTF_8.decode((ByteBuffer)secret1.get().get()).toString();
        }
        Files.write(temporarySecretFile, "secret2".getBytes(), new OpenOption[0]);
        try (VaultRawSecret secret2 = provider.obtainSecret(secretName);){
            secret2AsString = StandardCharsets.UTF_8.decode((ByteBuffer)secret2.get().get()).toString();
        }
        Assert.assertEquals((Object)"secret1", (Object)secret1AsString);
        Assert.assertEquals((Object)"secret2", (Object)secret2AsString);
    }

    @Test
    public void shouldNotOverrideFileWhenDestroyingASecret() throws Exception {
        Path temporarySecretFile = Files.createTempFile("vault", null, new FileAttribute[0]);
        Path vaultDirectory = temporarySecretFile.getParent();
        String secretName = temporarySecretFile.getFileName().toString();
        FilesPlainTextVaultProvider provider = new FilesPlainTextVaultProvider(vaultDirectory, "ignored", Arrays.asList(AbstractVaultProviderFactory.AvailableResolvers.KEY_ONLY.getVaultKeyResolver()));
        Files.write(temporarySecretFile, "secret".getBytes(), new OpenOption[0]);
        VaultRawSecret secretAfterFirstRead = provider.obtainSecret(secretName);
        MatcherAssert.assertThat((Object)secretAfterFirstRead, SecretContains.secretContains("secret"));
        secretAfterFirstRead.close();
        VaultRawSecret secretAfterSecondRead = provider.obtainSecret(secretName);
        MatcherAssert.assertThat((Object)secretAfterFirstRead, (Matcher)CoreMatchers.not(SecretContains.secretContains("secret")));
        MatcherAssert.assertThat((Object)secretAfterSecondRead, SecretContains.secretContains("secret"));
    }
}

