/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.DefaultVaultTranscriber;
import org.keycloak.vault.VaultCharSecret;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultRawSecret;
import org.keycloak.vault.VaultStringSecret;
import org.keycloak.vault.VaultTranscriber;

public class VaultTranscriberTest {
    private final VaultTranscriber transcriber = new DefaultVaultTranscriber((VaultProvider)new TestVaultProvider());
    private static Map<String, String> validExpressions;
    private static String[] invalidExpressions;

    @BeforeClass
    public static void init() {
        validExpressions = new HashMap<String, String>();
        validExpressions.put("${vault.vault_key_1}", "secret1");
        validExpressions.put("${vault.vault_key_2}", "secret2");
        validExpressions.put("${vault.invalid_key}", null);
        validExpressions.put("${vault.${.id-!@#$%^&*_()}}", null);
        invalidExpressions = new String[]{"${vault.}", "$vault.id}", "{vault.id}", "${vault.id", "${vaultid}", ""};
    }

    @Test
    public void testGetRawSecretUsingValidExpressions() {
        ByteBuffer secretBuffer = null;
        byte[] secretArray = null;
        for (String key : validExpressions.keySet()) {
            String expectedSecret = validExpressions.get(key);
            try (VaultRawSecret secret = this.transcriber.getRawSecret(key);){
                Optional optional = secret.get();
                Optional optionalArray = secret.getAsArray();
                if (expectedSecret != null) {
                    Assert.assertTrue((boolean)optional.isPresent());
                    secretBuffer = (ByteBuffer)optional.get();
                    Assert.assertArrayEquals((byte[])expectedSecret.getBytes(StandardCharsets.UTF_8), (byte[])secretBuffer.array());
                    Assert.assertTrue((boolean)optionalArray.isPresent());
                    secretArray = (byte[])optionalArray.get();
                    Assert.assertArrayEquals((byte[])expectedSecret.getBytes(StandardCharsets.UTF_8), (byte[])secretArray);
                } else {
                    Assert.assertFalse((boolean)optional.isPresent());
                    Assert.assertFalse((boolean)optionalArray.isPresent());
                }
            }
            if (expectedSecret == null) continue;
            Assert.assertFalse((boolean)Arrays.equals(expectedSecret.getBytes(StandardCharsets.UTF_8), secretBuffer.array()));
            Assert.assertFalse((boolean)Arrays.equals(expectedSecret.getBytes(StandardCharsets.UTF_8), secretArray));
        }
    }

    @Test
    public void testGetRawSecretUsingInvalidExpressions() {
        for (String value : invalidExpressions) {
            byte[] secretArray;
            ByteBuffer secretBuffer;
            try (VaultRawSecret secret = this.transcriber.getRawSecret(value);){
                Optional optional = secret.get();
                Optional optionalArray = secret.getAsArray();
                Assert.assertTrue((boolean)optional.isPresent());
                secretBuffer = (ByteBuffer)optional.get();
                Assert.assertArrayEquals((byte[])value.getBytes(StandardCharsets.UTF_8), (byte[])secretBuffer.array());
                Assert.assertTrue((boolean)optionalArray.isPresent());
                secretArray = (byte[])optionalArray.get();
                Assert.assertArrayEquals((byte[])value.getBytes(StandardCharsets.UTF_8), (byte[])secretArray);
            }
            if (value.isEmpty()) continue;
            Assert.assertFalse((boolean)Arrays.equals(value.getBytes(StandardCharsets.UTF_8), secretBuffer.array()));
            Assert.assertFalse((boolean)Arrays.equals(value.getBytes(StandardCharsets.UTF_8), secretArray));
        }
    }

    @Test
    public void testGetRawSecretUsingNullExpression() {
        try (VaultRawSecret secret = this.transcriber.getRawSecret(null);){
            Assert.assertFalse((boolean)secret.get().isPresent());
            Assert.assertFalse((boolean)secret.getAsArray().isPresent());
        }
    }

    @Test
    public void testGetCharSecretUsingValidExpressions() {
        CharBuffer secretBuffer = null;
        char[] secretArray = null;
        for (String key : validExpressions.keySet()) {
            String expectedSecret = validExpressions.get(key);
            try (VaultCharSecret secret = this.transcriber.getCharSecret(key);){
                Optional optional = secret.get();
                Optional optionalArray = secret.getAsArray();
                if (expectedSecret != null) {
                    Assert.assertTrue((boolean)optional.isPresent());
                    secretBuffer = (CharBuffer)optional.get();
                    Assert.assertArrayEquals((char[])expectedSecret.toCharArray(), (char[])secretBuffer.array());
                    Assert.assertTrue((boolean)optionalArray.isPresent());
                    secretArray = (char[])optionalArray.get();
                    Assert.assertArrayEquals((char[])expectedSecret.toCharArray(), (char[])secretArray);
                } else {
                    Assert.assertFalse((boolean)optional.isPresent());
                    Assert.assertFalse((boolean)optionalArray.isPresent());
                }
            }
            if (expectedSecret == null) continue;
            Assert.assertFalse((boolean)Arrays.equals(expectedSecret.toCharArray(), secretBuffer.array()));
            Assert.assertFalse((boolean)Arrays.equals(expectedSecret.toCharArray(), secretArray));
        }
    }

    @Test
    public void testGetCharSecretUsingInvalidExpressions() {
        for (String value : invalidExpressions) {
            char[] secretArray;
            CharBuffer secretBuffer;
            try (VaultCharSecret secret = this.transcriber.getCharSecret(value);){
                Optional optional = secret.get();
                Optional optionalArray = secret.getAsArray();
                Assert.assertTrue((boolean)optional.isPresent());
                secretBuffer = (CharBuffer)optional.get();
                Assert.assertArrayEquals((char[])value.toCharArray(), (char[])secretBuffer.array());
                Assert.assertTrue((boolean)optionalArray.isPresent());
                secretArray = (char[])optionalArray.get();
                Assert.assertArrayEquals((char[])value.toCharArray(), (char[])secretArray);
            }
            if (value.isEmpty()) continue;
            Assert.assertFalse((boolean)Arrays.equals(value.toCharArray(), secretBuffer.array()));
            Assert.assertFalse((boolean)Arrays.equals(value.toCharArray(), secretArray));
        }
    }

    @Test
    public void testGetCharSecretUsingNullExpression() {
        try (VaultCharSecret secret = this.transcriber.getCharSecret(null);){
            Assert.assertFalse((boolean)secret.get().isPresent());
            Assert.assertFalse((boolean)secret.getAsArray().isPresent());
        }
    }

    @Test
    public void testGetStringSecretUsingValidExpressions() {
        for (String key : validExpressions.keySet()) {
            String expectedSecret = validExpressions.get(key);
            VaultStringSecret secret = this.transcriber.getStringSecret(key);
            try {
                Optional optional = secret.get();
                if (expectedSecret != null) {
                    Assert.assertTrue((boolean)optional.isPresent());
                    String secretString = (String)optional.get();
                    Assert.assertEquals((Object)expectedSecret, (Object)secretString);
                    continue;
                }
                Assert.assertFalse((boolean)optional.isPresent());
            }
            finally {
                if (secret == null) continue;
                secret.close();
            }
        }
    }

    @Test
    public void testGetStringSecretUsingInvalidExpressions() {
        for (String value : invalidExpressions) {
            try (VaultStringSecret secret = this.transcriber.getStringSecret(value);){
                Optional optional = secret.get();
                Assert.assertTrue((boolean)optional.isPresent());
                String secretString = (String)optional.get();
                Assert.assertEquals((Object)value, (Object)secretString);
            }
        }
    }

    @Test
    public void testGetStringSecretUsingNullExpression() {
        try (VaultStringSecret secret = this.transcriber.getStringSecret(null);){
            Assert.assertFalse((boolean)secret.get().isPresent());
        }
    }

    @Test
    public void testTranscriberWithNullProvider() {
        DefaultVaultTranscriber transcriber = new DefaultVaultTranscriber(null);
        for (String key : validExpressions.keySet()) {
            VaultRawSecret secret = transcriber.getRawSecret(key);
            try {
                Assert.assertFalse((boolean)secret.get().isPresent());
                Assert.assertFalse((boolean)secret.getAsArray().isPresent());
            }
            finally {
                if (secret == null) continue;
                secret.close();
            }
        }
        for (String value : invalidExpressions) {
            try (VaultStringSecret secret = transcriber.getStringSecret(value);){
                Optional optional = secret.get();
                Assert.assertTrue((boolean)optional.isPresent());
                String secretString = (String)optional.get();
                Assert.assertEquals((Object)value, (Object)secretString);
            }
        }
    }

    class TestVaultProvider
    implements VaultProvider {
        private Map<String, byte[]> secrets = new HashMap<String, byte[]>();

        TestVaultProvider() {
            this.secrets.put("vault_key_1", "secret1".getBytes());
            this.secrets.put("vault_key_2", "secret2".getBytes());
        }

        public VaultRawSecret obtainSecret(String vaultSecretId) {
            if (this.secrets.containsKey(vaultSecretId)) {
                return DefaultVaultRawSecret.forBuffer(Optional.of(ByteBuffer.wrap(this.secrets.get(vaultSecretId))));
            }
            return DefaultVaultRawSecret.forBuffer(Optional.empty());
        }

        public void close() {
        }
    }
}

