/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.resource;

import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.resource.representation.UmaResourceRepresentation;
import org.keycloak.authorization.protection.resource.representation.UmaScopeRepresentation;
import org.keycloak.representations.idm.authorization.ResourceOwnerRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.ErrorResponseException;

public class ResourceService {
    private final ResourceServer resourceServer;
    private final ResourceSetService resourceManager;
    private final Identity identity;
    private final AuthorizationProvider authorization;

    public ResourceService(ResourceServer resourceServer, Identity identity, ResourceSetService resourceManager, AuthorizationProvider authorization) {
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.resourceManager = resourceManager;
        this.authorization = authorization;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, UmaResourceRepresentation umaResource) {
        this.checkResourceServerSettings();
        if (umaResource == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return this.resourceManager.create(uriInfo, this.toResourceRepresentation(umaResource), this::toUmaRepresentation);
    }

    @Path(value="{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@Context UriInfo uriInfo, @PathParam(value="id") String id, UmaResourceRepresentation representation) {
        ResourceRepresentation resource = this.toResourceRepresentation(representation);
        Response response = this.resourceManager.update(uriInfo, id, resource);
        if (response.getEntity() instanceof ResourceRepresentation) {
            return Response.noContent().build();
        }
        return response;
    }

    @Path(value="/{id}")
    @DELETE
    public Response delete(@Context UriInfo uriInfo, @PathParam(value="id") String id) {
        this.checkResourceServerSettings();
        return this.resourceManager.delete(uriInfo, id);
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="id") String id) {
        return this.resourceManager.findById(id, resource -> this.toUmaRepresentation((Resource)resource));
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="_id") String id, @QueryParam(value="name") String name, @QueryParam(value="uri") String uri, @QueryParam(value="owner") String owner, @QueryParam(value="type") String type, @QueryParam(value="scope") String scope, @QueryParam(value="deep") Boolean deep, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        return this.resourceManager.find(id, name, uri, owner, type, scope, deep, firstResult, maxResult, (resource, deep1) -> resource.getId());
    }

    private ResourceRepresentation toResourceRepresentation(UmaResourceRepresentation umaResource) {
        ResourceRepresentation resource = new ResourceRepresentation();
        resource.setId(umaResource.getId());
        resource.setIconUri(umaResource.getIconUri());
        resource.setName(umaResource.getName());
        resource.setUri(umaResource.getUri());
        resource.setType(umaResource.getType());
        resource.setOwnerManagedAccess(umaResource.getOwnerManagedAccess());
        ResourceOwnerRepresentation owner = new ResourceOwnerRepresentation();
        String ownerId = umaResource.getOwner();
        if (ownerId == null) {
            ownerId = this.identity.getId();
        }
        owner.setId(ownerId);
        resource.setOwner(owner);
        resource.setScopes(umaResource.getScopes().stream().map(representation -> {
            ScopeRepresentation scopeRepresentation = new ScopeRepresentation();
            scopeRepresentation.setId(representation.getId());
            scopeRepresentation.setName(representation.getName());
            scopeRepresentation.setIconUri(representation.getIconUri());
            return scopeRepresentation;
        }).collect(Collectors.toSet()));
        return resource;
    }

    private UmaResourceRepresentation toUmaRepresentation(Resource model) {
        if (model == null) {
            return null;
        }
        UmaResourceRepresentation resource = new UmaResourceRepresentation();
        resource.setId(model.getId());
        resource.setIconUri(model.getIconUri());
        resource.setName(model.getName());
        resource.setUri(model.getUri());
        resource.setType(model.getType());
        if (model.getOwner() != null) {
            resource.setOwner(model.getOwner());
        }
        resource.setScopes(model.getScopes().stream().map(scopeRepresentation -> {
            UmaScopeRepresentation umaScopeRep = new UmaScopeRepresentation();
            umaScopeRep.setId(scopeRepresentation.getId());
            umaScopeRep.setName(scopeRepresentation.getName());
            umaScopeRep.setIconUri(scopeRepresentation.getIconUri());
            return umaScopeRep;
        }).collect(Collectors.toSet()));
        return resource;
    }

    private void checkResourceServerSettings() {
        if (!this.resourceServer.isAllowRemoteResourceManagement()) {
            throw new ErrorResponseException("not_supported", "Remote management is disabled.", Response.Status.BAD_REQUEST);
        }
    }
}

